/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.TargetResolver;
import net.serenitybdd.screenplay.targets.TargetSelectorWithVariables;

public class XPathOrCssTarget
extends Target {
    private final String cssOrXPathSelector;

    public XPathOrCssTarget(String targetElementName, String cssOrXPathSelector, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.cssOrXPathSelector = cssOrXPathSelector;
    }

    @Override
    public WebElementFacade resolveFor(Actor actor) {
        return TargetResolver.create(BrowseTheWeb.as(actor).getDriver(), this).findBy(this.cssOrXPathSelector);
    }

    @Override
    public List<WebElementFacade> resolveAllFor(Actor actor) {
        return TargetResolver.create(BrowseTheWeb.as(actor).getDriver(), this).findAll(this.cssOrXPathSelector);
    }

    @Override
    public Target of(String ... parameters) {
        return new XPathOrCssTarget(this.instantiated(this.targetElementName, parameters), this.instantiated(this.cssOrXPathSelector, parameters), this.iFrame);
    }

    @Override
    public Target called(String name) {
        return new XPathOrCssTarget(name, this.cssOrXPathSelector, this.iFrame);
    }

    @Override
    public String getCssOrXPathSelector() {
        return this.cssOrXPathSelector;
    }

    private String instantiated(String cssOrXPathSelector, String[] parameters) {
        return new TargetSelectorWithVariables(cssOrXPathSelector).resolvedWith(parameters);
    }
}

