/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.util.Optional;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.Target;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IFrameSwitcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IFrameSwitcher.class);
    private static final ThreadLocal<IFrameSwitcher> frameSwitcher = new ThreadLocal();
    private Optional<IFrame> currentIFrame = Optional.empty();

    static synchronized IFrameSwitcher getInstance() {
        IFrameSwitcher iFrameSwitcher = frameSwitcher.get();
        if (iFrameSwitcher == null) {
            iFrameSwitcher = new IFrameSwitcher();
            frameSwitcher.set(iFrameSwitcher);
        }
        return iFrameSwitcher;
    }

    private IFrameSwitcher() {
    }

    void switchToIFrame(WebDriver driver, Target target) {
        if (target.getIFrame().equals(this.currentIFrame)) {
            LOGGER.debug("{} already selected for {}", (Object)this.printIFrame(this.currentIFrame), (Object)target);
        } else if (!target.getIFrame().isPresent() && this.currentIFrame.isPresent()) {
            LOGGER.debug("switching from {} to {} for {}", new Object[]{this.printIFrame(this.currentIFrame), this.printIFrame(target.getIFrame()), target});
            driver.switchTo().defaultContent();
            this.currentIFrame = Optional.empty();
        } else {
            driver.switchTo().defaultContent();
            target.getIFrame().ifPresent(iFrame -> iFrame.locators.forEach(frameLocator -> driver.switchTo().frame(driver.findElement(frameLocator))));
            this.currentIFrame = target.getIFrame();
        }
    }

    private String printIFrame(Optional<IFrame> frame) {
        return frame.map(IFrame::toString).orElse("default content");
    }
}

