/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.targets.TargetResolver;
import net.serenitybdd.screenplay.targets.TargetSelectorWithVariables;

public class XPathOrCssTarget
extends Target {
    private final String cssOrXPathSelector;

    public XPathOrCssTarget(String targetElementName, String cssOrXPathSelector, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame);
        this.cssOrXPathSelector = cssOrXPathSelector;
    }

    @Override
    public WebElementFacade resolveFor(Actor actor) {
        TargetResolver resolver = TargetResolver.create(BrowseTheWeb.as(actor).getDriver(), this);
        if (this.timeout.isPresent()) {
            return resolver.withTimeoutOf((Duration)this.timeout.get()).find(this.cssOrXPathSelector);
        }
        return resolver.findBy(this.cssOrXPathSelector, new Object[0]);
    }

    @Override
    public List<WebElementFacade> resolveAllFor(Actor actor) {
        TargetResolver resolver = TargetResolver.create(BrowseTheWeb.as(actor).getDriver(), this);
        if (this.timeout.isPresent()) {
            return resolver.withTimeoutOf((Duration)this.timeout.get()).findAll(this.cssOrXPathSelector);
        }
        return resolver.findAll(this.cssOrXPathSelector, new Object[0]);
    }

    @Override
    public Target of(String ... parameters) {
        return new XPathOrCssTarget(this.instantiated(this.targetElementName, parameters), this.instantiated(this.cssOrXPathSelector, parameters), this.iFrame, this.timeout);
    }

    @Override
    public Target called(String name) {
        return new XPathOrCssTarget(name, this.cssOrXPathSelector, this.iFrame, this.timeout);
    }

    @Override
    public String getCssOrXPathSelector() {
        return this.cssOrXPathSelector;
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new XPathOrCssTarget(this.targetElementName, this.cssOrXPathSelector, this.iFrame, Optional.ofNullable(timeout));
    }

    private String instantiated(String cssOrXPathSelector, String[] parameters) {
        return new TargetSelectorWithVariables(cssOrXPathSelector).resolvedWith(parameters);
    }
}

