/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.targets;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.targets.IFrame;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class LambdaTarget
extends Target {
    private final Function<PageObject, List<WebElementFacade>> locationStrategy;
    private Throwable lastThrownException;

    public LambdaTarget(String targetElementName, Function<PageObject, List<WebElementFacade>> locationStrategy, Optional<IFrame> iFrame) {
        super(targetElementName, iFrame);
        this.locationStrategy = locationStrategy;
    }

    public LambdaTarget(String targetElementName, Function<PageObject, List<WebElementFacade>> locationStrategy, Optional<IFrame> iFrame, Optional<Duration> timeout) {
        super(targetElementName, iFrame, timeout);
        this.locationStrategy = locationStrategy;
    }

    @Override
    public WebElementFacade resolveFor(PageObject page) {
        Duration effectiveTimeout = this.timeout.orElse(page.getImplicitWaitTimeout());
        Optional<WebElementFacade> resolvedElement = this.resolveElementFor(page);
        if (resolvedElement.isPresent()) {
            return resolvedElement.get();
        }
        long maxTimeAllowed = effectiveTimeout.toMillis();
        long timeStarted = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeStarted < maxTimeAllowed) {
            resolvedElement = this.resolveElementFor(page);
            if (!resolvedElement.isPresent()) continue;
            return resolvedElement.get();
        }
        if (!resolvedElement.isPresent()) {
            String errorMessage = "No element was found after " + effectiveTimeout.toMillis() / 1000L + "s for " + this.getName();
            StepEventBus.getEventBus().notifyFailure();
            if (this.lastThrownException != null) {
                throw new ElementNotFoundAfterTimeoutError(errorMessage, this.lastThrownException);
            }
            throw new ElementNotFoundAfterTimeoutError(errorMessage);
        }
        return resolvedElement.get();
    }

    @NotNull
    private Optional<WebElementFacade> resolveElementFor(PageObject page) {
        this.lastThrownException = null;
        try {
            return this.locationStrategy.apply(page).stream().findFirst();
        }
        catch (Throwable exception) {
            this.lastThrownException = exception;
            return Optional.empty();
        }
    }

    @Override
    public List<WebElementFacade> resolveAllFor(PageObject page) {
        List<WebElementFacade> resolvedElements = this.locationStrategy.apply(page);
        if (this.timeout.isPresent()) {
            if (resolvedElements.isEmpty()) {
                return resolvedElements;
            }
            Duration effectiveTimeout = this.timeout.orElse(page.getImplicitWaitTimeout());
            long maxTimeAllowed = effectiveTimeout.toMillis();
            long timeStarted = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeStarted < maxTimeAllowed) {
                resolvedElements = this.locationStrategy.apply(page);
                if (resolvedElements.isEmpty()) continue;
                return resolvedElements;
            }
        }
        return resolvedElements;
    }

    @Override
    public SearchableTarget of(String ... parameters) {
        throw new UnsupportedOperationException("The of() method is not supported for By-type Targets");
    }

    @Override
    public String getCssOrXPathSelector() {
        throw new UnsupportedOperationException("The getCssOrXPathSelector() method is not supported for lambda-type Targets");
    }

    @Override
    public Target waitingForNoMoreThan(Duration timeout) {
        return new LambdaTarget(this.targetElementName, this.locationStrategy, this.iFrame, Optional.ofNullable(timeout));
    }

    @Override
    public List<By> selectors(WebDriver driver) {
        throw new UnsupportedOperationException("Nested locators are not supported with this kind of locator: " + this);
    }

    @Override
    public LambdaTarget called(String name) {
        return new LambdaTarget(name, this.locationStrategy, this.iFrame, this.timeout);
    }
}

