/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import net.serenitybdd.screenplay.ui.LocatorStrategies;

public class InputField {
    private static final String BY_ID_OR_NAME = "css:input[id='{0}' i],input[name='{0}' i],input[class*='{0}' i],input[data-test='{0}' i],textarea[id='{0}' i],textarea[name='{0}' i],textarea[data-test='{0}' i],[placeholder='{0}' i]";

    public static SearchableTarget called(String name) {
        return Target.the("the '" + name + "' field").locatedBy(BY_ID_OR_NAME).of(name);
    }

    public static SearchableTarget withPlaceholder(String placeholderName) {
        String placeholderAttribute = CSSAttributeValue.withEscapedQuotes(placeholderName);
        return Target.the("'" + placeholderName + "' field").locatedBy("css:[placeholder='{0}']").of(placeholderAttribute);
    }

    public static Target withLabel(String labelText) {
        return Target.the(labelText + " field").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }
}

