/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.core.pages.RenderedPageObjectView;
import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.PageElementBuilder;

public class PageElement {
    private static final String BY_ID_NAME_OR_CLASS = "css:[id='{0}' i],[name='{0}' i],[data-test='{0}' i],[class*='{0}']";
    private static final String STRICTLY_CONTAINS_TEXT = "xpath:.//*[contains(text(),'{0}')]";

    public static SearchableTarget called(String name) {
        return Target.the("the '" + name + "' element").locatedBy(BY_ID_NAME_OR_CLASS).of(name);
    }

    public static SearchableTarget containingText(String text) {
        return Target.the("the element containing text '" + text + "'").locatedBy(STRICTLY_CONTAINS_TEXT).of(text);
    }

    public static Target containingText(String cssOrXPathLocator, String text) {
        return Target.the("the element containing text '" + text + "'").locatedBy(RenderedPageObjectView.containingTextAndMatchingCSS((String)cssOrXPathLocator, (String)text));
    }

    public static PageElementBuilder locatedBy(String selector) {
        return new PageElementBuilder(selector);
    }
}

