/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import net.serenitybdd.annotations.Step;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.actions.UnknownPageException;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;

public class OpenPageWithName
implements Interaction {
    private String pageName;
    private EnvironmentVariables environmentVariables;

    public OpenPageWithName() {
    }

    public OpenPageWithName(String pageName) {
        this.pageName = pageName;
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    @Step(value="{0} opens the #pageName page")
    public <T extends Actor> void performAs(T theUser) {
        String pageUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{this.pageName}).orElse(this.environmentVariables.getProperty(this.pageName));
        if (pageUrl == null) {
            throw new UnknownPageException("No page defined with the name '" + pageUrl + "'");
        }
        BrowseTheWeb.as(theUser).getDriver().get(pageUrl);
    }
}

