/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.FailedConsequence;

public class ErrorTally {
    private final EventBusInterface eventBusInterface;
    private final List<FailedConsequence> errors;

    public ErrorTally(EventBusInterface eventBusInterface) {
        this.eventBusInterface = eventBusInterface;
        this.errors = Lists.newArrayList();
    }

    public void recordError(Consequence consequence, Throwable cause) {
        this.errors.add(new FailedConsequence(consequence, cause));
        this.eventBusInterface.reportStepFailureFor(consequence, cause);
    }

    public void reportAnyErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        if (Serenity.shouldThrowErrorsImmediately()) {
            this.throwSummaryExceptionFrom(this.errorCausesIn(this.errors));
        }
    }

    private void throwSummaryExceptionFrom(List<Throwable> errorCauses) {
        String overallErrorMessage = Joiner.on((String)System.lineSeparator()).join(this.errorMessagesIn(errorCauses));
        throw new AssertionError((Object)overallErrorMessage);
    }

    private List<Throwable> errorCausesIn(List<FailedConsequence> failedConsequences) {
        ArrayList causes = Lists.newArrayList();
        for (FailedConsequence consequence : failedConsequences) {
            causes.add(consequence.getCause());
        }
        return causes;
    }

    private List<String> errorMessagesIn(List<Throwable> errorCauses) {
        ArrayList errorMessages = Lists.newArrayList();
        for (Throwable cause : errorCauses) {
            errorMessages.add(cause.getMessage());
        }
        return errorMessages;
    }
}

