/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.Uninstrumented;
import net.serenitybdd.screenplay.annotations.AnnotatedTitle;
import net.serenitybdd.screenplay.annotations.Subject;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class QuestionSubject<T> {
    private final Class<? extends Question> questionClass;
    private Question<T> question;

    public static <T> QuestionSubject<T> fromClass(Class<?> questionClass) {
        return new QuestionSubject<T>(questionClass);
    }

    public QuestionSubject(Class<? extends Question> questionClass) {
        this.questionClass = Uninstrumented.versionOf(questionClass);
    }

    public QuestionSubject andQuestion(Question question) {
        this.question = question;
        return this;
    }

    private Optional<String> annotatedSubject() {
        if (this.annotationOnMethodOf(this.questionClass).isPresent()) {
            return (Optional)Optional.of(this.annotationOnMethodOf(this.questionClass)).get();
        }
        return this.annotatedSubjectFromClass(this.questionClass);
    }

    private Optional<String> annotatedSubjectFromClass(Class<?> questionClass) {
        if (questionClass.getAnnotation(Subject.class) != null) {
            return (Optional)Optional.of(this.annotationOnClass(questionClass)).get();
        }
        if (questionClass.getSuperclass() != null) {
            return this.annotatedSubjectFromClass(questionClass.getSuperclass());
        }
        return Optional.absent();
    }

    private Optional<String> annotationOnMethodOf(Class<? extends Question> questionClass) {
        try {
            Method answeredBy = questionClass.getMethod("answeredBy", Actor.class);
            if (answeredBy.getAnnotation(Subject.class) != null) {
                String annotatedTitle = answeredBy.getAnnotation(Subject.class).value();
                annotatedTitle = AnnotatedTitle.injectFieldsInto(annotatedTitle).using(this.question);
                return Optional.of((Object)annotatedTitle);
            }
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
        return Optional.absent();
    }

    private Optional<String> annotationOnClass(Class<?> questionClass) {
        if (questionClass.getAnnotation(Subject.class) != null) {
            String annotatedTitle = questionClass.getAnnotation(Subject.class).value();
            annotatedTitle = AnnotatedTitle.injectFieldsInto(annotatedTitle).using(this.question);
            return Optional.of((Object)annotatedTitle);
        }
        return Optional.absent();
    }

    public String subject() {
        return (String)this.annotatedSubject().or((Object)StringUtils.lowerCase((String)NameConverter.humanize((String)this.questionClass.getSimpleName())));
    }
}

