/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.time.Stopwatch;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.CanBeSilent;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventualConsequenceBuilder;
import net.serenitybdd.screenplay.Performable;

public class EventualConsequence<T>
implements Consequence<T>,
CanBeSilent {
    public static final int A_SHORT_PERIOD_BETWEEN_TRIES = 100;
    private final Consequence<T> consequenceThatMightTakeSomeTime;
    private final long timeout;
    private final boolean isSilent;
    private AssertionError caughtAssertionError = null;
    private RuntimeException caughtRuntimeException = null;

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime, long timeout) {
        this(consequenceThatMightTakeSomeTime, timeout, false);
    }

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime, long timeout, boolean isSilent) {
        this.consequenceThatMightTakeSomeTime = consequenceThatMightTakeSomeTime;
        this.timeout = timeout;
        this.isSilent = isSilent;
    }

    public EventualConsequence(Consequence<T> consequenceThatMightTakeSomeTime) {
        this(consequenceThatMightTakeSomeTime, ConfiguredEnvironment.getConfiguration().getElementTimeout() * 1000);
    }

    public static <T> EventualConsequence<T> eventually(Consequence<T> consequenceThatMightTakeSomeTime) {
        return new EventualConsequence<T>(consequenceThatMightTakeSomeTime);
    }

    public EventualConsequenceBuilder<T> waitingForNoLongerThan(long amount) {
        return new EventualConsequenceBuilder(this.consequenceThatMightTakeSomeTime, amount);
    }

    @Override
    public void evaluateFor(Actor actor) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        do {
            try {
                this.consequenceThatMightTakeSomeTime.evaluateFor(actor);
                return;
            }
            catch (AssertionError assertionError) {
                this.caughtAssertionError = assertionError;
            }
            catch (RuntimeException runtimeException) {
                this.caughtRuntimeException = runtimeException;
            }
            this.pauseBeforeNextAttempt();
        } while (stopwatch.lapTime() < this.timeout);
        this.throwAnyCaughtErrors();
    }

    private void pauseBeforeNextAttempt() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void throwAnyCaughtErrors() {
        if (this.caughtAssertionError != null) {
            throw this.caughtAssertionError;
        }
        if (this.caughtRuntimeException != null) {
            throw this.caughtRuntimeException;
        }
    }

    public String toString() {
        return this.consequenceThatMightTakeSomeTime.toString();
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.orComplainWith(complaintType));
    }

    @Override
    public Consequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.orComplainWith(complaintType, complaintDetails));
    }

    @Override
    public Consequence<T> whenAttemptingTo(Performable performable) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.whenAttemptingTo(performable));
    }

    @Override
    public Consequence<T> because(String explanation) {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime.because(explanation));
    }

    @Override
    public boolean isSilent() {
        return this.isSilent;
    }

    public EventualConsequence<T> withNoReporting() {
        return new EventualConsequence<T>(this.consequenceThatMightTakeSomeTime, this.timeout, true);
    }
}

