/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;

public class Cast {
    private final List<Ability> standardAbilities;
    private final List<Consumer<Actor>> abilityProviders;
    Map<String, Actor> actors = new HashMap<String, Actor>();

    public Cast(Ability[] abilities) {
        this.standardAbilities = Arrays.asList(abilities);
        this.abilityProviders = new ArrayList<Consumer<Actor>>();
    }

    public Cast(Consumer<Actor> ... providers) {
        this.standardAbilities = new ArrayList<Ability>();
        this.abilityProviders = Arrays.asList(providers);
    }

    public static Cast ofStandardActors() {
        return new Cast(new Consumer[0]);
    }

    public static Cast whereEveryoneCan(Ability ... abilities) {
        return new Cast(abilities);
    }

    public static Cast whereEveryoneCan(Consumer<Actor> ... abilities) {
        return new Cast(abilities);
    }

    public Actor actorNamed(String actorName, Ability ... abilities) {
        if (!this.actors.containsKey(actorName)) {
            Actor newActor = Actor.named(actorName);
            for (Ability doSomething : abilities) {
                newActor.can(doSomething);
            }
            this.assignGeneralAbilitiesTo(newActor);
            this.actors.put(actorName, newActor);
        }
        return this.actors.get(actorName);
    }

    public List<Actor> getActors() {
        return NewList.copyOf(this.actors.values());
    }

    public void dismissAll() {
        this.actors.clear();
    }

    protected void assignGeneralAbilitiesTo(Actor newActor) {
        this.standardAbilities.forEach(newActor::whoCan);
        this.abilityProviders.forEach(ability -> ability.accept(newActor));
    }
}

