/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Optional;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.RecordsInputs;
import net.thucydides.core.steps.StepEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConsequence<T>
implements Consequence<T> {
    private Class<? extends Error> complaintType;
    private String complaintDetails;
    protected Optional<Performable> optionalPrecondition = Optional.empty();
    protected Optional<String> explanation = Optional.empty();
    protected Optional<String> subjectText = Optional.empty();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    protected Error errorFrom(Throwable actualError) {
        if (actualError instanceof Error) {
            return (Error)actualError;
        }
        return new Error(actualError);
    }

    protected void throwComplaintTypeErrorIfSpecified(Error actualError) {
        if (this.complaintType != null) {
            throw Complaint.from(this.complaintType, this.complaintDetails, actualError);
        }
    }

    protected boolean thisStepShouldBeIgnored() {
        return StepEventBus.getEventBus().currentTestIsSuspended() || StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType) {
        return this.orComplainWith((Class)complaintType, (String)null);
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        this.complaintType = complaintType;
        this.complaintDetails = complaintDetails;
        return this;
    }

    @Override
    public Consequence<T> whenAttemptingTo(Performable performable) {
        this.optionalPrecondition = Optional.of(performable);
        return this;
    }

    @Override
    public Consequence<T> because(String explanation) {
        this.explanation = Optional.ofNullable(explanation);
        return this;
    }

    protected Optional<String> inputValues() {
        if (!this.optionalPrecondition.isPresent()) {
            return Optional.empty();
        }
        if (!(this.optionalPrecondition.get() instanceof RecordsInputs)) {
            return Optional.empty();
        }
        return Optional.of(((RecordsInputs)((Object)this.optionalPrecondition.get())).getInputValues());
    }

    protected String addRecordedInputValuesTo(String message) {
        if (!this.inputValues().isPresent()) {
            return message;
        }
        return message + " [" + this.inputValues().get() + "]";
    }
}

