/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.spring.integration;

import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;

class SpringIntegrationRuleBase {
    private boolean runPrepareTestInstance;
    private TestContextManager testContextManager;

    protected SpringIntegrationRuleBase() {
        this.setupInner(true, null);
    }

    void setup(boolean runPrepareTestInstance, TestContextManager testContextManager) {
        this.setupInner(runPrepareTestInstance, testContextManager);
    }

    private void setupInner(boolean runPrepareTestInstance, TestContextManager testContextManager) {
        this.runPrepareTestInstance = runPrepareTestInstance;
        this.testContextManager = testContextManager;
    }

    public static TestContextManager createTestContextManager(Class<?> testClass) {
        return new TestContextManager(testClass);
    }

    public TestContextManager getTestContextManager(Class<?> testClass) {
        if (this.testContextManager == null) {
            this.testContextManager = SpringIntegrationRuleBase.createTestContextManager(testClass);
        }
        return this.testContextManager;
    }

    protected Statement apply(Statement next, Class<?> testClass, Object testInstance, StatementWrapper beforeWrapper, StatementWrapper afterWrapper) {
        TestContextManager testContextManagerLocal = this.getTestContextManager(testClass);
        if (this.runPrepareTestInstance && testInstance != null) {
            try {
                testContextManagerLocal.prepareTestInstance(testInstance);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate test instance", e);
            }
        }
        return afterWrapper.apply(beforeWrapper.apply(next, testContextManagerLocal), testContextManagerLocal);
    }

    protected static interface StatementWrapper {
        public Statement apply(Statement var1, TestContextManager var2);
    }
}

