/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.hamcrest;

import java.util.Arrays;
import java.util.List;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class XMLIsSimilarMatcher
extends TypeSafeMatcher<String> {
    private String xmlDocument;
    private String errorMessage = "";
    private List<String> excludedNodes;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLIsSimilarMatcher.class);

    public XMLIsSimilarMatcher(String xmlDocument, String ... excludedNodes) {
        this.xmlDocument = xmlDocument;
        this.excludedNodes = Arrays.asList(excludedNodes);
    }

    public boolean matchesSafely(String expectedXML) {
        boolean xmlIsSimilar = true;
        Diff difference = null;
        try {
            XMLUnit.setIgnoreAttributeOrder((boolean)true);
            XMLUnit.setIgnoreComments((boolean)true);
            XMLUnit.setIgnoreWhitespace((boolean)true);
            difference = new Diff(this.xmlDocument, expectedXML);
            difference.overrideDifferenceListener(new DifferenceListener(){

                public int differenceFound(Difference difference) {
                    if (XMLIsSimilarMatcher.this.excludedNodes.contains(difference.getControlNodeDetail().getNode().getLocalName())) {
                        return 1;
                    }
                    return 0;
                }

                public void skippedComparison(Node node, Node node2) {
                }
            });
            xmlIsSimilar = difference.similar();
        }
        catch (Exception e) {
            xmlIsSimilar = false;
            LOGGER.info(e.getMessage());
        }
        if (!xmlIsSimilar) {
            this.recordErrorMessage(difference);
        }
        return xmlIsSimilar;
    }

    private void recordErrorMessage(Diff difference) {
        StringBuffer buffer = new StringBuffer();
        if (difference != null) {
            buffer = difference.appendMessage(buffer);
        }
        this.errorMessage = buffer.toString();
    }

    public void describeTo(Description description) {
        description.appendText("an XML document equivalent to ").appendText(this.xmlDocument);
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            description.appendText("[").appendText(this.errorMessage).appendText("]");
        }
    }
}

