// $ANTLR 3.5.1 cz/vutbr/web/csskit/antlr/CSSTreeParser.g 2014-02-04 13:14:53

package cz.vutbr.web.csskit.antlr;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermExpression;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.RuleBlock.Priority;

// @SuppressWarnings("unchecked")


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CSSTreeParser extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ADJACENT", "APOS", "ASTERISK", 
		"ATBLOCK", "ATKEYWORD", "ATTRIBUTE", "BRACEBLOCK", "CDC", "CDO", "CHARSET", 
		"CHILD", "CLASSKEYWORD", "COLON", "COMMA", "COMMENT", "CONTAINS", "CTRL", 
		"CTRL_CHAR", "CURLYBLOCK", "DASHMATCH", "DECLARATION", "DESCENDANT", "DIMENSION", 
		"ELEMENT", "ENDSWITH", "EQUALS", "ESCAPE_CHAR", "EXCLAMATION", "EXPRESSION", 
		"FONTFACE", "FUNCTION", "GREATER", "HASH", "IDENT", "IDENT_MACR", "IMPORT", 
		"IMPORTANT", "IMPORT_END", "INCLUDES", "INDEX", "INLINESTYLE", "INTEGER_MACR", 
		"INVALID_DECLARATION", "INVALID_DIRECTIVE", "INVALID_IMPORT", "INVALID_SELECTOR", 
		"INVALID_SELPART", "INVALID_STATEMENT", "INVALID_STRING", "INVALID_TOKEN", 
		"LBRACE", "LCURLY", "LESS", "LPAREN", "MARGIN_AREA", "MEDIA", "MINUS", 
		"NAME_CHAR", "NAME_MACR", "NAME_START", "NL_CHAR", "NON_ASCII", "NUMBER", 
		"NUMBER_MACR", "PAGE", "PARENBLOCK", "PERCENT", "PERCENTAGE", "PLUS", 
		"PRECEDING", "PSEUDO", "QUESTION", "QUOT", "RBRACE", "RCURLY", "RPAREN", 
		"RULE", "S", "SELECTOR", "SEMICOLON", "SET", "SLASH", "SL_COMMENT", "STARTSWITH", 
		"STRING", "STRING_CHAR", "STRING_MACR", "STYLESHEET", "TILDE", "UNIRANGE", 
		"URI", "URI_CHAR", "URI_MACR", "VALUE", "VIEWPORT", "W_CHAR", "W_MACR", 
		"'#'", "'^'", "'important'"
	};
	public static final int EOF=-1;
	public static final int T__101=101;
	public static final int T__102=102;
	public static final int T__103=103;
	public static final int ADJACENT=4;
	public static final int APOS=5;
	public static final int ASTERISK=6;
	public static final int ATBLOCK=7;
	public static final int ATKEYWORD=8;
	public static final int ATTRIBUTE=9;
	public static final int BRACEBLOCK=10;
	public static final int CDC=11;
	public static final int CDO=12;
	public static final int CHARSET=13;
	public static final int CHILD=14;
	public static final int CLASSKEYWORD=15;
	public static final int COLON=16;
	public static final int COMMA=17;
	public static final int COMMENT=18;
	public static final int CONTAINS=19;
	public static final int CTRL=20;
	public static final int CTRL_CHAR=21;
	public static final int CURLYBLOCK=22;
	public static final int DASHMATCH=23;
	public static final int DECLARATION=24;
	public static final int DESCENDANT=25;
	public static final int DIMENSION=26;
	public static final int ELEMENT=27;
	public static final int ENDSWITH=28;
	public static final int EQUALS=29;
	public static final int ESCAPE_CHAR=30;
	public static final int EXCLAMATION=31;
	public static final int EXPRESSION=32;
	public static final int FONTFACE=33;
	public static final int FUNCTION=34;
	public static final int GREATER=35;
	public static final int HASH=36;
	public static final int IDENT=37;
	public static final int IDENT_MACR=38;
	public static final int IMPORT=39;
	public static final int IMPORTANT=40;
	public static final int IMPORT_END=41;
	public static final int INCLUDES=42;
	public static final int INDEX=43;
	public static final int INLINESTYLE=44;
	public static final int INTEGER_MACR=45;
	public static final int INVALID_DECLARATION=46;
	public static final int INVALID_DIRECTIVE=47;
	public static final int INVALID_IMPORT=48;
	public static final int INVALID_SELECTOR=49;
	public static final int INVALID_SELPART=50;
	public static final int INVALID_STATEMENT=51;
	public static final int INVALID_STRING=52;
	public static final int INVALID_TOKEN=53;
	public static final int LBRACE=54;
	public static final int LCURLY=55;
	public static final int LESS=56;
	public static final int LPAREN=57;
	public static final int MARGIN_AREA=58;
	public static final int MEDIA=59;
	public static final int MINUS=60;
	public static final int NAME_CHAR=61;
	public static final int NAME_MACR=62;
	public static final int NAME_START=63;
	public static final int NL_CHAR=64;
	public static final int NON_ASCII=65;
	public static final int NUMBER=66;
	public static final int NUMBER_MACR=67;
	public static final int PAGE=68;
	public static final int PARENBLOCK=69;
	public static final int PERCENT=70;
	public static final int PERCENTAGE=71;
	public static final int PLUS=72;
	public static final int PRECEDING=73;
	public static final int PSEUDO=74;
	public static final int QUESTION=75;
	public static final int QUOT=76;
	public static final int RBRACE=77;
	public static final int RCURLY=78;
	public static final int RPAREN=79;
	public static final int RULE=80;
	public static final int S=81;
	public static final int SELECTOR=82;
	public static final int SEMICOLON=83;
	public static final int SET=84;
	public static final int SLASH=85;
	public static final int SL_COMMENT=86;
	public static final int STARTSWITH=87;
	public static final int STRING=88;
	public static final int STRING_CHAR=89;
	public static final int STRING_MACR=90;
	public static final int STYLESHEET=91;
	public static final int TILDE=92;
	public static final int UNIRANGE=93;
	public static final int URI=94;
	public static final int URI_CHAR=95;
	public static final int URI_MACR=96;
	public static final int VALUE=97;
	public static final int VIEWPORT=98;
	public static final int W_CHAR=99;
	public static final int W_MACR=100;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public CSSTreeParser(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSTreeParser(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CSSTreeParser.tokenNames; }
	@Override public String getGrammarFileName() { return "cz/vutbr/web/csskit/antlr/CSSTreeParser.g"; }


		private static Logger log = LoggerFactory.getLogger(CSSTreeParser.class);

		private static RuleFactory rf = CSSFactory.getRuleFactory();
		private static TermFactory tf = CSSFactory.getTermFactory();
		private static SupportedCSS css = CSSFactory.getSupportedCSS();

		private static class TreeParserState {
		    public List<String> media;
			
			public TreeParserState(String media) {
				if(media==null || media.length()==0)
				    this.media = Collections.emptyList();
				else	
			    	this.media = Arrays.asList(media.split(","));
			}
			
			public boolean doWrap() {
			   return !media.isEmpty();
			}
			
			@Override
			public String toString() {
			    return media.toString();
			}
		}

	    // block preparator
		private Preparator preparator;
		
		private StyleSheet stylesheet;

		private Stack<TreeParserState> imports;	
	       
	    public CSSTreeParser init(StyleSheet sheet, Preparator preparator) {
		    this.stylesheet = sheet;
			this.preparator = preparator;
			this.imports = new Stack<TreeParserState>();
			return this;
		}   
	       
	    @Override
		public void emitErrorMessage(String msg) {
		    log.info("ANTLR: {}", msg);
		}
			
		private String extractText(CommonTree token) {
	        return token.getText();
	    }
	   
	  private URL extractBase(CommonTree token) {
	      CSSToken ct = (CSSToken) token.getToken();
	      return ct.getBase();
	  }
	    	
	  private Declaration.Source extractSource(CommonTree token) {
	      CSSToken ct = (CSSToken) token.getToken();
	      Declaration.Source src = new Declaration.Source(ct.getBase(), ct.getLine(), ct.getCharPositionInLine());
	      return src;
	  }   
			
	    private void logEnter(String entry) {
	        log.trace("Entering '{}'", entry);
	    }
	    	
	    private void logLeave(String leaving) {
		    log.trace("Leaving '{}'", leaving);
	    }



	// $ANTLR start "inlinestyle"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:111:1: inlinestyle returns [StyleSheet sheet] : ( ^( INLINESTYLE decl= declarations ) | ^( INLINESTYLE (irs= inlineset )+ ) );
	public final StyleSheet inlinestyle() throws RecognitionException {
		StyleSheet sheet = null;


		List<Declaration> decl =null;
		RuleBlock<?> irs =null;


			logEnter("inlinestyle");
			sheet = this.stylesheet;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:122:2: ( ^( INLINESTYLE decl= declarations ) | ^( INLINESTYLE (irs= inlineset )+ ) )
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==INLINESTYLE) ) {
				int LA2_1 = input.LA(2);
				if ( (LA2_1==DOWN) ) {
					int LA2_2 = input.LA(3);
					if ( (LA2_2==SET) ) {
						alt2=1;
					}
					else if ( (LA2_2==RULE) ) {
						alt2=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 2, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}

			switch (alt2) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:122:5: ^( INLINESTYLE decl= declarations )
					{
					match(input,INLINESTYLE,FOLLOW_INLINESTYLE_in_inlinestyle59); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_inlinestyle63);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 


								RuleBlock<?> rb = preparator.prepareInlineRuleSet(decl, null);
								if(rb!=null) {
								     sheet.add(rb);
								}
							
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:129:6: ^( INLINESTYLE (irs= inlineset )+ )
					{
					match(input,INLINESTYLE,FOLLOW_INLINESTYLE_in_inlinestyle78); 
					match(input, Token.DOWN, null); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:130:5: (irs= inlineset )+
					int cnt1=0;
					loop1:
					while (true) {
						int alt1=2;
						int LA1_0 = input.LA(1);
						if ( (LA1_0==RULE) ) {
							alt1=1;
						}

						switch (alt1) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:130:6: irs= inlineset
							{
							pushFollow(FOLLOW_inlineset_in_inlinestyle88);
							irs=inlineset();
							state._fsp--;

							if(irs!=null) sheet.add(irs);
							}
							break;

						default :
							if ( cnt1 >= 1 ) break loop1;
							EarlyExitException eee = new EarlyExitException(1, input);
							throw eee;
						}
						cnt1++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}

				log.debug("\n***\n{}\n***\n", sheet);	   
				// mark last usage
				sheet.markLast(preparator.markPriority());
				logLeave("inlinestyle");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return sheet;
	}
	// $ANTLR end "inlinestyle"



	// $ANTLR start "stylesheet"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:137:1: stylesheet returns [StyleSheet sheet] : ^( STYLESHEET (s= statement )* ) ;
	public final StyleSheet stylesheet() throws RecognitionException {
		StyleSheet sheet = null;


		RuleBlock<?> s =null;


			logEnter("stylesheet");
			sheet = this.stylesheet;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:148:2: ( ^( STYLESHEET (s= statement )* ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:148:4: ^( STYLESHEET (s= statement )* )
			{
			match(input,STYLESHEET,FOLLOW_STYLESHEET_in_stylesheet125); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:149:4: (s= statement )*
				loop3:
				while (true) {
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0==CHARSET||LA3_0==FONTFACE||LA3_0==IMPORT||LA3_0==IMPORT_END||LA3_0==INVALID_IMPORT||LA3_0==INVALID_STATEMENT||LA3_0==MEDIA||LA3_0==PAGE||LA3_0==RULE||LA3_0==VIEWPORT) ) {
						alt3=1;
					}

					switch (alt3) {
					case 1 :
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:149:5: s= statement
						{
						pushFollow(FOLLOW_statement_in_stylesheet134);
						s=statement();
						state._fsp--;

						 if(s!=null) sheet.add(s);
						}
						break;

					default :
						break loop3;
					}
				}

				match(input, Token.UP, null); 
			}

			}


				log.debug("\n***\n{}\n***\n", sheet);
				// mark last usage
				sheet.markLast(preparator.markPriority());
				logLeave("stylesheet");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return sheet;
	}
	// $ANTLR end "stylesheet"


	protected static class statement_scope {
		boolean invalid;
		boolean insideAtstatement;
	}
	protected Stack<statement_scope> statement_stack = new Stack<statement_scope>();


	// $ANTLR start "statement"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:156:1: statement returns [RuleBlock<?> stm] : (rs= ruleset |ats= atstatement | INVALID_STATEMENT );
	public final RuleBlock<?> statement() throws RecognitionException {
		statement_stack.push(new statement_scope());
		RuleBlock<?> stm = null;


		RuleBlock<?> rs =null;
		RuleBlock<?> ats =null;


			logEnter("statement");
			statement_stack.peek().invalid = false;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:174:2: (rs= ruleset |ats= atstatement | INVALID_STATEMENT )
			int alt4=3;
			switch ( input.LA(1) ) {
			case RULE:
				{
				alt4=1;
				}
				break;
			case CHARSET:
			case FONTFACE:
			case IMPORT:
			case IMPORT_END:
			case INVALID_IMPORT:
			case MEDIA:
			case PAGE:
			case VIEWPORT:
				{
				alt4=2;
				}
				break;
			case INVALID_STATEMENT:
				{
				alt4=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:174:4: rs= ruleset
					{
					pushFollow(FOLLOW_ruleset_in_statement183);
					rs=ruleset();
					state._fsp--;

					stm =(RuleBlock<?>) rs;
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:175:4: ats= atstatement
					{
					pushFollow(FOLLOW_atstatement_in_statement193);
					ats=atstatement();
					state._fsp--;

					stm =(RuleBlock<?>) ats;
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:176:4: INVALID_STATEMENT
					{
					match(input,INVALID_STATEMENT,FOLLOW_INVALID_STATEMENT_in_statement200); 
					 statement_stack.peek().invalid = true; 
					}
					break;

			}

			  if (statement_stack.peek().invalid)
			      log.debug("Statement is invalid");
				logLeave("statement");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			statement_stack.pop();
		}
		return stm;
	}
	// $ANTLR end "statement"


	protected static class atstatement_scope {
		RuleBlock<?> stm;
	}
	protected Stack<atstatement_scope> atstatement_stack = new Stack<atstatement_scope>();


	// $ANTLR start "atstatement"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:180:1: atstatement returns [RuleBlock<?> stmnt] : ( CHARSET | INVALID_IMPORT |i= IMPORT | IMPORT_END | ^( PAGE (i= IDENT )? ( ^( PSEUDO i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) ) | ^( VIEWPORT decl= declarations ) | ^( FONTFACE decl= declarations ) | ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* ) );
	public final RuleBlock<?> atstatement() throws RecognitionException {
		atstatement_stack.push(new atstatement_scope());
		RuleBlock<?> stmnt = null;


		CommonTree i=null;
		List<Declaration> decl =null;
		RuleMargin m =null;
		List<String> mediaList =null;
		RuleBlock<?> rs =null;


		    logEnter("atstatement");
			statement_stack.peek().insideAtstatement =true;
			atstatement_stack.peek().stm = stmnt = null;
			List<RuleSet> rules = null;
			List<RuleMargin> margins = null;
			String name = null;
			String pseudo = null;
			Priority mark = preparator.markPriority();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:197:2: ( CHARSET | INVALID_IMPORT |i= IMPORT | IMPORT_END | ^( PAGE (i= IDENT )? ( ^( PSEUDO i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) ) | ^( VIEWPORT decl= declarations ) | ^( FONTFACE decl= declarations ) | ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* ) )
			int alt10=8;
			switch ( input.LA(1) ) {
			case CHARSET:
				{
				alt10=1;
				}
				break;
			case INVALID_IMPORT:
				{
				alt10=2;
				}
				break;
			case IMPORT:
				{
				alt10=3;
				}
				break;
			case IMPORT_END:
				{
				alt10=4;
				}
				break;
			case PAGE:
				{
				alt10=5;
				}
				break;
			case VIEWPORT:
				{
				alt10=6;
				}
				break;
			case FONTFACE:
				{
				alt10=7;
				}
				break;
			case MEDIA:
				{
				alt10=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}
			switch (alt10) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:197:4: CHARSET
					{
					match(input,CHARSET,FOLLOW_CHARSET_in_atstatement233); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:198:4: INVALID_IMPORT
					{
					match(input,INVALID_IMPORT,FOLLOW_INVALID_IMPORT_in_atstatement239); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:199:4: i= IMPORT
					{
					i=(CommonTree)match(input,IMPORT,FOLLOW_IMPORT_in_atstatement247); 

						    String media = extractText(i);
							imports.push(new TreeParserState(media));
							
							log.info("From imported file: Rules will use these media: {}", 
								imports.peek());
						  
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:207:4: IMPORT_END
					{
					match(input,IMPORT_END,FOLLOW_IMPORT_END_in_atstatement258); 

						    imports.pop();
							log.info("Imported file was parsed, returing in nesting.");
						  
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:211:5: ^( PAGE (i= IDENT )? ( ^( PSEUDO i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) )
					{
					match(input,PAGE,FOLLOW_PAGE_in_atstatement267); 
					match(input, Token.DOWN, null); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:212:7: (i= IDENT )?
					int alt5=2;
					int LA5_0 = input.LA(1);
					if ( (LA5_0==IDENT) ) {
						alt5=1;
					}
					switch (alt5) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:212:8: i= IDENT
							{
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_atstatement278); 
							 name = extractText(i); 
							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:215:7: ( ^( PSEUDO i= IDENT ) )?
					int alt6=2;
					int LA6_0 = input.LA(1);
					if ( (LA6_0==PSEUDO) ) {
						alt6=1;
					}
					switch (alt6) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:215:8: ^( PSEUDO i= IDENT )
							{
							match(input,PSEUDO,FOLLOW_PSEUDO_in_atstatement307); 
							match(input, Token.DOWN, null); 
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_atstatement311); 
							match(input, Token.UP, null); 

							 pseudo = extractText(i); 
							}
							break;

					}

					pushFollow(FOLLOW_declarations_in_atstatement341);
					decl=declarations();
					state._fsp--;

					match(input,SET,FOLLOW_SET_in_atstatement350); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:219:13: (m= margin )*
						loop7:
						while (true) {
							int alt7=2;
							int LA7_0 = input.LA(1);
							if ( (LA7_0==MARGIN_AREA) ) {
								alt7=1;
							}

							switch (alt7) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:219:14: m= margin
								{
								pushFollow(FOLLOW_margin_in_atstatement355);
								m=margin();
								state._fsp--;


								        if (m!=null) {
								          if (margins == null) margins = new ArrayList<RuleMargin>();
								          margins.add(m);
								          log.debug("Inserted margin rule #{} into @page", margins.size()+1);
								        }
								      
								}
								break;

							default :
								break loop7;
							}
						}

						match(input, Token.UP, null); 
					}

					match(input, Token.UP, null); 


					      stmnt = preparator.prepareRulePage(decl, margins, name, pseudo);
					    
					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:230:5: ^( VIEWPORT decl= declarations )
					{
					match(input,VIEWPORT,FOLLOW_VIEWPORT_in_atstatement379); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_atstatement383);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 

					 stmnt = preparator.prepareRuleViewport(decl); 
					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:232:5: ^( FONTFACE decl= declarations )
					{
					match(input,FONTFACE,FOLLOW_FONTFACE_in_atstatement397); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_atstatement401);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 

					 stmnt = preparator.prepareRuleFontFace(decl); 
					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:234:4: ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* )
					{
					match(input,MEDIA,FOLLOW_MEDIA_in_atstatement414); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:234:12: (mediaList= media )?
						int alt8=2;
						int LA8_0 = input.LA(1);
						if ( (LA8_0==IDENT) ) {
							alt8=1;
						}
						switch (alt8) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:234:13: mediaList= media
								{
								pushFollow(FOLLOW_media_in_atstatement419);
								mediaList=media();
								state._fsp--;

								}
								break;

						}

						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:235:4: (rs= ruleset | INVALID_STATEMENT )*
						loop9:
						while (true) {
							int alt9=3;
							int LA9_0 = input.LA(1);
							if ( (LA9_0==RULE) ) {
								alt9=1;
							}
							else if ( (LA9_0==INVALID_STATEMENT) ) {
								alt9=2;
							}

							switch (alt9) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:235:7: rs= ruleset
								{
								pushFollow(FOLLOW_ruleset_in_atstatement432);
								rs=ruleset();
								state._fsp--;


													   if(rules==null) rules = new ArrayList<RuleSet>();				
													   if(rs!=null) {
														   // this cast should be safe, because when inside of @statetement, oridinal ruleset
														   // is returned
													       rules.add((RuleSet)rs);
														   log.debug("Inserted ruleset ({}) into @media", rules.size());
													   }
													
								}
								break;
							case 2 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:244:8: INVALID_STATEMENT
								{
								match(input,INVALID_STATEMENT,FOLLOW_INVALID_STATEMENT_in_atstatement443); 
								 log.debug("Skiping invalid statement in media"); 
								}
								break;

							default :
								break loop9;
							}
						}

						match(input, Token.UP, null); 
					}


							   stmnt = preparator.prepareRuleMedia(mark, rules, mediaList);
						   
					}
					break;

			}

			    logLeave("atstatement");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			atstatement_stack.pop();
		}
		return stmnt;
	}
	// $ANTLR end "atstatement"



	// $ANTLR start "margin"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:253:1: margin returns [RuleMargin m] : ^(area= MARGIN_AREA decl= declarations ) ;
	public final RuleMargin margin() throws RecognitionException {
		RuleMargin m = null;


		CommonTree area=null;
		List<Declaration> decl =null;


		    logEnter("margin");

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:260:2: ( ^(area= MARGIN_AREA decl= declarations ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:260:4: ^(area= MARGIN_AREA decl= declarations )
			{
			area=(CommonTree)match(input,MARGIN_AREA,FOLLOW_MARGIN_AREA_in_margin498); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_declarations_in_margin504);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			 m = preparator.prepareRuleMargin(extractText(area).substring(1), decl); 
			}


			    logLeave("margin");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return m;
	}
	// $ANTLR end "margin"



	// $ANTLR start "media"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:265:1: media returns [List<String> affected] : (i= IDENT )+ ;
	public final List<String> media() throws RecognitionException {
		List<String> affected = null;


		CommonTree i=null;


		   logEnter("media");
		   affected = new ArrayList<String>();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:274:2: ( (i= IDENT )+ )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:274:4: (i= IDENT )+
			{
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:274:4: (i= IDENT )+
			int cnt11=0;
			loop11:
			while (true) {
				int alt11=2;
				int LA11_0 = input.LA(1);
				if ( (LA11_0==IDENT) ) {
					alt11=1;
				}

				switch (alt11) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:274:5: i= IDENT
					{
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_media538); 

									   String m = extractText(i);
									   if(css.isSupportedMedia(m)) affected.add(m);
					    
					}
					break;

				default :
					if ( cnt11 >= 1 ) break loop11;
					EarlyExitException eee = new EarlyExitException(11, input);
					throw eee;
				}
				cnt11++;
			}

			}


			   log.debug("Totally returned {} media.", affected.size());							  
			   logLeave("media");		   

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return affected;
	}
	// $ANTLR end "media"



	// $ANTLR start "inlineset"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:280:1: inlineset returns [RuleBlock<?> is] : ^( RULE (p= pseudo )* decl= declarations ) ;
	public final RuleBlock<?> inlineset() throws RecognitionException {
		RuleBlock<?> is = null;


		Selector.PseudoPage p =null;
		List<Declaration> decl =null;


		     logEnter("inlineset");
			 List<Selector.PseudoPage> pplist = new ArrayList<Selector.PseudoPage>();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:288:2: ( ^( RULE (p= pseudo )* decl= declarations ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:288:4: ^( RULE (p= pseudo )* decl= declarations )
			{
			match(input,RULE,FOLLOW_RULE_in_inlineset573); 
			match(input, Token.DOWN, null); 
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:288:11: (p= pseudo )*
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==PSEUDO) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:288:12: p= pseudo
					{
					pushFollow(FOLLOW_pseudo_in_inlineset578);
					p=pseudo();
					state._fsp--;

					pplist.add(p);
					}
					break;

				default :
					break loop12;
				}
			}

			pushFollow(FOLLOW_declarations_in_inlineset586);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			 is = preparator.prepareInlineRuleSet(decl, pplist); 
			}


			     logLeave("inlineset");   

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return is;
	}
	// $ANTLR end "inlineset"



	// $ANTLR start "ruleset"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:297:1: ruleset returns [RuleBlock<?> stmnt] : ^( RULE (cs= combined_selector )* decl= declarations ) ;
	public final RuleBlock<?> ruleset() throws RecognitionException {
		RuleBlock<?> stmnt = null;


		CombinedSelector cs =null;
		List<Declaration> decl =null;


		    logEnter("ruleset"); 
		    List<CombinedSelector> cslist = new ArrayList<CombinedSelector>();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:314:5: ( ^( RULE (cs= combined_selector )* decl= declarations ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:314:7: ^( RULE (cs= combined_selector )* decl= declarations )
			{
			match(input,RULE,FOLLOW_RULE_in_ruleset639); 
			match(input, Token.DOWN, null); 
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:315:9: (cs= combined_selector )*
			loop13:
			while (true) {
				int alt13=2;
				int LA13_0 = input.LA(1);
				if ( (LA13_0==INVALID_SELECTOR||LA13_0==SELECTOR) ) {
					alt13=1;
				}

				switch (alt13) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:315:10: cs= combined_selector
					{
					pushFollow(FOLLOW_combined_selector_in_ruleset653);
					cs=combined_selector();
					state._fsp--;

					if(cs!=null && !cs.isEmpty() && !statement_stack.peek().invalid) {
					            cslist.add(cs);
					            log.debug("Inserted combined selector ({}) into ruleset",  cslist.size());
					         }   
					        
					}
					break;

				default :
					break loop13;
				}
			}

			pushFollow(FOLLOW_declarations_in_ruleset674);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    if(statement_stack.peek().invalid) {
			        stmnt = null;
			        log.debug("Ruleset not valid, so not created");
			    }
			    else {    
					 stmnt = preparator.prepareRuleSet(cslist, decl, 
					 	!statement_stack.peek().insideAtstatement && !imports.isEmpty() && imports.peek().doWrap(), 
						imports.isEmpty() ? null : imports.peek().media);
			        }		
			    logLeave("ruleset");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "ruleset"



	// $ANTLR start "declarations"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:328:1: declarations returns [List<Declaration> decl] : ^( SET (d= declaration )* ) ;
	public final List<Declaration> declarations() throws RecognitionException {
		List<Declaration> decl = null;


		Declaration d =null;


				  logEnter("declarations");
				  decl = new ArrayList<Declaration>();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:336:2: ( ^( SET (d= declaration )* ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:336:4: ^( SET (d= declaration )* )
			{
			match(input,SET,FOLLOW_SET_in_declarations715); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:336:10: (d= declaration )*
				loop14:
				while (true) {
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==DECLARATION||LA14_0==INVALID_DECLARATION) ) {
						alt14=1;
					}

					switch (alt14) {
					case 1 :
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:336:11: d= declaration
						{
						pushFollow(FOLLOW_declaration_in_declarations720);
						d=declaration();
						state._fsp--;


							     if(d!=null) {
						            decl.add(d);
						            log.debug("Inserted declaration #{} ", decl.size()+1);
								 }	
							 
						}
						break;

					default :
						break loop14;
					}
				}

				match(input, Token.UP, null); 
			}

			}


					   logLeave("declarations");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return decl;
	}
	// $ANTLR end "declarations"


	protected static class declaration_scope {
		Declaration d;
		boolean invalid;
	}
	protected Stack<declaration_scope> declaration_stack = new Stack<declaration_scope>();


	// $ANTLR start "declaration"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:349:1: declaration returns [Declaration decl] : ( ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms ) | INVALID_DECLARATION );
	public final Declaration declaration() throws RecognitionException {
		declaration_stack.push(new declaration_scope());
		Declaration decl = null;


		List<Term<?>> t =null;


		    logEnter("declaration");
		    declaration_stack.peek().d = decl = rf.createDeclaration();
		    declaration_stack.peek().invalid = false;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:369:3: ( ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms ) | INVALID_DECLARATION )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==DECLARATION) ) {
				alt17=1;
			}
			else if ( (LA17_0==INVALID_DECLARATION) ) {
				alt17=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:369:5: ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms )
					{
					match(input,DECLARATION,FOLLOW_DECLARATION_in_declaration764); 
					match(input, Token.DOWN, null); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:370:6: ( important )?
					int alt15=2;
					int LA15_0 = input.LA(1);
					if ( (LA15_0==IMPORTANT) ) {
						alt15=1;
					}
					switch (alt15) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:370:7: important
							{
							pushFollow(FOLLOW_important_in_declaration773);
							important();
							state._fsp--;

							 decl.setImportant(true); log.debug("IMPORTANT"); 
							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:371:7: ( INVALID_DIRECTIVE )?
					int alt16=2;
					int LA16_0 = input.LA(1);
					if ( (LA16_0==INVALID_DIRECTIVE) ) {
						alt16=1;
					}
					switch (alt16) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:371:8: INVALID_DIRECTIVE
							{
							match(input,INVALID_DIRECTIVE,FOLLOW_INVALID_DIRECTIVE_in_declaration786); 
							 declaration_stack.peek().invalid =true; 
							}
							break;

					}

					pushFollow(FOLLOW_property_in_declaration798);
					property();
					state._fsp--;

					pushFollow(FOLLOW_terms_in_declaration809);
					t=terms();
					state._fsp--;

					decl.replaceAll(t);
					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:375:4: INVALID_DECLARATION
					{
					match(input,INVALID_DECLARATION,FOLLOW_INVALID_DECLARATION_in_declaration829); 
					 declaration_stack.peek().invalid =true;
					}
					break;

			}

			    if(declaration_stack.peek().invalid || declaration_stack.isEmpty()) {
			        decl =null;
			        log.debug("Declaration was invalidated or already invalid");
			    }
			    else {
			        log.debug("Returning declaration: {}.", decl);
			    }
			    logLeave("declaration");    

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			declaration_stack.pop();
		}
		return decl;
	}
	// $ANTLR end "declaration"



	// $ANTLR start "important"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:378:1: important : IMPORTANT ;
	public final void important() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:379:5: ( IMPORTANT )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:379:7: IMPORTANT
			{
			match(input,IMPORTANT,FOLLOW_IMPORTANT_in_important846); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "important"



	// $ANTLR start "property"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:385:1: property : (i= IDENT | MINUS i= IDENT );
	public final void property() throws RecognitionException {
		CommonTree i=null;


		    logEnter("property");

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:393:3: (i= IDENT | MINUS i= IDENT )
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==IDENT) ) {
				alt18=1;
			}
			else if ( (LA18_0==MINUS) ) {
				alt18=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}

			switch (alt18) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:393:5: i= IDENT
					{
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_property886); 
					 declaration_stack.peek().d.setProperty(extractText(i)); declaration_stack.peek().d.setSource(extractSource(i)); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:394:5: MINUS i= IDENT
					{
					match(input,MINUS,FOLLOW_MINUS_in_property894); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_property900); 
					 declaration_stack.peek().d.setProperty("-" + extractText(i)); declaration_stack.peek().d.setSource(extractSource(i)); 
					}
					break;

			}

				log.debug("Setting property: {}", declaration_stack.peek().d.getProperty());	   
			    logLeave("property");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"


	protected static class terms_scope {
		List<Term<?>> list;
		Term<?> term;
		Term.Operator op;
		int unary;
		boolean dash;
	}
	protected Stack<terms_scope> terms_stack = new Stack<terms_scope>();


	// $ANTLR start "terms"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:400:1: terms returns [List<Term<?>> tlist] : ^( VALUE ( term )+ ) ;
	public final List<Term<?>> terms() throws RecognitionException {
		terms_stack.push(new terms_scope());
		List<Term<?>> tlist = null;



		    logEnter("terms");
		    terms_stack.peek().list = tlist = new ArrayList<Term<?>>();
		    terms_stack.peek().term = null;
		    terms_stack.peek().op = null;
		    terms_stack.peek().unary = 1;
		    terms_stack.peek().dash = false;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:420:5: ( ^( VALUE ( term )+ ) )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:420:7: ^( VALUE ( term )+ )
			{
			match(input,VALUE,FOLLOW_VALUE_in_terms945); 
			match(input, Token.DOWN, null); 
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:420:15: ( term )+
			int cnt19=0;
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==ASTERISK||LA19_0==ATKEYWORD||LA19_0==BRACEBLOCK||(LA19_0 >= CLASSKEYWORD && LA19_0 <= COMMA)||(LA19_0 >= CURLYBLOCK && LA19_0 <= DASHMATCH)||LA19_0==DIMENSION||LA19_0==EQUALS||LA19_0==EXPRESSION||(LA19_0 >= FUNCTION && LA19_0 <= IDENT)||LA19_0==INCLUDES||LA19_0==INVALID_STRING||LA19_0==LESS||LA19_0==MINUS||LA19_0==NUMBER||(LA19_0 >= PARENBLOCK && LA19_0 <= PLUS)||LA19_0==QUESTION||LA19_0==SLASH||LA19_0==STRING||(LA19_0 >= UNIRANGE && LA19_0 <= URI)) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:420:15: term
					{
					pushFollow(FOLLOW_term_in_terms947);
					term();
					state._fsp--;

					}
					break;

				default :
					if ( cnt19 >= 1 ) break loop19;
					EarlyExitException eee = new EarlyExitException(19, input);
					throw eee;
				}
				cnt19++;
			}

			match(input, Token.UP, null); 

			}


				log.debug("Totally added {} terms", tlist.size());	   
			    logLeave("terms");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			terms_stack.pop();
		}
		return tlist;
	}
	// $ANTLR end "terms"



	// $ANTLR start "term"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:423:1: term : ( valuepart | CURLYBLOCK | ATKEYWORD );
	public final void term() throws RecognitionException {

		  logEnter("term");

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:427:5: ( valuepart | CURLYBLOCK | ATKEYWORD )
			int alt20=3;
			switch ( input.LA(1) ) {
			case ASTERISK:
			case BRACEBLOCK:
			case CLASSKEYWORD:
			case COLON:
			case COMMA:
			case DASHMATCH:
			case DIMENSION:
			case EQUALS:
			case EXPRESSION:
			case FUNCTION:
			case GREATER:
			case HASH:
			case IDENT:
			case INCLUDES:
			case INVALID_STRING:
			case LESS:
			case MINUS:
			case NUMBER:
			case PARENBLOCK:
			case PERCENT:
			case PERCENTAGE:
			case PLUS:
			case QUESTION:
			case SLASH:
			case STRING:
			case UNIRANGE:
			case URI:
				{
				alt20=1;
				}
				break;
			case CURLYBLOCK:
				{
				alt20=2;
				}
				break;
			case ATKEYWORD:
				{
				alt20=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}
			switch (alt20) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:427:7: valuepart
					{
					pushFollow(FOLLOW_valuepart_in_term975);
					valuepart();
					state._fsp--;

					// set operator, store and create next 
					       if(!declaration_stack.peek().invalid && terms_stack.peek().term!=null) {
					          terms_stack.peek().term.setOperator(terms_stack.peek().op);
					          terms_stack.peek().list.add(terms_stack.peek().term);
					          // reinitialization
					          terms_stack.peek().op = Term.Operator.SPACE;
					          terms_stack.peek().unary = 1;
					          terms_stack.peek().dash = false;
					          terms_stack.peek().term = null;
					       }    
					      
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:439:7: CURLYBLOCK
					{
					match(input,CURLYBLOCK,FOLLOW_CURLYBLOCK_in_term992); 
					 declaration_stack.peek().invalid = true;
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:440:7: ATKEYWORD
					{
					match(input,ATKEYWORD,FOLLOW_ATKEYWORD_in_term1002); 
					 declaration_stack.peek().invalid = true;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "term"



	// $ANTLR start "valuepart"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:443:1: valuepart : ( ( MINUS )? i= IDENT | CLASSKEYWORD | ( MINUS )? n= NUMBER | ( MINUS )? p= PERCENTAGE | ( MINUS )? d= DIMENSION |s= string |u= URI |h= HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | LESS | QUESTION | PERCENT | EQUALS | SLASH | PLUS | ASTERISK |e= EXPRESSION | ( MINUS )? ^(f= FUNCTION (t= terms )? ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) );
	public final void valuepart() throws RecognitionException {
		CommonTree i=null;
		CommonTree n=null;
		CommonTree p=null;
		CommonTree d=null;
		CommonTree u=null;
		CommonTree h=null;
		CommonTree e=null;
		CommonTree f=null;
		String s =null;
		List<Term<?>> t =null;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:465:5: ( ( MINUS )? i= IDENT | CLASSKEYWORD | ( MINUS )? n= NUMBER | ( MINUS )? p= PERCENTAGE | ( MINUS )? d= DIMENSION |s= string |u= URI |h= HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | LESS | QUESTION | PERCENT | EQUALS | SLASH | PLUS | ASTERISK |e= EXPRESSION | ( MINUS )? ^(f= FUNCTION (t= terms )? ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) )
			int alt29=25;
			switch ( input.LA(1) ) {
			case MINUS:
				{
				switch ( input.LA(2) ) {
				case IDENT:
					{
					alt29=1;
					}
					break;
				case NUMBER:
					{
					alt29=3;
					}
					break;
				case PERCENTAGE:
					{
					alt29=4;
					}
					break;
				case DIMENSION:
					{
					alt29=5;
					}
					break;
				case FUNCTION:
					{
					alt29=22;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 29, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
				{
				alt29=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt29=2;
				}
				break;
			case NUMBER:
				{
				alt29=3;
				}
				break;
			case PERCENTAGE:
				{
				alt29=4;
				}
				break;
			case DIMENSION:
				{
				alt29=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt29=6;
				}
				break;
			case URI:
				{
				alt29=7;
				}
				break;
			case HASH:
				{
				alt29=8;
				}
				break;
			case UNIRANGE:
				{
				alt29=9;
				}
				break;
			case INCLUDES:
				{
				alt29=10;
				}
				break;
			case COLON:
				{
				alt29=11;
				}
				break;
			case COMMA:
				{
				alt29=12;
				}
				break;
			case GREATER:
				{
				alt29=13;
				}
				break;
			case LESS:
				{
				alt29=14;
				}
				break;
			case QUESTION:
				{
				alt29=15;
				}
				break;
			case PERCENT:
				{
				alt29=16;
				}
				break;
			case EQUALS:
				{
				alt29=17;
				}
				break;
			case SLASH:
				{
				alt29=18;
				}
				break;
			case PLUS:
				{
				alt29=19;
				}
				break;
			case ASTERISK:
				{
				alt29=20;
				}
				break;
			case EXPRESSION:
				{
				alt29=21;
				}
				break;
			case FUNCTION:
				{
				alt29=22;
				}
				break;
			case DASHMATCH:
				{
				alt29=23;
				}
				break;
			case PARENBLOCK:
				{
				alt29=24;
				}
				break;
			case BRACEBLOCK:
				{
				alt29=25;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}
			switch (alt29) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:465:7: ( MINUS )? i= IDENT
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:465:7: ( MINUS )?
					int alt21=2;
					int LA21_0 = input.LA(1);
					if ( (LA21_0==MINUS) ) {
						alt21=1;
					}
					switch (alt21) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:465:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1029); 
							terms_stack.peek().dash =true;
							}
							break;

					}

					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_valuepart1037); 
					terms_stack.peek().term = tf.createIdent(extractText(i), terms_stack.peek().dash);
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:466:7: CLASSKEYWORD
					{
					match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_valuepart1049); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:467:6: ( MINUS )? n= NUMBER
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:467:6: ( MINUS )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( (LA22_0==MINUS) ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:467:7: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1059); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					n=(CommonTree)match(input,NUMBER,FOLLOW_NUMBER_in_valuepart1067); 
					terms_stack.peek().term = tf.createNumeric(extractText(n), terms_stack.peek().unary);
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:468:7: ( MINUS )? p= PERCENTAGE
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:468:7: ( MINUS )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==MINUS) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:468:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1081); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					p=(CommonTree)match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_valuepart1089); 
					 terms_stack.peek().term = tf.createPercent(extractText(p), terms_stack.peek().unary);
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:469:7: ( MINUS )? d= DIMENSION
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:469:7: ( MINUS )?
					int alt24=2;
					int LA24_0 = input.LA(1);
					if ( (LA24_0==MINUS) ) {
						alt24=1;
					}
					switch (alt24) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:469:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1101); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					d=(CommonTree)match(input,DIMENSION,FOLLOW_DIMENSION_in_valuepart1109); 
					String dim = extractText(d);
									 terms_stack.peek().term = tf.createDimension(dim, terms_stack.peek().unary);
								     if(terms_stack.peek().term==null) {
										 log.info("Unable to create dimension from {}, unary {}", dim, terms_stack.peek().unary);
								         declaration_stack.peek().invalid = true;
									 }
						    
					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:477:7: s= string
					{
					pushFollow(FOLLOW_string_in_valuepart1127);
					s=string();
					state._fsp--;

					 if(s!=null) terms_stack.peek().term = tf.createString(s);
								  else declaration_stack.peek().invalid =true;
								
					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:481:7: u= URI
					{
					u=(CommonTree)match(input,URI,FOLLOW_URI_in_valuepart1146); 
					terms_stack.peek().term = tf.createURI(extractText(u), extractBase(u));
					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:482:7: h= HASH
					{
					h=(CommonTree)match(input,HASH,FOLLOW_HASH_in_valuepart1164); 
					terms_stack.peek().term = tf.createColor(extractText(h));
						     if(terms_stack.peek().term==null)
						         declaration_stack.peek().invalid = true;
						    
					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:487:7: UNIRANGE
					{
					match(input,UNIRANGE,FOLLOW_UNIRANGE_in_valuepart1183); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:488:7: INCLUDES
					{
					match(input,INCLUDES,FOLLOW_INCLUDES_in_valuepart1194); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:489:7: COLON
					{
					match(input,COLON,FOLLOW_COLON_in_valuepart1205); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:490:7: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_valuepart1219); 
					terms_stack.peek().op = Term.Operator.COMMA;
					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:491:7: GREATER
					{
					match(input,GREATER,FOLLOW_GREATER_in_valuepart1237); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:492:7: LESS
					{
					match(input,LESS,FOLLOW_LESS_in_valuepart1249); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:493:7: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_valuepart1264); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:494:7: PERCENT
					{
					match(input,PERCENT,FOLLOW_PERCENT_in_valuepart1275); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:495:7: EQUALS
					{
					match(input,EQUALS,FOLLOW_EQUALS_in_valuepart1287); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:496:7: SLASH
					{
					match(input,SLASH,FOLLOW_SLASH_in_valuepart1300); 
					terms_stack.peek().op = Term.Operator.SLASH;
					}
					break;
				case 19 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:497:5: PLUS
					{
					match(input,PLUS,FOLLOW_PLUS_in_valuepart1312); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 20 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:498:5: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_valuepart1323); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 21 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:499:5: e= EXPRESSION
					{
					e=(CommonTree)match(input,EXPRESSION,FOLLOW_EXPRESSION_in_valuepart1334); 

							    String exprval = extractText(e);
					        TermExpression expr = tf.createExpression(exprval.substring(11,exprval.length()-1)); //strip the 'expression()'
					        terms_stack.peek().term = expr;
							
					}
					break;
				case 22 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:504:7: ( MINUS )? ^(f= FUNCTION (t= terms )? )
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:504:7: ( MINUS )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==MINUS) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:504:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1345); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_valuepart1354); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:504:50: (t= terms )?
						int alt26=2;
						int LA26_0 = input.LA(1);
						if ( (LA26_0==VALUE) ) {
							alt26=1;
						}
						switch (alt26) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:504:50: t= terms
								{
								pushFollow(FOLLOW_terms_in_valuepart1358);
								t=terms();
								state._fsp--;

								}
								break;

						}

						match(input, Token.UP, null); 
					}


					        // create function
					        TermFunction function = tf.createFunction();
					        function.setFunctionName(extractText(f));
					        if (terms_stack.peek().unary == -1) //if started with minus, add the minus to the function name
					            function.setFunctionName('-' + function.getFunctionName());
					        if (t != null)
					        	function.setValue(t);
					        terms_stack.peek().term = function;
					    
					}
					break;
				case 23 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:514:7: DASHMATCH
					{
					match(input,DASHMATCH,FOLLOW_DASHMATCH_in_valuepart1370); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 24 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:515:7: ^( PARENBLOCK ( any )* )
					{
					match(input,PARENBLOCK,FOLLOW_PARENBLOCK_in_valuepart1381); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:515:20: ( any )*
						loop27:
						while (true) {
							int alt27=2;
							int LA27_0 = input.LA(1);
							if ( (LA27_0==BRACEBLOCK||(LA27_0 >= CLASSKEYWORD && LA27_0 <= COMMA)||LA27_0==DASHMATCH||LA27_0==DIMENSION||LA27_0==EQUALS||LA27_0==EXCLAMATION||(LA27_0 >= FUNCTION && LA27_0 <= IDENT)||LA27_0==INCLUDES||LA27_0==INVALID_STRING||LA27_0==NUMBER||LA27_0==PARENBLOCK||LA27_0==PERCENTAGE||LA27_0==SLASH||LA27_0==STRING||(LA27_0 >= UNIRANGE && LA27_0 <= URI)) ) {
								alt27=1;
							}

							switch (alt27) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:515:20: any
								{
								pushFollow(FOLLOW_any_in_valuepart1383);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop27;
							}
						}

						match(input, Token.UP, null); 
					}

					declaration_stack.peek().invalid = true;
					}
					break;
				case 25 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:516:7: ^( BRACEBLOCK ( any )* )
					{
					match(input,BRACEBLOCK,FOLLOW_BRACEBLOCK_in_valuepart1396); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:516:20: ( any )*
						loop28:
						while (true) {
							int alt28=2;
							int LA28_0 = input.LA(1);
							if ( (LA28_0==BRACEBLOCK||(LA28_0 >= CLASSKEYWORD && LA28_0 <= COMMA)||LA28_0==DASHMATCH||LA28_0==DIMENSION||LA28_0==EQUALS||LA28_0==EXCLAMATION||(LA28_0 >= FUNCTION && LA28_0 <= IDENT)||LA28_0==INCLUDES||LA28_0==INVALID_STRING||LA28_0==NUMBER||LA28_0==PARENBLOCK||LA28_0==PERCENTAGE||LA28_0==SLASH||LA28_0==STRING||(LA28_0 >= UNIRANGE && LA28_0 <= URI)) ) {
								alt28=1;
							}

							switch (alt28) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:516:20: any
								{
								pushFollow(FOLLOW_any_in_valuepart1398);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop28;
							}
						}

						match(input, Token.UP, null); 
					}

					declaration_stack.peek().invalid = true;
					}
					break;

			}

			    // convert color
			    Term<?> term = terms_stack.peek().term;
			    if(term!=null) {
			        TermColor colorTerm = null;
			        if(term instanceof TermIdent) {
			            colorTerm = tf.createColor((TermIdent)term);
			            if (colorTerm != null)
			                term = colorTerm;
			        }
			        else if(term instanceof TermFunction) {
			            colorTerm = tf.createColor((TermFunction)term);
			            if(colorTerm != null)
			                term = colorTerm;
			        }
			        // replace with color
			        if(colorTerm!=null) {
			            terms_stack.peek().term = colorTerm;
			        }                    
			    }

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "valuepart"


	protected static class combined_selector_scope {
		boolean invalid;
	}
	protected Stack<combined_selector_scope> combined_selector_stack = new Stack<combined_selector_scope>();


	// $ANTLR start "combined_selector"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:522:1: combined_selector returns [CombinedSelector combinedSelector] : s= selector (c= combinator s= selector )* ;
	public final CombinedSelector combined_selector() throws RecognitionException {
		combined_selector_stack.push(new combined_selector_scope());
		CombinedSelector combinedSelector = null;


		Selector s =null;
		Selector.Combinator c =null;


			logEnter("combined_selector");	  
			combinedSelector = (CombinedSelector) rf.createCombinedSelector().unlock();

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:549:2: (s= selector (c= combinator s= selector )* )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:549:4: s= selector (c= combinator s= selector )*
			{
			pushFollow(FOLLOW_selector_in_combined_selector1446);
			s=selector();
			state._fsp--;


				     combinedSelector.add(s);
				  
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:552:3: (c= combinator s= selector )*
			loop30:
			while (true) {
				int alt30=2;
				int LA30_0 = input.LA(1);
				if ( (LA30_0==ADJACENT||LA30_0==CHILD||LA30_0==DESCENDANT||LA30_0==PRECEDING) ) {
					alt30=1;
				}

				switch (alt30) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:552:4: c= combinator s= selector
					{
					pushFollow(FOLLOW_combinator_in_combined_selector1455);
					c=combinator();
					state._fsp--;

					pushFollow(FOLLOW_selector_in_combined_selector1459);
					s=selector();
					state._fsp--;


						     s.setCombinator(c);
						     combinedSelector.add(s);	
						  
					}
					break;

				default :
					break loop30;
				}
			}

			}

			  
			    // entire ruleset is not valid when selector is not valid
			    // there is no need to parse selector's when already marked as invalid
			    if(statement_stack.peek().invalid || combined_selector_stack.peek().invalid) {        
			        combinedSelector = null;
			        if(statement_stack.peek().invalid) { 
						log.debug("Ommiting combined selector, whole statement discarded");
					}	
			        else { 
						log.debug("Combined selector is invalid");               
			        }
					// mark whole ruleset as invalid
			        statement_stack.peek().invalid = true;
			    }
			    else {
			        log.debug("Returing combined selector: {}.", combinedSelector); 
			    }
			    logLeave("combined_selector"); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			combined_selector_stack.pop();
		}
		return combinedSelector;
	}
	// $ANTLR end "combined_selector"



	// $ANTLR start "combinator"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:559:1: combinator returns [Selector.Combinator combinator] : ( CHILD | ADJACENT | PRECEDING | DESCENDANT );
	public final Selector.Combinator combinator() throws RecognitionException {
		Selector.Combinator combinator = null;


		 logEnter("combinator"); 
		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:562:2: ( CHILD | ADJACENT | PRECEDING | DESCENDANT )
			int alt31=4;
			switch ( input.LA(1) ) {
			case CHILD:
				{
				alt31=1;
				}
				break;
			case ADJACENT:
				{
				alt31=2;
				}
				break;
			case PRECEDING:
				{
				alt31=3;
				}
				break;
			case DESCENDANT:
				{
				alt31=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}
			switch (alt31) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:562:4: CHILD
					{
					match(input,CHILD,FOLLOW_CHILD_in_combinator1489); 
					combinator =Selector.Combinator.CHILD;
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:563:4: ADJACENT
					{
					match(input,ADJACENT,FOLLOW_ADJACENT_in_combinator1496); 
					combinator =Selector.Combinator.ADJACENT;
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:564:5: PRECEDING
					{
					match(input,PRECEDING,FOLLOW_PRECEDING_in_combinator1504); 
					combinator =Selector.Combinator.PRECEDING;
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:565:4: DESCENDANT
					{
					match(input,DESCENDANT,FOLLOW_DESCENDANT_in_combinator1511); 
					combinator =Selector.Combinator.DESCENDANT;
					}
					break;

			}
			 logLeave("combinator"); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return combinator;
	}
	// $ANTLR end "combinator"


	protected static class selector_scope {
		Selector s;
	}
	protected Stack<selector_scope> selector_stack = new Stack<selector_scope>();


	// $ANTLR start "selector"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:569:1: selector returns [Selector sel] : ( ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* ) | ^( SELECTOR ( selpart )+ ) | INVALID_SELECTOR );
	public final Selector selector() throws RecognitionException {
		selector_stack.push(new selector_scope());
		Selector sel = null;


		CommonTree i=null;


			logEnter("selector");
			selector_stack.peek().s =sel=(Selector)rf.createSelector().unlock();
			Selector.ElementName en = rf.createElement(Selector.ElementName.WILDCARD);

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:581:5: ( ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* ) | ^( SELECTOR ( selpart )+ ) | INVALID_SELECTOR )
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==SELECTOR) ) {
				int LA35_1 = input.LA(2);
				if ( (LA35_1==DOWN) ) {
					int LA35_3 = input.LA(3);
					if ( (LA35_3==ELEMENT) ) {
						alt35=1;
					}
					else if ( (LA35_3==ATTRIBUTE||LA35_3==CLASSKEYWORD||LA35_3==HASH||LA35_3==INVALID_SELPART||LA35_3==PSEUDO) ) {
						alt35=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 35, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 35, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA35_0==INVALID_SELECTOR) ) {
				alt35=3;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}

			switch (alt35) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:581:7: ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* )
					{
					match(input,SELECTOR,FOLLOW_SELECTOR_in_selector1547); 
					match(input, Token.DOWN, null); 
					match(input,ELEMENT,FOLLOW_ELEMENT_in_selector1559); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:583:11: (i= IDENT )?
						int alt32=2;
						int LA32_0 = input.LA(1);
						if ( (LA32_0==IDENT) ) {
							alt32=1;
						}
						switch (alt32) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:583:12: i= IDENT
								{
								i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_selector1575); 
								 en.setName(extractText(i)); 
								}
								break;

						}

						match(input, Token.UP, null); 
					}


							  log.debug("Adding element name: {}.", en.getName());
							  selector_stack.peek().s.add(en);
							 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:589:10: ( selpart )*
					loop33:
					while (true) {
						int alt33=2;
						int LA33_0 = input.LA(1);
						if ( (LA33_0==ATTRIBUTE||LA33_0==CLASSKEYWORD||LA33_0==HASH||LA33_0==INVALID_SELPART||LA33_0==PSEUDO) ) {
							alt33=1;
						}

						switch (alt33) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:589:10: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1622);
							selpart();
							state._fsp--;

							}
							break;

						default :
							break loop33;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:591:7: ^( SELECTOR ( selpart )+ )
					{
					match(input,SELECTOR,FOLLOW_SELECTOR_in_selector1641); 
					match(input, Token.DOWN, null); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:592:10: ( selpart )+
					int cnt34=0;
					loop34:
					while (true) {
						int alt34=2;
						int LA34_0 = input.LA(1);
						if ( (LA34_0==ATTRIBUTE||LA34_0==CLASSKEYWORD||LA34_0==HASH||LA34_0==INVALID_SELPART||LA34_0==PSEUDO) ) {
							alt34=1;
						}

						switch (alt34) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:592:10: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1653);
							selpart();
							state._fsp--;

							}
							break;

						default :
							if ( cnt34 >= 1 ) break loop34;
							EarlyExitException eee = new EarlyExitException(34, input);
							throw eee;
						}
						cnt34++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:594:7: INVALID_SELECTOR
					{
					match(input,INVALID_SELECTOR,FOLLOW_INVALID_SELECTOR_in_selector1671); 
					 statement_stack.peek().invalid = true; 
					}
					break;

			}

				logLeave("selector");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			selector_stack.pop();
		}
		return sel;
	}
	// $ANTLR end "selector"



	// $ANTLR start "selpart"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:597:1: selpart : (h= HASH |c= CLASSKEYWORD | ^( ATTRIBUTE ea= attribute ) |p= pseudo | INVALID_SELPART );
	public final void selpart() throws RecognitionException {
		CommonTree h=null;
		CommonTree c=null;
		Selector.ElementAttribute ea =null;
		Selector.PseudoPage p =null;


			logEnter("selpart");

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:604:5: (h= HASH |c= CLASSKEYWORD | ^( ATTRIBUTE ea= attribute ) |p= pseudo | INVALID_SELPART )
			int alt36=5;
			switch ( input.LA(1) ) {
			case HASH:
				{
				alt36=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt36=2;
				}
				break;
			case ATTRIBUTE:
				{
				alt36=3;
				}
				break;
			case PSEUDO:
				{
				alt36=4;
				}
				break;
			case INVALID_SELPART:
				{
				alt36=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:604:8: h= HASH
					{
					h=(CommonTree)match(input,HASH,FOLLOW_HASH_in_selpart1705); 
					 selector_stack.peek().s.add(rf.createID(extractText(h))); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:605:7: c= CLASSKEYWORD
					{
					c=(CommonTree)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_selpart1717); 
					 selector_stack.peek().s.add(rf.createClass(extractText(c))); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:606:4: ^( ATTRIBUTE ea= attribute )
					{
					match(input,ATTRIBUTE,FOLLOW_ATTRIBUTE_in_selpart1725); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_attribute_in_selpart1729);
					ea=attribute();
					state._fsp--;

					 selector_stack.peek().s.add(ea);
					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:607:7: p= pseudo
					{
					pushFollow(FOLLOW_pseudo_in_selpart1743);
					p=pseudo();
					state._fsp--;

					 selector_stack.peek().s.add(p);
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:608:4: INVALID_SELPART
					{
					match(input,INVALID_SELPART,FOLLOW_INVALID_SELPART_in_selpart1750); 
					 combined_selector_stack.peek().invalid = true;
					}
					break;

			}

			    logLeave("selpart");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selpart"



	// $ANTLR start "attribute"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:611:1: attribute returns [Selector.ElementAttribute elemAttr] : i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )? ;
	public final Selector.ElementAttribute attribute() throws RecognitionException {
		Selector.ElementAttribute elemAttr = null;


		CommonTree i=null;
		String s =null;


		    logEnter("attribute");
		    String attribute = null;
			String value = null;
			Selector.Operator op = Selector.Operator.NO_OPERATOR;
			boolean isStringValue = false;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:629:2: (i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )? )
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:629:4: i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )?
			{
			i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_attribute1784); 
			attribute=extractText(i); 
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:630:4: ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==CONTAINS||LA39_0==DASHMATCH||(LA39_0 >= ENDSWITH && LA39_0 <= EQUALS)||LA39_0==INCLUDES||LA39_0==STARTSWITH) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:630:5: ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string )
					{
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:630:5: ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH )
					int alt37=6;
					switch ( input.LA(1) ) {
					case EQUALS:
						{
						alt37=1;
						}
						break;
					case INCLUDES:
						{
						alt37=2;
						}
						break;
					case DASHMATCH:
						{
						alt37=3;
						}
						break;
					case CONTAINS:
						{
						alt37=4;
						}
						break;
					case STARTSWITH:
						{
						alt37=5;
						}
						break;
					case ENDSWITH:
						{
						alt37=6;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 37, 0, input);
						throw nvae;
					}
					switch (alt37) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:630:6: EQUALS
							{
							match(input,EQUALS,FOLLOW_EQUALS_in_attribute1793); 
							op=Selector.Operator.EQUALS; 
							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:631:7: INCLUDES
							{
							match(input,INCLUDES,FOLLOW_INCLUDES_in_attribute1804); 
							op=Selector.Operator.INCLUDES; 
							}
							break;
						case 3 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:632:7: DASHMATCH
							{
							match(input,DASHMATCH,FOLLOW_DASHMATCH_in_attribute1815); 
							op=Selector.Operator.DASHMATCH; 
							}
							break;
						case 4 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:633:8: CONTAINS
							{
							match(input,CONTAINS,FOLLOW_CONTAINS_in_attribute1826); 
							op=Selector.Operator.CONTAINS; 
							}
							break;
						case 5 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:634:8: STARTSWITH
							{
							match(input,STARTSWITH,FOLLOW_STARTSWITH_in_attribute1837); 
							op=Selector.Operator.STARTSWITH; 
							}
							break;
						case 6 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:635:8: ENDSWITH
							{
							match(input,ENDSWITH,FOLLOW_ENDSWITH_in_attribute1848); 
							op=Selector.Operator.ENDSWITH; 
							}
							break;

					}

					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:637:5: (i= IDENT |s= string )
					int alt38=2;
					int LA38_0 = input.LA(1);
					if ( (LA38_0==IDENT) ) {
						alt38=1;
					}
					else if ( (LA38_0==INVALID_STRING||LA38_0==STRING) ) {
						alt38=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 38, 0, input);
						throw nvae;
					}

					switch (alt38) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:637:6: i= IDENT
							{
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_attribute1866); 

									value=extractText(i);
									isStringValue=false;
									
							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:641:7: s= string
							{
							pushFollow(FOLLOW_string_in_attribute1878);
							s=string();
							state._fsp--;


									 if(s!=null)  { 
										value=s;
										isStringValue=true;
									 }	
									 else {
										combined_selector_stack.peek().invalid =true;
									 }
									
							}
							break;

					}

					}
					break;

			}

			}


			    if(attribute!=null) {
					elemAttr = rf.createAttribute(value, isStringValue, op, attribute);
				}
				else {
				    log.debug("Invalid attribute element in selector");
				    combined_selector_stack.peek().invalid = true;
				}
			    logLeave("attribute");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return elemAttr;
	}
	// $ANTLR end "attribute"



	// $ANTLR start "pseudo"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:653:1: pseudo returns [Selector.PseudoPage pseudoPage] : ( ^( PSEUDO i= IDENT ) | ^( PSEUDO f= FUNCTION i= IDENT ) | ^( PSEUDO f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDO f= FUNCTION (m= MINUS )? n= INDEX ) );
	public final Selector.PseudoPage pseudo() throws RecognitionException {
		Selector.PseudoPage pseudoPage = null;


		CommonTree i=null;
		CommonTree f=null;
		CommonTree m=null;
		CommonTree n=null;


				logEnter("pseudo");

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:657:2: ( ^( PSEUDO i= IDENT ) | ^( PSEUDO f= FUNCTION i= IDENT ) | ^( PSEUDO f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDO f= FUNCTION (m= MINUS )? n= INDEX ) )
			int alt42=4;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==PSEUDO) ) {
				int LA42_1 = input.LA(2);
				if ( (LA42_1==DOWN) ) {
					int LA42_2 = input.LA(3);
					if ( (LA42_2==IDENT) ) {
						alt42=1;
					}
					else if ( (LA42_2==FUNCTION) ) {
						switch ( input.LA(4) ) {
						case IDENT:
							{
							alt42=2;
							}
							break;
						case MINUS:
							{
							int LA42_6 = input.LA(5);
							if ( (LA42_6==NUMBER) ) {
								alt42=3;
							}
							else if ( (LA42_6==INDEX) ) {
								alt42=4;
							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 42, 6, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

							}
							break;
						case NUMBER:
							{
							alt42=3;
							}
							break;
						case INDEX:
							{
							alt42=4;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 42, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 42, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 42, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:657:4: ^( PSEUDO i= IDENT )
					{
					match(input,PSEUDO,FOLLOW_PSEUDO_in_pseudo1911); 
					match(input, Token.DOWN, null); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo1915); 
					match(input, Token.UP, null); 


								pseudoPage = rf.createPseudoPage(extractText(i), null);
							
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:661:4: ^( PSEUDO f= FUNCTION i= IDENT )
					{
					match(input,PSEUDO,FOLLOW_PSEUDO_in_pseudo1926); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo1930); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo1934); 
					match(input, Token.UP, null); 


								pseudoPage = rf.createPseudoPage(extractText(i), extractText(f));
							
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:665:4: ^( PSEUDO f= FUNCTION (m= MINUS )? n= NUMBER )
					{
					match(input,PSEUDO,FOLLOW_PSEUDO_in_pseudo1945); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo1949); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:665:25: (m= MINUS )?
					int alt40=2;
					int LA40_0 = input.LA(1);
					if ( (LA40_0==MINUS) ) {
						alt40=1;
					}
					switch (alt40) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:665:25: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo1953); 
							}
							break;

					}

					n=(CommonTree)match(input,NUMBER,FOLLOW_NUMBER_in_pseudo1958); 
					match(input, Token.UP, null); 


					      String exp = extractText(n);
					      if (m != null) exp = "-" + exp;
								pseudoPage = rf.createPseudoPage(exp, extractText(f));
							
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:671:5: ^( PSEUDO f= FUNCTION (m= MINUS )? n= INDEX )
					{
					match(input,PSEUDO,FOLLOW_PSEUDO_in_pseudo1970); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo1974); 
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:671:26: (m= MINUS )?
					int alt41=2;
					int LA41_0 = input.LA(1);
					if ( (LA41_0==MINUS) ) {
						alt41=1;
					}
					switch (alt41) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:671:26: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo1978); 
							}
							break;

					}

					n=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_pseudo1983); 
					match(input, Token.UP, null); 


					      String exp = extractText(n);
					      if (m != null) exp = "-" + exp;
					      pseudoPage = rf.createPseudoPage(exp, extractText(f));
					    
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pseudoPage;
	}
	// $ANTLR end "pseudo"



	// $ANTLR start "string"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:679:1: string returns [String s] : (st= STRING | INVALID_STRING );
	public final String string() throws RecognitionException {
		String s = null;


		CommonTree st=null;

		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:680:2: (st= STRING | INVALID_STRING )
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==STRING) ) {
				alt43=1;
			}
			else if ( (LA43_0==INVALID_STRING) ) {
				alt43=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}

			switch (alt43) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:680:4: st= STRING
					{
					st=(CommonTree)match(input,STRING,FOLLOW_STRING_in_string2007); 
					 s = extractText(st);
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:681:4: INVALID_STRING
					{
					match(input,INVALID_STRING,FOLLOW_INVALID_STRING_in_string2014); 
					s =null;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "string"



	// $ANTLR start "any"
	// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:684:1: any : ( IDENT | CLASSKEYWORD | NUMBER | PERCENTAGE | DIMENSION | string | URI | HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | EQUALS | SLASH | EXCLAMATION | ^( FUNCTION ( any )* ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) );
	public final void any() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:685:3: ( IDENT | CLASSKEYWORD | NUMBER | PERCENTAGE | DIMENSION | string | URI | HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | EQUALS | SLASH | EXCLAMATION | ^( FUNCTION ( any )* ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) )
			int alt47=20;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt47=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt47=2;
				}
				break;
			case NUMBER:
				{
				alt47=3;
				}
				break;
			case PERCENTAGE:
				{
				alt47=4;
				}
				break;
			case DIMENSION:
				{
				alt47=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt47=6;
				}
				break;
			case URI:
				{
				alt47=7;
				}
				break;
			case HASH:
				{
				alt47=8;
				}
				break;
			case UNIRANGE:
				{
				alt47=9;
				}
				break;
			case INCLUDES:
				{
				alt47=10;
				}
				break;
			case COLON:
				{
				alt47=11;
				}
				break;
			case COMMA:
				{
				alt47=12;
				}
				break;
			case GREATER:
				{
				alt47=13;
				}
				break;
			case EQUALS:
				{
				alt47=14;
				}
				break;
			case SLASH:
				{
				alt47=15;
				}
				break;
			case EXCLAMATION:
				{
				alt47=16;
				}
				break;
			case FUNCTION:
				{
				alt47=17;
				}
				break;
			case DASHMATCH:
				{
				alt47=18;
				}
				break;
			case PARENBLOCK:
				{
				alt47=19;
				}
				break;
			case BRACEBLOCK:
				{
				alt47=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 47, 0, input);
				throw nvae;
			}
			switch (alt47) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:685:5: IDENT
					{
					match(input,IDENT,FOLLOW_IDENT_in_any2030); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:686:5: CLASSKEYWORD
					{
					match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_any2036); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:687:5: NUMBER
					{
					match(input,NUMBER,FOLLOW_NUMBER_in_any2042); 
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:688:5: PERCENTAGE
					{
					match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_any2048); 
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:689:5: DIMENSION
					{
					match(input,DIMENSION,FOLLOW_DIMENSION_in_any2054); 
					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:690:5: string
					{
					pushFollow(FOLLOW_string_in_any2060);
					string();
					state._fsp--;

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:691:5: URI
					{
					match(input,URI,FOLLOW_URI_in_any2066); 
					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:692:5: HASH
					{
					match(input,HASH,FOLLOW_HASH_in_any2072); 
					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:693:5: UNIRANGE
					{
					match(input,UNIRANGE,FOLLOW_UNIRANGE_in_any2078); 
					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:694:5: INCLUDES
					{
					match(input,INCLUDES,FOLLOW_INCLUDES_in_any2084); 
					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:695:5: COLON
					{
					match(input,COLON,FOLLOW_COLON_in_any2090); 
					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:696:5: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_any2096); 
					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:697:5: GREATER
					{
					match(input,GREATER,FOLLOW_GREATER_in_any2102); 
					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:698:5: EQUALS
					{
					match(input,EQUALS,FOLLOW_EQUALS_in_any2108); 
					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:699:5: SLASH
					{
					match(input,SLASH,FOLLOW_SLASH_in_any2114); 
					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:700:5: EXCLAMATION
					{
					match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_any2120); 
					}
					break;
				case 17 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:701:5: ^( FUNCTION ( any )* )
					{
					match(input,FUNCTION,FOLLOW_FUNCTION_in_any2127); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:701:16: ( any )*
						loop44:
						while (true) {
							int alt44=2;
							int LA44_0 = input.LA(1);
							if ( (LA44_0==BRACEBLOCK||(LA44_0 >= CLASSKEYWORD && LA44_0 <= COMMA)||LA44_0==DASHMATCH||LA44_0==DIMENSION||LA44_0==EQUALS||LA44_0==EXCLAMATION||(LA44_0 >= FUNCTION && LA44_0 <= IDENT)||LA44_0==INCLUDES||LA44_0==INVALID_STRING||LA44_0==NUMBER||LA44_0==PARENBLOCK||LA44_0==PERCENTAGE||LA44_0==SLASH||LA44_0==STRING||(LA44_0 >= UNIRANGE && LA44_0 <= URI)) ) {
								alt44=1;
							}

							switch (alt44) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:701:16: any
								{
								pushFollow(FOLLOW_any_in_any2129);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop44;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 18 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:702:5: DASHMATCH
					{
					match(input,DASHMATCH,FOLLOW_DASHMATCH_in_any2138); 
					}
					break;
				case 19 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:703:5: ^( PARENBLOCK ( any )* )
					{
					match(input,PARENBLOCK,FOLLOW_PARENBLOCK_in_any2145); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:703:18: ( any )*
						loop45:
						while (true) {
							int alt45=2;
							int LA45_0 = input.LA(1);
							if ( (LA45_0==BRACEBLOCK||(LA45_0 >= CLASSKEYWORD && LA45_0 <= COMMA)||LA45_0==DASHMATCH||LA45_0==DIMENSION||LA45_0==EQUALS||LA45_0==EXCLAMATION||(LA45_0 >= FUNCTION && LA45_0 <= IDENT)||LA45_0==INCLUDES||LA45_0==INVALID_STRING||LA45_0==NUMBER||LA45_0==PARENBLOCK||LA45_0==PERCENTAGE||LA45_0==SLASH||LA45_0==STRING||(LA45_0 >= UNIRANGE && LA45_0 <= URI)) ) {
								alt45=1;
							}

							switch (alt45) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:703:18: any
								{
								pushFollow(FOLLOW_any_in_any2147);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop45;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 20 :
					// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:704:5: ^( BRACEBLOCK ( any )* )
					{
					match(input,BRACEBLOCK,FOLLOW_BRACEBLOCK_in_any2156); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:704:18: ( any )*
						loop46:
						while (true) {
							int alt46=2;
							int LA46_0 = input.LA(1);
							if ( (LA46_0==BRACEBLOCK||(LA46_0 >= CLASSKEYWORD && LA46_0 <= COMMA)||LA46_0==DASHMATCH||LA46_0==DIMENSION||LA46_0==EQUALS||LA46_0==EXCLAMATION||(LA46_0 >= FUNCTION && LA46_0 <= IDENT)||LA46_0==INCLUDES||LA46_0==INVALID_STRING||LA46_0==NUMBER||LA46_0==PARENBLOCK||LA46_0==PERCENTAGE||LA46_0==SLASH||LA46_0==STRING||(LA46_0 >= UNIRANGE && LA46_0 <= URI)) ) {
								alt46=1;
							}

							switch (alt46) {
							case 1 :
								// cz/vutbr/web/csskit/antlr/CSSTreeParser.g:704:18: any
								{
								pushFollow(FOLLOW_any_in_any2158);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop46;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "any"

	// Delegated rules



	public static final BitSet FOLLOW_INLINESTYLE_in_inlinestyle59 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_inlinestyle63 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INLINESTYLE_in_inlinestyle78 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_inlineset_in_inlinestyle88 = new BitSet(new long[]{0x0000000000000008L,0x0000000000010000L});
	public static final BitSet FOLLOW_STYLESHEET_in_stylesheet125 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_statement_in_stylesheet134 = new BitSet(new long[]{0x0809028200002008L,0x0000000400010010L});
	public static final BitSet FOLLOW_ruleset_in_statement183 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atstatement_in_statement193 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_STATEMENT_in_statement200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CHARSET_in_atstatement233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_IMPORT_in_atstatement239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_atstatement247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_END_in_atstatement258 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PAGE_in_atstatement267 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_atstatement278 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100400L});
	public static final BitSet FOLLOW_PSEUDO_in_atstatement307 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_atstatement311 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_declarations_in_atstatement341 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_SET_in_atstatement350 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_margin_in_atstatement355 = new BitSet(new long[]{0x0400000000000008L});
	public static final BitSet FOLLOW_VIEWPORT_in_atstatement379 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_atstatement383 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FONTFACE_in_atstatement397 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_atstatement401 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MEDIA_in_atstatement414 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_media_in_atstatement419 = new BitSet(new long[]{0x0008000000000008L,0x0000000000010000L});
	public static final BitSet FOLLOW_ruleset_in_atstatement432 = new BitSet(new long[]{0x0008000000000008L,0x0000000000010000L});
	public static final BitSet FOLLOW_INVALID_STATEMENT_in_atstatement443 = new BitSet(new long[]{0x0008000000000008L,0x0000000000010000L});
	public static final BitSet FOLLOW_MARGIN_AREA_in_margin498 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_margin504 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IDENT_in_media538 = new BitSet(new long[]{0x0000002000000002L});
	public static final BitSet FOLLOW_RULE_in_inlineset573 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pseudo_in_inlineset578 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100400L});
	public static final BitSet FOLLOW_declarations_in_inlineset586 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RULE_in_ruleset639 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_combined_selector_in_ruleset653 = new BitSet(new long[]{0x0002000000000000L,0x0000000000140000L});
	public static final BitSet FOLLOW_declarations_in_ruleset674 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SET_in_declarations715 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declaration_in_declarations720 = new BitSet(new long[]{0x0000400001000008L});
	public static final BitSet FOLLOW_DECLARATION_in_declaration764 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_important_in_declaration773 = new BitSet(new long[]{0x1000802000000000L});
	public static final BitSet FOLLOW_INVALID_DIRECTIVE_in_declaration786 = new BitSet(new long[]{0x1000002000000000L});
	public static final BitSet FOLLOW_property_in_declaration798 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_terms_in_declaration809 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INVALID_DECLARATION_in_declaration829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_important846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_property886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_property894 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_property900 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VALUE_in_terms945 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_term_in_terms947 = new BitSet(new long[]{0x1110043D24C38548L,0x00000000612009E4L});
	public static final BitSet FOLLOW_valuepart_in_term975 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CURLYBLOCK_in_term992 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATKEYWORD_in_term1002 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1029 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_valuepart1037 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_valuepart1049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1059 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NUMBER_in_valuepart1067 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1081 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_PERCENTAGE_in_valuepart1089 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1101 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_DIMENSION_in_valuepart1109 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_valuepart1127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_valuepart1146 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_valuepart1164 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNIRANGE_in_valuepart1183 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INCLUDES_in_valuepart1194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_valuepart1205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_valuepart1219 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_valuepart1237 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_in_valuepart1249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_valuepart1264 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_valuepart1275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_valuepart1287 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_valuepart1300 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_valuepart1312 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_valuepart1323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPRESSION_in_valuepart1334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1345 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_FUNCTION_in_valuepart1354 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_terms_in_valuepart1358 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DASHMATCH_in_valuepart1370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARENBLOCK_in_valuepart1381 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_valuepart1383 = new BitSet(new long[]{0x0010043CA4838408L,0x00000000612000A4L});
	public static final BitSet FOLLOW_BRACEBLOCK_in_valuepart1396 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_valuepart1398 = new BitSet(new long[]{0x0010043CA4838408L,0x00000000612000A4L});
	public static final BitSet FOLLOW_selector_in_combined_selector1446 = new BitSet(new long[]{0x0000000002004012L,0x0000000000000200L});
	public static final BitSet FOLLOW_combinator_in_combined_selector1455 = new BitSet(new long[]{0x0002000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_selector_in_combined_selector1459 = new BitSet(new long[]{0x0000000002004012L,0x0000000000000200L});
	public static final BitSet FOLLOW_CHILD_in_combinator1489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADJACENT_in_combinator1496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PRECEDING_in_combinator1504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESCENDANT_in_combinator1511 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECTOR_in_selector1547 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ELEMENT_in_selector1559 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_selector1575 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_selpart_in_selector1622 = new BitSet(new long[]{0x0004001000008208L,0x0000000000000400L});
	public static final BitSet FOLLOW_SELECTOR_in_selector1641 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selpart_in_selector1653 = new BitSet(new long[]{0x0004001000008208L,0x0000000000000400L});
	public static final BitSet FOLLOW_INVALID_SELECTOR_in_selector1671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_selpart1705 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_selpart1717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATTRIBUTE_in_selpart1725 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_attribute_in_selpart1729 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_pseudo_in_selpart1743 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_SELPART_in_selpart1750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_attribute1784 = new BitSet(new long[]{0x0000040030880002L,0x0000000000800000L});
	public static final BitSet FOLLOW_EQUALS_in_attribute1793 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_INCLUDES_in_attribute1804 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_DASHMATCH_in_attribute1815 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_CONTAINS_in_attribute1826 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_STARTSWITH_in_attribute1837 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_ENDSWITH_in_attribute1848 = new BitSet(new long[]{0x0010002000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_IDENT_in_attribute1866 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_attribute1878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PSEUDO_in_pseudo1911 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_pseudo1915 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDO_in_pseudo1926 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo1930 = new BitSet(new long[]{0x0000002000000000L});
	public static final BitSet FOLLOW_IDENT_in_pseudo1934 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDO_in_pseudo1945 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo1949 = new BitSet(new long[]{0x1000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_MINUS_in_pseudo1953 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NUMBER_in_pseudo1958 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDO_in_pseudo1970 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo1974 = new BitSet(new long[]{0x1000080000000000L});
	public static final BitSet FOLLOW_MINUS_in_pseudo1978 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_INDEX_in_pseudo1983 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_in_string2007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_STRING_in_string2014 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_any2030 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_any2036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_any2042 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENTAGE_in_any2048 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DIMENSION_in_any2054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_any2060 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_any2066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_any2072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNIRANGE_in_any2078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INCLUDES_in_any2084 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_any2090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_any2096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_any2102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_any2108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_any2114 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXCLAMATION_in_any2120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_any2127 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2129 = new BitSet(new long[]{0x0010043CA4838408L,0x00000000612000A4L});
	public static final BitSet FOLLOW_DASHMATCH_in_any2138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARENBLOCK_in_any2145 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2147 = new BitSet(new long[]{0x0010043CA4838408L,0x00000000612000A4L});
	public static final BitSet FOLLOW_BRACEBLOCK_in_any2156 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2158 = new BitSet(new long[]{0x0010043CA4838408L,0x00000000612000A4L});
}
