/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.state.SetFlatness;
import org.apache.pdfbox.contentstream.operator.state.SetLineCapStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineDashPattern;
import org.apache.pdfbox.contentstream.operator.state.SetLineJoinStyle;
import org.apache.pdfbox.contentstream.operator.state.SetLineMiterLimit;
import org.apache.pdfbox.contentstream.operator.state.SetLineWidth;
import org.apache.pdfbox.contentstream.operator.state.SetRenderingIntent;
import org.apache.pdfbox.contentstream.operator.text.SetFontAndSize;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import org.fit.pdfdom.BoxStyle;
import org.fit.pdfdom.PathSegment;
import org.fit.pdfdom.TextMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDFBoxTree
extends PDFTextStripper {
    private static Logger log = LoggerFactory.getLogger(PDFBoxTree.class);
    public static final String UNIT = "pt";
    protected static String[] cssFontFamily = new String[]{"Times New Roman", "Times", "Garamond", "Helvetica", "Arial", "Arial Narrow", "Verdana", "Courier New", "MS Sans Serif"};
    protected static String[] pdFontType = new String[]{"normal", "roman", "bold", "italic", "bolditalic"};
    protected static String[] cssFontWeight = new String[]{"normal", "normal", "bold", "normal", "bold"};
    protected static String[] cssFontStyle = new String[]{"normal", "normal", "normal", "italic", "italic"};
    protected boolean disableGraphics = false;
    protected boolean disableImages = false;
    protected boolean disableImageData = false;
    protected int startPage;
    protected int endPage;
    protected PDPage pdpage;
    protected float cur_x;
    protected float cur_y;
    protected float path_x;
    protected float path_y;
    protected float path_start_x;
    protected float path_start_y;
    protected TextPosition lastText = null;
    protected TextPosition lastDia = null;
    protected StringBuilder textLine;
    protected TextMetrics textMetrics;
    protected Vector<PathSegment> graphicsPath;
    protected BoxStyle style;
    protected BoxStyle curstyle;

    public PDFBoxTree() throws IOException {
        super.setSortByPosition(true);
        super.setSuppressDuplicateOverlappingText(true);
        this.addOperator((OperatorProcessor)new SetStrokingColorSpace());
        this.addOperator((OperatorProcessor)new SetNonStrokingColorSpace());
        this.addOperator((OperatorProcessor)new SetLineDashPattern());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceGrayColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceGrayColor());
        this.addOperator((OperatorProcessor)new SetFlatness());
        this.addOperator((OperatorProcessor)new SetLineJoinStyle());
        this.addOperator((OperatorProcessor)new SetLineCapStyle());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceCMYKColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceCMYKColor());
        this.addOperator((OperatorProcessor)new SetLineMiterLimit());
        this.addOperator((OperatorProcessor)new SetStrokingDeviceRGBColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingDeviceRGBColor());
        this.addOperator((OperatorProcessor)new SetRenderingIntent());
        this.addOperator((OperatorProcessor)new SetStrokingColor());
        this.addOperator((OperatorProcessor)new SetNonStrokingColor());
        this.addOperator((OperatorProcessor)new SetStrokingColorN());
        this.addOperator((OperatorProcessor)new SetNonStrokingColorN());
        this.addOperator((OperatorProcessor)new SetFontAndSize());
        this.addOperator((OperatorProcessor)new SetLineWidth());
        this.init();
    }

    private void init() {
        this.style = new BoxStyle(UNIT);
        this.textLine = new StringBuilder();
        this.textMetrics = null;
        this.graphicsPath = new Vector();
        this.startPage = 0;
        this.endPage = Integer.MAX_VALUE;
    }

    public void processPage(PDPage page) throws IOException {
        this.pdpage = page;
        this.startNewPage();
        super.processPage(page);
        this.finishBox();
    }

    public boolean getDisableGraphics() {
        return this.disableGraphics;
    }

    public void setDisableGraphics(boolean disableGraphics) {
        this.disableGraphics = disableGraphics;
    }

    public boolean getDisableImages() {
        return this.disableImages;
    }

    public void setDisableImages(boolean disableImages) {
        this.disableImages = disableImages;
    }

    public boolean getDisableImageData() {
        return this.disableImageData;
    }

    public void setDisableImageData(boolean disableImageData) {
        this.disableImageData = disableImageData;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    protected abstract void startNewPage();

    protected abstract void renderText(String var1, TextMetrics var2);

    protected abstract void renderPath(List<PathSegment> var1, boolean var2, boolean var3);

    protected abstract void renderImage(float var1, float var2, float var3, float var4, String var5, byte[] var6);

    protected float[] toRectangle(List<PathSegment> path) {
        if (path.size() == 4) {
            HashSet<Float> xc = new HashSet<Float>();
            HashSet<Float> yc = new HashSet<Float>();
            for (PathSegment line : path) {
                xc.add(Float.valueOf(line.getX1()));
                xc.add(Float.valueOf(line.getX2()));
                yc.add(Float.valueOf(line.getY1()));
                yc.add(Float.valueOf(line.getY2()));
            }
            if (xc.size() == 2 && yc.size() == 2) {
                return new float[]{((Float)Collections.min(xc)).floatValue(), ((Float)Collections.min(yc)).floatValue(), ((Float)Collections.max(xc)).floatValue(), ((Float)Collections.max(yc)).floatValue()};
            }
            return null;
        }
        return null;
    }

    protected void processOperator(Operator operator, List<COSBase> arguments) throws IOException {
        String operation = operator.getName();
        if (operation.equals("Tw")) {
            this.style.setWordSpacing(this.getLength(arguments.get(0)));
        } else if (operation.equals("Tc")) {
            this.style.setLetterSpacing(this.getLength(arguments.get(0)));
        } else if (operation.equals("m")) {
            if (!this.disableGraphics && arguments.size() == 2) {
                float[] pos = this.transformPosition(this.getLength(arguments.get(0)), this.getLength(arguments.get(1)));
                this.path_x = pos[0];
                this.path_y = pos[1];
                this.path_start_x = pos[0];
                this.path_start_y = pos[1];
            }
        } else if (operation.equals("l")) {
            if (!this.disableGraphics && arguments.size() == 2) {
                float[] pos = this.transformPosition(this.getLength(arguments.get(0)), this.getLength(arguments.get(1)));
                this.graphicsPath.add(new PathSegment(this.path_x, this.path_y, pos[0], pos[1]));
                this.path_x = pos[0];
                this.path_y = pos[1];
            }
        } else if (operation.equals("h")) {
            if (!this.disableGraphics) {
                this.graphicsPath.add(new PathSegment(this.path_x, this.path_y, this.path_start_x, this.path_start_y));
            }
        } else if (operation.equals("re")) {
            if (!this.disableGraphics && arguments.size() == 4) {
                float x = this.getLength(arguments.get(0));
                float y = this.getLength(arguments.get(1));
                float width = this.getLength(arguments.get(2));
                float height = this.getLength(arguments.get(3));
                float[] p1 = this.transformPosition(x, y);
                float[] p2 = this.transformPosition(x + width, y + height);
                this.graphicsPath.add(new PathSegment(p1[0], p1[1], p2[0], p1[1]));
                this.graphicsPath.add(new PathSegment(p2[0], p1[1], p2[0], p2[1]));
                this.graphicsPath.add(new PathSegment(p2[0], p2[1], p1[0], p2[1]));
                this.graphicsPath.add(new PathSegment(p1[0], p2[1], p1[0], p1[1]));
            }
        } else if (operation.equals("f") || operation.equals("F") || operation.equals("f*")) {
            this.renderPath(this.graphicsPath, false, true);
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("S")) {
            this.renderPath(this.graphicsPath, true, false);
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("s")) {
            this.graphicsPath.add(new PathSegment(this.path_x, this.path_y, this.path_start_x, this.path_start_y));
            this.renderPath(this.graphicsPath, true, false);
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("B") || operation.equals("B*")) {
            this.renderPath(this.graphicsPath, true, true);
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("b") || operation.equals("b*")) {
            this.graphicsPath.add(new PathSegment(this.path_x, this.path_y, this.path_start_x, this.path_start_y));
            this.renderPath(this.graphicsPath, true, true);
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("n")) {
            this.graphicsPath.removeAllElements();
        } else if (operation.equals("Do") && !this.disableImages) {
            COSName objectName = (COSName)arguments.get(0);
            PDXObject xobject = this.getResources().getXObject(objectName);
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                byte[] data = this.getImageData(image);
                Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                ctm = ctm.multiply(this.createUnrotationMatrix());
                float x = ctm.getTranslateX();
                float y = ctm.getTranslateY();
                float width = ctm.getScalingFactorX();
                float height = ctm.getScalingFactorY();
                if (width < 0.0f) {
                    width = -width;
                    x -= width;
                }
                if (height < 0.0f) {
                    height = -height;
                    y -= height;
                }
                PDRectangle cb = this.pdpage.getCropBox();
                switch (this.pdpage.getRotation()) {
                    case 0: {
                        y = cb.getHeight() - y;
                        break;
                    }
                    case 90: {
                        y = -y;
                        break;
                    }
                    case 180: {
                        x = -x;
                        break;
                    }
                    case 270: {
                        x = -x;
                        y = -y;
                    }
                }
                this.renderImage(x, y - height, width, height, "image/png", data);
            }
        }
        super.processOperator(operator, arguments);
    }

    protected void processTextPosition(TextPosition text) {
        if (text.isDiacritic()) {
            this.lastDia = text;
        } else if (!text.getUnicode().trim().isEmpty()) {
            if (this.lastDia != null) {
                if (text.contains(this.lastDia)) {
                    text.mergeDiacritic(this.lastDia);
                }
                this.lastDia = null;
            }
            this.cur_x = text.getX();
            this.cur_y = text.getY();
            float distx = 0.0f;
            float disty = 0.0f;
            if (this.lastText != null) {
                distx = text.getX() - (this.lastText.getX() + this.lastText.getWidth());
                disty = text.getY() - this.lastText.getY();
            }
            boolean split = this.lastText == null || distx > 1.0f || distx < -6.0f || Math.abs(disty) > 1.0f || this.isReversed(this.getTextDirectionality(text)) != this.isReversed(this.getTextDirectionality(this.lastText));
            this.updateStyle(this.style, text);
            if (!this.style.equals(this.curstyle)) {
                split = true;
            }
            if (split) {
                if (this.lastText != null) {
                    this.finishBox();
                }
                this.curstyle = new BoxStyle(this.style);
            }
            this.textLine.append(text.getUnicode());
            if (this.textMetrics == null) {
                this.textMetrics = new TextMetrics(text);
            } else {
                this.textMetrics.append(text);
            }
            this.lastText = text;
        }
    }

    protected void finishBox() {
        if (this.textLine.length() > 0) {
            String s = this.isReversed(Character.getDirectionality(this.textLine.charAt(0))) ? this.textLine.reverse().toString() : this.textLine.toString();
            this.curstyle.setLeft(this.textMetrics.getX());
            this.curstyle.setTop(this.textMetrics.getTop());
            this.curstyle.setLineHeight(this.textMetrics.getHeight());
            this.renderText(s, this.textMetrics);
            this.textLine = new StringBuilder();
            this.textMetrics = null;
        }
    }

    protected boolean isReversed(byte directionality) {
        switch (directionality) {
            case 1: 
            case 2: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    protected void updateStyle(BoxStyle bstyle, TextPosition text) {
        String font = text.getFont().getName();
        String family = null;
        String weight = null;
        String fstyle = null;
        bstyle.setFontSize(text.getFontSizeInPt());
        bstyle.setLineHeight(text.getHeight());
        if (font != null) {
            int i;
            for (i = 0; i < pdFontType.length; ++i) {
                if (font.toLowerCase().lastIndexOf(pdFontType[i]) < 0) continue;
                weight = cssFontWeight[i];
                fstyle = cssFontStyle[i];
                break;
            }
            if (weight != null) {
                bstyle.setFontWeight(weight);
            } else {
                bstyle.setFontWeight(cssFontWeight[0]);
            }
            if (fstyle != null) {
                bstyle.setFontStyle(fstyle);
            } else {
                bstyle.setFontStyle(cssFontStyle[0]);
            }
            for (i = 0; i < cssFontFamily.length; ++i) {
                if (font.toLowerCase().lastIndexOf(cssFontFamily[i].toLowerCase()) < 0) continue;
                family = cssFontFamily[i];
                break;
            }
            if (family != null) {
                bstyle.setFontFamily(family);
            }
        }
        this.style.setColor(this.colorString(this.getGraphicsState().getNonStrokingColor()));
    }

    protected PDRectangle getCurrentMediaBox() {
        PDRectangle layout = this.pdpage.getMediaBox();
        return layout;
    }

    protected Matrix createUnrotationMatrix() {
        try {
            double rotationInRadians = (double)this.pdpage.getRotation() * Math.PI / 180.0;
            AffineTransform rotation = new AffineTransform();
            rotation.setToRotation(rotationInRadians);
            AffineTransform rotationInverse = rotation.createInverse();
            Matrix rotationInverseMatrix = new Matrix(rotationInverse);
            return rotationInverseMatrix;
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected float transformLength(float w) {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Matrix m = new Matrix();
        m.setValue(2, 0, w);
        return m.multiply(ctm).getTranslateX();
    }

    protected float[] transformPosition(float x, float y) {
        Matrix spos = new Matrix();
        spos.setValue(2, 0, x);
        spos.setValue(2, 1, y);
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Matrix sposXctm = spos.multiply(ctm);
        Matrix ret = sposXctm.multiply(this.createUnrotationMatrix());
        float rx = ret.getTranslateX();
        float ry = ret.getTranslateY();
        PDRectangle cb = this.pdpage.getCropBox();
        switch (this.pdpage.getRotation()) {
            case 0: {
                ry = cb.getHeight() - ry;
                break;
            }
            case 90: {
                ry = -ry;
                break;
            }
            case 180: {
                rx = -rx;
                break;
            }
            case 270: {
                rx = -rx;
                ry = -ry;
            }
        }
        return new float[]{rx, ry};
    }

    protected int intValue(COSBase value) {
        if (value instanceof COSNumber) {
            return ((COSNumber)value).intValue();
        }
        return 0;
    }

    protected float floatValue(COSBase value) {
        if (value instanceof COSNumber) {
            return ((COSNumber)value).floatValue();
        }
        return 0.0f;
    }

    protected float getLength(COSBase value) {
        return this.floatValue(value);
    }

    protected String stringValue(COSBase value) {
        if (value instanceof COSString) {
            return ((COSString)value).getString();
        }
        if (value instanceof COSNumber) {
            return String.valueOf(((COSNumber)value).floatValue());
        }
        return "";
    }

    protected String colorString(int ir, int ig, int ib) {
        return String.format("#%02x%02x%02x", ir, ig, ib);
    }

    protected String colorString(float r, float g, float b) {
        return this.colorString((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    protected String colorString(PDColor pdcolor) {
        String color = null;
        try {
            float[] rgb = pdcolor.getColorSpace().toRGB(pdcolor.getComponents());
            color = this.colorString(rgb[0], rgb[1], rgb[2]);
        }
        catch (IOException e) {
            log.error("colorString: IOException: {}", (Object)e.getMessage());
        }
        return color;
    }

    protected byte[] getImageData(PDImageXObject image) throws IOException {
        BufferedImage img = image.getImage();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", buffer);
        return buffer.toByteArray();
    }

    protected byte getTextDirectionality(TextPosition text) {
        return this.getTextDirectionality(text.getUnicode());
    }

    protected byte getTextDirectionality(String s) {
        if (s.length() > 0) {
            return Character.getDirectionality(s.charAt(0));
        }
        return -1;
    }
}

