/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.fit.pdfdom.Base64Coder;
import org.fit.pdfdom.PDFBoxTree;
import org.fit.pdfdom.PathSegment;
import org.fit.pdfdom.TextMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class PDFDomTree
extends PDFBoxTree {
    private static Logger log = LoggerFactory.getLogger(PDFDomTree.class);
    protected String defaultStyle = ".page{position:relative; border:1px solid blue;margin:0.5em}\n.p,.r{position:absolute;}";
    protected Document doc;
    protected Element head;
    protected Element body;
    protected Element title;
    protected Element curpage;
    protected int textcnt;
    protected int pagecnt;

    public PDFDomTree() throws IOException, ParserConfigurationException {
        this.init();
    }

    private void init() throws ParserConfigurationException {
        this.pagecnt = 0;
        this.textcnt = 0;
    }

    protected void createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        DocumentType doctype = builder.getDOMImplementation().createDocumentType("html", "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        this.doc = builder.getDOMImplementation().createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        this.head = this.doc.createElement("head");
        Element meta = this.doc.createElement("meta");
        meta.setAttribute("http-equiv", "content-type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        this.head.appendChild(meta);
        this.title = this.doc.createElement("title");
        this.title.setTextContent("PDF Document");
        this.head.appendChild(this.title);
        Element gs = this.doc.createElement("style");
        gs.setAttribute("type", "text/css");
        gs.setTextContent(this.defaultStyle);
        this.head.appendChild(gs);
        this.body = this.doc.createElement("body");
        Element root = this.doc.getDocumentElement();
        root.appendChild(this.head);
        root.appendChild(this.body);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void startDocument(PDDocument document) throws IOException {
        try {
            this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error: parser configuration error", e);
        }
    }

    protected void endDocument(PDDocument document) throws IOException {
        String doctitle = document.getDocumentInformation().getTitle();
        if (doctitle != null && doctitle.trim().length() > 0) {
            this.title.setTextContent(doctitle);
        }
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            writer.getDomConfig().setParameter("format-pretty-print", true);
            output.setCharacterStream(outputStream);
            this.createDOM(doc);
            writer.write(this.getDocument(), output);
        }
        catch (ClassCastException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
    }

    public Document createDOM(PDDocument doc) throws IOException {
        super.writeText(doc, (Writer)new OutputStreamWriter(System.out));
        return this.doc;
    }

    @Override
    protected void startNewPage() {
        this.curpage = this.createPageElement();
        this.body.appendChild(this.curpage);
    }

    @Override
    protected void renderText(String data, TextMetrics metrics) {
        this.curpage.appendChild(this.createTextElement(data, metrics.getWidth()));
    }

    @Override
    protected void renderPath(List<PathSegment> path, boolean stroke, boolean fill) {
        float[] rect = this.toRectangle(path);
        if (rect != null) {
            this.curpage.appendChild(this.createRectangleElement(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1], stroke, fill));
        } else if (stroke) {
            for (PathSegment segm : path) {
                float difx = Math.abs(segm.getX1() - segm.getX2());
                float dify = Math.abs(segm.getY1() - segm.getY2());
                if (difx < 0.5f || dify < 0.5f) {
                    this.curpage.appendChild(this.createLineElement(segm.getX1(), segm.getY1(), segm.getX2(), segm.getY2()));
                    continue;
                }
                log.warn("Skipped non-orthogonal line segment");
            }
        }
    }

    @Override
    protected void renderImage(float x, float y, float width, float height, String mimetype, byte[] data) {
        this.curpage.appendChild(this.createImageElement(x, y, width, height, mimetype, data));
    }

    protected Element createPageElement() {
        String pstyle = "";
        PDRectangle layout = this.getCurrentMediaBox();
        if (layout != null) {
            float w = layout.getWidth();
            float h = layout.getHeight();
            int rot = this.pdpage.getRotation();
            if (rot == 90 || rot == 270) {
                float x = w;
                w = h;
                h = x;
            }
            pstyle = "width:" + w + "pt" + ";" + "height:" + h + "pt";
        } else {
            log.warn("No media box found");
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "page_" + this.pagecnt++);
        el.setAttribute("class", "page");
        el.setAttribute("style", pstyle);
        return el;
    }

    protected Element createTextElement(float width) {
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "p" + this.textcnt++);
        el.setAttribute("class", "p");
        String style = this.curstyle.toString();
        style = style + "width:" + width + "pt" + ";";
        el.setAttribute("style", style);
        return el;
    }

    protected Element createTextElement(String data, float width) {
        Element el = this.createTextElement(width);
        Text text = this.doc.createTextNode(data);
        el.appendChild(text);
        return el;
    }

    protected Element createRectangleElement(float x, float y, float width, float height, boolean stroke, boolean fill) {
        float lineWidth = this.transformLength(this.getGraphicsState().getLineWidth());
        float wcor = stroke ? lineWidth : 0.0f;
        StringBuilder pstyle = new StringBuilder(50);
        pstyle.append("left:").append(this.style.formatLength(x)).append(';');
        pstyle.append("top:").append(this.style.formatLength(y)).append(';');
        pstyle.append("width:").append(this.style.formatLength(width - wcor)).append(';');
        pstyle.append("height:").append(this.style.formatLength(height - wcor)).append(';');
        if (stroke) {
            String color = this.colorString(this.getGraphicsState().getStrokingColor());
            pstyle.append("border:").append(this.style.formatLength(lineWidth)).append(" solid ").append(color).append(';');
        }
        if (fill) {
            String fcolor = this.colorString(this.getGraphicsState().getNonStrokingColor());
            pstyle.append("background-color:").append(fcolor).append(';');
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("class", "r");
        el.setAttribute("style", pstyle.toString());
        el.appendChild(this.doc.createEntityReference("nbsp"));
        return el;
    }

    protected Element createLineElement(float x1, float y1, float x2, float y2) {
        String bname;
        String color = this.colorString(this.getGraphicsState().getStrokingColor());
        float x = Math.min(x1, x2);
        float y = Math.min(y1, y2);
        float width = Math.abs(x2 - x1);
        float height = Math.abs(y2 - y1);
        float lineWidth = this.transformLength(this.getGraphicsState().getLineWidth());
        if (lineWidth < 0.5f) {
            lineWidth = 0.5f;
        }
        if (width < height) {
            y += lineWidth / 2.0f;
            height -= lineWidth;
            bname = "border-left";
        } else {
            x += lineWidth / 2.0f;
            width -= lineWidth;
            bname = "border-top";
        }
        StringBuilder pstyle = new StringBuilder(50);
        pstyle.append("left:").append(this.style.formatLength(x)).append(';');
        pstyle.append("top:").append(this.style.formatLength(y)).append(';');
        pstyle.append("width:").append(this.style.formatLength(width)).append(';');
        pstyle.append("height:").append(this.style.formatLength(height)).append(';');
        pstyle.append(bname).append(":").append(this.style.formatLength(lineWidth)).append(" solid ").append(color).append(';');
        Element el = this.doc.createElement("div");
        el.setAttribute("class", "r");
        el.setAttribute("style", pstyle.toString());
        el.appendChild(this.doc.createEntityReference("nbsp"));
        return el;
    }

    protected Element createImageElement(float x, float y, float width, float height, String mimetype, byte[] data) {
        StringBuilder pstyle = new StringBuilder("position:absolute;");
        pstyle.append("left:").append(x).append("pt").append(';');
        pstyle.append("top:").append(y).append("pt").append(';');
        pstyle.append("width:").append(width).append("pt").append(';');
        pstyle.append("height:").append(height).append("pt").append(';');
        Element el = this.doc.createElement("img");
        el.setAttribute("style", pstyle.toString());
        if (!this.disableImageData) {
            char[] cdata = Base64Coder.encode(data);
            String imgdata = "data:" + mimetype + ";base64," + new String(cdata);
            el.setAttribute("src", imgdata);
        } else {
            el.setAttribute("src", "");
        }
        return el;
    }
}

