/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.locking;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitLockingCache
implements Ehcache {
    protected final Ehcache cache;
    private CacheLockProvider cacheLockProvider;

    public ExplicitLockingCache(Ehcache cache) throws CacheException {
        this.cache = cache;
        this.cacheLockProvider = cache.getCacheConfiguration().isTerracottaClustered() ? (CacheLockProvider)cache.getInternalContext() : new StripedReadWriteLockSync(2048);
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public void setName(String name) {
        this.cache.setName(name);
    }

    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        return this.cache.isExpired(element);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public RegisteredEventListeners getCacheEventNotificationService() {
        return this.cache.getCacheEventNotificationService();
    }

    public boolean isElementInMemory(Serializable key) {
        return this.cache.isElementInMemory(key);
    }

    public boolean isElementInMemory(Object key) {
        return this.cache.isElementInMemory(key);
    }

    public boolean isElementOnDisk(Serializable key) {
        return this.cache.isElementOnDisk(key);
    }

    public boolean isElementOnDisk(Object key) {
        return this.cache.isElementOnDisk(key);
    }

    public String getGuid() {
        return this.cache.getGuid();
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public void clearStatistics() {
        this.cache.clearStatistics();
    }

    public int getStatisticsAccuracy() {
        return this.cache.getStatisticsAccuracy();
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.cache.setStatisticsAccuracy(statisticsAccuracy);
    }

    public void evictExpiredElements() {
        this.cache.evictExpiredElements();
    }

    public boolean isKeyInCache(Object key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean isValueInCache(Object value) {
        return this.cache.isValueInCache(value);
    }

    public Statistics getStatistics() throws IllegalStateException {
        return this.cache.getStatistics();
    }

    public LiveCacheStatistics getLiveCacheStatistics() throws IllegalStateException {
        return this.cache.getLiveCacheStatistics();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache.setCacheManager(cacheManager);
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.cache.getBootstrapCacheLoader();
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        this.cache.setBootstrapCacheLoader(bootstrapCacheLoader);
    }

    public void setDiskStorePath(String diskStorePath) throws CacheException {
        this.cache.setDiskStorePath(diskStorePath);
    }

    public void initialise() {
        this.cache.initialise();
    }

    public void bootstrap() {
        this.cache.bootstrap();
    }

    public void dispose() throws IllegalStateException {
        this.cache.dispose();
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public Element get(Object key) throws RuntimeException, LockTimeoutException {
        return this.cache.get(key);
    }

    public void put(Element element) {
        this.cache.put(element);
    }

    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.put(element, doNotNotifyCacheReplicators);
    }

    public void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.putQuiet(element);
    }

    public Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    public Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    public Element getQuiet(Object key) throws IllegalStateException, CacheException {
        return this.cache.getQuiet(key);
    }

    public List getKeys() throws CacheException {
        return this.cache.getKeys();
    }

    public List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        return this.cache.getKeysWithExpiryCheck();
    }

    public List getKeysNoDuplicateCheck() throws IllegalStateException {
        return this.cache.getKeysNoDuplicateCheck();
    }

    public boolean remove(Serializable key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    public boolean remove(Object key) throws IllegalStateException {
        return this.cache.remove(key);
    }

    public boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    public boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.cache.remove(key, doNotNotifyCacheReplicators);
    }

    public boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    public boolean removeQuiet(Object key) throws IllegalStateException {
        return this.cache.removeQuiet(key);
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.cache.removeAll();
    }

    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.cache.removeAll(doNotNotifyCacheReplicators);
    }

    public void flush() throws IllegalStateException, CacheException {
        this.cache.flush();
    }

    public int getSize() throws IllegalStateException, CacheException {
        return this.cache.getSize();
    }

    public int getSizeBasedOnAccuracy(int statisticsAccuracy) throws IllegalStateException, CacheException {
        return this.cache.getSizeBasedOnAccuracy(statisticsAccuracy);
    }

    public long calculateInMemorySize() throws IllegalStateException, CacheException {
        return this.cache.calculateInMemorySize();
    }

    public long getMemoryStoreSize() throws IllegalStateException {
        return this.cache.getMemoryStoreSize();
    }

    public int getDiskStoreSize() throws IllegalStateException {
        return this.cache.getDiskStoreSize();
    }

    public Status getStatus() {
        return this.cache.getStatus();
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.cache.registerCacheExtension(cacheExtension);
    }

    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        this.cache.unregisterCacheExtension(cacheExtension);
    }

    public List<CacheExtension> getRegisteredCacheExtensions() {
        return this.cache.getRegisteredCacheExtensions();
    }

    public float getAverageGetTime() {
        return this.cache.getAverageGetTime();
    }

    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        this.cache.setCacheExceptionHandler(cacheExceptionHandler);
    }

    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cache.getCacheExceptionHandler();
    }

    public void registerCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        throw new CacheException("This method is not appropriate for a blocking cache.");
    }

    public List<CacheLoader> getRegisteredCacheLoaders() {
        return this.cache.getRegisteredCacheLoaders();
    }

    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void load(Object key) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public void loadAll(Collection keys, Object argument) throws CacheException {
        throw new CacheException("This method is not appropriate for a Blocking Cache");
    }

    public boolean isDisabled() {
        return this.cache.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.cache.setDisabled(disabled);
    }

    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.cache.registerCacheUsageListener(cacheUsageListener);
    }

    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.cache.removeCacheUsageListener(cacheUsageListener);
    }

    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    public void setStatisticsEnabled(boolean enabledStatistics) {
        this.cache.setStatisticsEnabled(enabledStatistics);
    }

    public SampledCacheStatistics getSampledCacheStatistics() {
        return this.cache.getSampledCacheStatistics();
    }

    public void setSampledStatisticsEnabled(boolean enabledStatistics) {
        this.cache.setStatisticsEnabled(enabledStatistics);
    }

    public boolean isSampledStatisticsEnabled() {
        return this.cache.isSampledStatisticsEnabled();
    }

    public Object getInternalContext() {
        return this.cache.getInternalContext();
    }

    protected Sync getLockForKey(Object key) {
        return this.cacheLockProvider.getSyncForKey(key);
    }

    public void acquireReadLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.READ);
    }

    public void acquireWriteLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.WRITE);
    }

    private void acquireLockOnKey(Object key, LockType lockType) {
        Sync s = this.getLockForKey(key);
        s.lock(lockType);
    }

    private void releaseLockOnKey(Object key, LockType lockType) {
        Sync s = this.getLockForKey(key);
        s.unlock(lockType);
    }

    public void releaseReadLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.READ);
    }

    public void releaseWriteLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.WRITE);
    }

    public boolean tryReadLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s = this.getLockForKey(key);
        return s.tryLock(LockType.READ, timeout);
    }

    public boolean tryWriteLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s = this.getLockForKey(key);
        return s.tryLock(LockType.WRITE, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(Element element) {
        try {
            this.acquireWriteLockOnKey(element.getKey());
            if (!this.isKeyInCache(element.getKey())) {
                this.put(element);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLockOnKey(element.getKey());
        }
    }

    public void disableDynamicFeatures() {
        this.cache.disableDynamicFeatures();
    }

    public void putWithWriter(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.cache.putWithWriter(element);
    }

    public boolean removeWithWriter(Object key) throws IllegalStateException {
        return this.cache.removeWithWriter(key);
    }

    public void registerCacheWriter(CacheWriter cacheWriter) {
        this.cache.registerCacheWriter(cacheWriter);
    }

    public void unregisterCacheWriter() {
        this.cache.unregisterCacheWriter();
    }

    public CacheWriter getRegisteredCacheWriter() {
        return this.cache.getRegisteredCacheWriter();
    }

    public CacheWriterManager getWriterManager() {
        return this.cache.getWriterManager();
    }

    public boolean isNodeCoherent() {
        return this.cache.isNodeCoherent();
    }

    public boolean isClusterCoherent() {
        return this.cache.isClusterCoherent();
    }

    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        this.cache.setNodeCoherent(coherent);
    }

    public void waitUntilClusterCoherent() {
        this.cache.waitUntilClusterCoherent();
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.cache.setTransactionManagerLookup(transactionManagerLookup);
    }
}

