/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.util.Properties;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.jms.AcknowledgementMode;
import net.sf.ehcache.distribution.jms.JMSCacheLoader;
import net.sf.ehcache.distribution.jms.JMSUtil;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.util.PropertyUtil;

public class JMSCacheLoaderFactory
extends CacheLoaderFactory {
    protected static final int DEFAULT_TIMEOUT_INTERVAL_MILLIS = 30000;
    private static final Logger LOG = Logger.getLogger(JMSCacheLoaderFactory.class.getName());

    public CacheLoader createCacheLoader(Ehcache cache, Properties properties) {
        QueueConnection getQueueConnection;
        Queue getQueue;
        QueueConnectionFactory queueConnectionFactory;
        String securityPrincipalName = PropertyUtil.extractAndLogProperty((String)"securityPrincipalName", (Properties)properties);
        String securityCredentials = PropertyUtil.extractAndLogProperty((String)"securityCredentials", (Properties)properties);
        String initialContextFactoryName = PropertyUtil.extractAndLogProperty((String)"initialContextFactoryName", (Properties)properties);
        String urlPkgPrefixes = PropertyUtil.extractAndLogProperty((String)"urlPkgPrefixes", (Properties)properties);
        String providerURL = PropertyUtil.extractAndLogProperty((String)"providerURL", (Properties)properties);
        String getQueueConnectionFactoryBindingName = PropertyUtil.extractAndLogProperty((String)"getQueueConnectionFactoryBindingName", (Properties)properties);
        if (getQueueConnectionFactoryBindingName == null) {
            throw new CacheException("getQueueConnectionFactoryBindingName is not configured.");
        }
        String getQueueBindingName = PropertyUtil.extractAndLogProperty((String)"getQueueBindingName", (Properties)properties);
        if (getQueueBindingName == null) {
            throw new CacheException("getQueueBindingName is not configured.");
        }
        String defaultLoaderArgument = PropertyUtil.extractAndLogProperty((String)"defaultLoaderArgument", (Properties)properties);
        String userName = PropertyUtil.extractAndLogProperty((String)"userName", (Properties)properties);
        String password = PropertyUtil.extractAndLogProperty((String)"password", (Properties)properties);
        String acknowledgementMode = PropertyUtil.extractAndLogProperty((String)"acknowledgementMode", (Properties)properties);
        int timeoutMillis = this.extractTimeoutMillis(properties);
        AcknowledgementMode effectiveAcknowledgementMode = AcknowledgementMode.forString(acknowledgementMode);
        Context context = null;
        try {
            context = JMSUtil.createInitialContext(securityPrincipalName, securityCredentials, initialContextFactoryName, urlPkgPrefixes, providerURL, null, null, getQueueBindingName, getQueueConnectionFactoryBindingName);
            queueConnectionFactory = (QueueConnectionFactory)JMSUtil.lookup(context, getQueueConnectionFactoryBindingName);
            getQueue = (Queue)JMSUtil.lookup(context, getQueueBindingName);
            JMSUtil.closeContext(context);
        }
        catch (NamingException ne) {
            throw new CacheException("NamingException " + ne.getMessage(), (Throwable)ne);
        }
        try {
            getQueueConnection = this.createQueueConnection(userName, password, queueConnectionFactory);
        }
        catch (JMSException e) {
            throw new CacheException("Problem creating connections: " + e.getMessage(), (Throwable)e);
        }
        return new JMSCacheLoader(cache, defaultLoaderArgument, getQueueConnection, getQueue, effectiveAcknowledgementMode, timeoutMillis);
    }

    private QueueConnection createQueueConnection(String userName, String password, QueueConnectionFactory queueConnectionFactory) throws JMSException {
        QueueConnection queueConnection = userName != null ? queueConnectionFactory.createQueueConnection(userName, password) : queueConnectionFactory.createQueueConnection();
        return queueConnection;
    }

    protected int extractTimeoutMillis(Properties properties) {
        int timeoutMillis = 0;
        String timeoutMillisString = PropertyUtil.extractAndLogProperty((String)"timeoutMillis", (Properties)properties);
        if (timeoutMillisString != null) {
            try {
                timeoutMillis = Integer.parseInt(timeoutMillisString);
            }
            catch (NumberFormatException e) {
                LOG.warning("Number format exception trying to set timeoutMillis. Using the default instead. String value was: '" + timeoutMillisString + "'");
                timeoutMillis = 30000;
            }
        } else {
            timeoutMillis = 30000;
        }
        return timeoutMillis;
    }
}

