/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jms.AcknowledgementMode;
import net.sf.ehcache.distribution.jms.JMSCachePeer;
import net.sf.ehcache.distribution.jms.JMSUtil;

public class JMSCacheManagerPeerProvider
implements CacheManagerPeerProvider {
    private static final Logger LOG = Logger.getLogger(JMSCacheManagerPeerProvider.class.getName());
    protected CacheManager cacheManager;
    protected List<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
    protected TopicConnection replicationTopicConnection;
    protected Topic replicationTopic;
    protected QueueConnection getQueueConnection;
    protected Queue getQueue;
    protected AcknowledgementMode acknowledgementMode;
    protected QueueReceiver getQueueRequestReceiver;
    protected TopicSession topicPublisherSession;
    protected TopicPublisher topicPublisher;
    protected TopicSubscriber topicSubscriber;
    protected QueueSession getQueueSession;
    protected JMSCachePeer cachePeer;
    protected boolean listenToTopic;

    public JMSCacheManagerPeerProvider(CacheManager cacheManager, TopicConnection replicationTopicConnection, Topic replicationTopic, QueueConnection getQueueConnection, Queue getQueue, AcknowledgementMode acknowledgementMode, boolean listenToTopic) {
        this.cacheManager = cacheManager;
        this.replicationTopicConnection = replicationTopicConnection;
        this.replicationTopic = replicationTopic;
        this.getQueueConnection = getQueueConnection;
        this.getQueue = getQueue;
        this.acknowledgementMode = acknowledgementMode;
        this.listenToTopic = listenToTopic;
    }

    public long getTimeForClusterToForm() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("getTimeForClusterToForm ( ) called ");
        }
        return 0L;
    }

    public String getScheme() {
        return "JMS";
    }

    public void init() {
        try {
            this.topicPublisherSession = this.replicationTopicConnection.createTopicSession(false, this.acknowledgementMode.toInt());
            this.replicationTopicConnection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    LOG.log(Level.SEVERE, "Exception on replication Connection: " + e.getMessage(), (Throwable)e);
                }
            });
            this.topicPublisher = this.topicPublisherSession.createPublisher(this.replicationTopic);
            if (this.listenToTopic) {
                LOG.fine("Listening for message on topic " + this.replicationTopic.getTopicName());
                TopicSession topicSubscriberSession = this.replicationTopicConnection.createTopicSession(false, this.acknowledgementMode.toInt());
                this.topicSubscriber = topicSubscriberSession.createSubscriber(this.replicationTopic, null, true);
                this.replicationTopicConnection.start();
            }
            this.getQueueSession = this.getQueueConnection.createQueueSession(false, this.acknowledgementMode.toInt());
            String messageSelector = "cacheManagerUniqueId <> " + JMSUtil.localCacheManagerUid(this.cacheManager);
            this.getQueueRequestReceiver = this.getQueueSession.createReceiver(this.getQueue, messageSelector);
            this.getQueueConnection.start();
        }
        catch (JMSException e) {
            throw new CacheException("Exception while creating JMS connections: " + e.getMessage(), (Throwable)e);
        }
        this.cachePeer = new JMSCachePeer(this.cacheManager, (MessageProducer)this.topicPublisher, (Session)this.topicPublisherSession, this.getQueueSession);
        this.remoteCachePeers.add(this.cachePeer);
        try {
            if (this.listenToTopic) {
                this.topicSubscriber.setMessageListener((MessageListener)this.cachePeer);
            }
            this.getQueueRequestReceiver.setMessageListener((MessageListener)this.cachePeer);
        }
        catch (JMSException e) {
            LOG.log(Level.SEVERE, "Cannot register " + this.cachePeer + " as messageListener", e);
        }
    }

    public void dispose() throws CacheException {
        LOG.fine("JMSCacheManagerPeerProvider for CacheManager " + this.cacheManager.getName() + " being disposed.");
        try {
            this.cachePeer.dispose();
            this.topicPublisher.close();
            if (this.listenToTopic) {
                this.topicSubscriber.close();
                this.replicationTopicConnection.stop();
            }
            this.topicPublisherSession.close();
            this.replicationTopicConnection.close();
            this.getQueueRequestReceiver.close();
            this.getQueueSession.close();
            this.getQueueConnection.close();
        }
        catch (JMSException e) {
            LOG.severe(e.getMessage());
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        return this.remoteCachePeers;
    }

    public void registerPeer(String rmiUrl) {
        throw new CacheException("Not implemented for JMS");
    }

    public void unregisterPeer(String rmiUrl) {
        throw new CacheException("Not implemented for JMS");
    }
}

