/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.jms.AcknowledgementMode;
import net.sf.ehcache.distribution.jms.JMSCacheManagerPeerProvider;
import net.sf.ehcache.distribution.jms.JMSUtil;
import net.sf.ehcache.util.PropertyUtil;

public class JMSCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Logger LOG = Logger.getLogger(JMSCacheManagerPeerProviderFactory.class.getName());

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        QueueConnection getQueueConnection;
        TopicConnection replicationTopicConnection;
        Queue getQueue;
        QueueConnectionFactory queueConnectionFactory;
        Topic replicationTopic;
        TopicConnectionFactory topicConnectionFactory;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("createCachePeerProvider ( cacheManager = " + cacheManager + ", properties = " + properties + " ) called ");
        }
        String securityPrincipalName = PropertyUtil.extractAndLogProperty((String)"securityPrincipalName", (Properties)properties);
        String securityCredentials = PropertyUtil.extractAndLogProperty((String)"securityCredentials", (Properties)properties);
        String initialContextFactoryName = PropertyUtil.extractAndLogProperty((String)"initialContextFactoryName", (Properties)properties);
        String urlPkgPrefixes = PropertyUtil.extractAndLogProperty((String)"urlPkgPrefixes", (Properties)properties);
        String providerURL = PropertyUtil.extractAndLogProperty((String)"providerURL", (Properties)properties);
        String replicationTopicBindingName = PropertyUtil.extractAndLogProperty((String)"replicationTopicBindingName", (Properties)properties);
        String getQueueBindingName = PropertyUtil.extractAndLogProperty((String)"getQueueBindingName", (Properties)properties);
        String getQueueConnectionFactoryBindingName = PropertyUtil.extractAndLogProperty((String)"getQueueConnectionFactoryBindingName", (Properties)properties);
        String replicationTopicConnectionFactoryBindingName = PropertyUtil.extractAndLogProperty((String)"replicationTopicConnectionFactoryBindingName", (Properties)properties);
        String userName = PropertyUtil.extractAndLogProperty((String)"userName", (Properties)properties);
        String password = PropertyUtil.extractAndLogProperty((String)"password", (Properties)properties);
        String acknowledgementMode = PropertyUtil.extractAndLogProperty((String)"acknowledgementMode", (Properties)properties);
        AcknowledgementMode effectiveAcknowledgementMode = AcknowledgementMode.forString(acknowledgementMode);
        LOG.fine("Creating TopicSession in " + effectiveAcknowledgementMode.name() + " mode.");
        String listenToTopicString = PropertyUtil.extractAndLogProperty((String)"listenToTopic", (Properties)properties);
        boolean listenToTopic = listenToTopicString == null || PropertyUtil.parseBoolean((String)listenToTopicString);
        this.validateJMSCacheLoaderConfiguration(getQueueBindingName, getQueueConnectionFactoryBindingName);
        Context context = null;
        try {
            context = JMSUtil.createInitialContext(securityPrincipalName, securityCredentials, initialContextFactoryName, urlPkgPrefixes, providerURL, replicationTopicBindingName, replicationTopicConnectionFactoryBindingName, getQueueBindingName, getQueueConnectionFactoryBindingName);
            topicConnectionFactory = (TopicConnectionFactory)JMSUtil.lookup(context, replicationTopicConnectionFactoryBindingName);
            replicationTopic = (Topic)JMSUtil.lookup(context, replicationTopicBindingName);
            queueConnectionFactory = (QueueConnectionFactory)JMSUtil.lookup(context, getQueueConnectionFactoryBindingName);
            getQueue = (Queue)JMSUtil.lookup(context, getQueueBindingName);
            JMSUtil.closeContext(context);
        }
        catch (NamingException ne) {
            throw new CacheException("NamingException " + ne.getMessage(), (Throwable)ne);
        }
        try {
            replicationTopicConnection = this.createTopicConnection(userName, password, topicConnectionFactory);
            getQueueConnection = this.createQueueConnection(userName, password, queueConnectionFactory);
        }
        catch (JMSException e) {
            throw new CacheException("Problem creating connections: " + e.getMessage(), (Throwable)e);
        }
        return new JMSCacheManagerPeerProvider(cacheManager, replicationTopicConnection, replicationTopic, getQueueConnection, getQueue, effectiveAcknowledgementMode, listenToTopic);
    }

    private void validateJMSCacheLoaderConfiguration(String getQueueBindingName, String getQueueConnectionFactoryBindingName) {
        if (getQueueConnectionFactoryBindingName != null && getQueueBindingName == null) {
            throw new CacheException("The 'getQueueBindingName is null'. Please configure.");
        }
        if (getQueueConnectionFactoryBindingName == null && getQueueBindingName != null) {
            throw new CacheException("The 'getQueueConnectionFactoryBindingName' is null. Please configure.");
        }
    }

    private TopicConnection createTopicConnection(String userName, String password, TopicConnectionFactory topicConnectionFactory) throws JMSException {
        TopicConnection topicConnection = userName != null ? topicConnectionFactory.createTopicConnection(userName, password) : topicConnectionFactory.createTopicConnection();
        return topicConnection;
    }

    private QueueConnection createQueueConnection(String userName, String password, QueueConnectionFactory queueConnectionFactory) throws JMSException {
        QueueConnection queueConnection = userName != null ? queueConnectionFactory.createQueueConnection(userName, password) : queueConnectionFactory.createQueueConnection();
        return queueConnection;
    }
}

