/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.MimeTypeByteArray;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jms.Action;
import net.sf.ehcache.distribution.jms.InvalidJMSMessageException;
import net.sf.ehcache.distribution.jms.JMSEventMessage;
import net.sf.ehcache.distribution.jms.JMSUtil;
import net.sf.ehcache.util.CacheTransactionHelper;

public class JMSCachePeer
implements CachePeer,
MessageListener {
    private static final Logger LOG = Logger.getLogger(JMSCachePeer.class.getName());
    private static final int TEST_DELAY = 11000;
    protected Session producerSession;
    protected MessageProducer messageProducer;
    private CacheManager cacheManager;
    private boolean shutdown;
    private QueueSession getQueueSession;

    public JMSCachePeer(CacheManager cacheManager, MessageProducer messageProducer, Session producerSession, QueueSession getQueueSession) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("JMSCachePeer constructor ( cacheManager = " + cacheManager + ", messageProducer = " + messageProducer + " ) called");
        }
        this.cacheManager = cacheManager;
        this.messageProducer = messageProducer;
        this.producerSession = producerSession;
        this.getQueueSession = getQueueSession;
    }

    public void dispose() throws JMSException {
        this.producerSession.close();
        this.cacheManager = null;
        this.messageProducer.close();
        this.getQueueSession.close();
        this.shutdown = true;
    }

    private void handleNotification(JMSEventMessage message, Ehcache cache) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("handleNotification ( message = " + (Object)((Object)message) + " ) called ");
        }
        int event = message.getEvent();
        switch (event) {
            case 0: {
                Element element = message.getElement();
                this.put(cache, element);
                break;
            }
            case 1: {
                this.remove(cache, message.getSerializableKey());
                break;
            }
            case 3: {
                this.removeAll(cache);
                break;
            }
            default: {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.severe(" Undefined action " + event);
            }
        }
    }

    private void handleNotification(Element element, Serializable key, Ehcache cache, Action action) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("handleNotification ( element = " + element + " ) called ");
        }
        if (action.equals((Object)Action.PUT)) {
            this.put(cache, element);
        } else if (action.equals((Object)Action.REMOVE)) {
            this.remove(cache, key);
        } else if (action.equals((Object)Action.REMOVE_ALL)) {
            this.removeAll(cache);
        }
    }

    private void handleNotification(Object object, Serializable key, Ehcache cache, Action action) {
        Element element = new Element((Object)key, object);
        if (action.equals((Object)Action.PUT)) {
            this.put(cache, element);
        } else if (action.equals((Object)Action.REMOVE)) {
            this.remove(cache, key);
        } else if (action.equals((Object)Action.REMOVE_ALL)) {
            this.removeAll(cache);
        }
    }

    private void removeAll(Ehcache cache) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("removeAll ");
        }
        cache.removeAll(true);
    }

    private void remove(Ehcache cache, Serializable key) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("remove ( key = " + key + " ) ");
        }
        cache.remove(key, true);
    }

    private void put(Ehcache cache, Element element) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("put ( element = " + element + " ) ");
        }
        cache.put(element, true);
    }

    public void send(List eventMessages) throws RemoteException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("send ( eventMessages = " + eventMessages + " ) called ");
        }
        for (Object eventMessage : eventMessages) {
            try {
                ObjectMessage message = this.producerSession.createObjectMessage((Serializable)((Object)((JMSEventMessage)((Object)eventMessage))));
                this.messageProducer.send((Message)message);
            }
            catch (JMSException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                throw new RemoteException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block13: {
            Ehcache cache;
            assert (!this.shutdown) : "Peer is shutdown. " + message;
            try {
                cache = this.extractAndValidateCache(message);
            }
            catch (JMSException e) {
                LOG.log(Level.WARNING, "Unable to handle JMS Notification: " + e.getMessage(), e);
                return;
            }
            boolean started = CacheTransactionHelper.isTransactionStarted((Ehcache)cache);
            if (!started) {
                CacheTransactionHelper.beginTransactionIfNeeded((Ehcache)cache);
            }
            try {
                if (message instanceof ObjectMessage) {
                    this.handleObjectMessage(message);
                    break block13;
                }
                if (message instanceof TextMessage) {
                    this.handleTextMessage(message);
                    break block13;
                }
                if (message instanceof BytesMessage) {
                    this.handleBytesMessage(message);
                    break block13;
                }
                throw new InvalidJMSMessageException("Cannot handle message of type (class=" + message.getClass().getName() + "). Notification ignored.");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to handle JMS Notification: " + e.getMessage(), e);
            }
            finally {
                if (!started) {
                    CacheTransactionHelper.commitTransactionIfNeeded((Ehcache)cache);
                }
            }
        }
    }

    private void handleObjectMessage(Message message) throws JMSException, RemoteException {
        ObjectMessage objectMessage = (ObjectMessage)message;
        Serializable object = objectMessage.getObject();
        if (object instanceof Element) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.getName() + ": Element message received - " + object);
            }
            Element element = (Element)object;
            Ehcache cache = this.extractAndValidateCache((Message)objectMessage);
            Action action = this.extractAndValidateAction((Message)objectMessage);
            Serializable key = this.extractAndValidateKey((Message)objectMessage, action);
            this.handleNotification(element, key, cache, action);
        } else if (object instanceof JMSEventMessage) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.getName() + ": JMSEventMessage message received - " + object);
            }
            JMSEventMessage jmsEventMessage = (JMSEventMessage)((Object)object);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(jmsEventMessage.toString());
            }
            Ehcache cache = this.extractAndValidateCache((Message)objectMessage);
            if (jmsEventMessage.getEvent() == Action.GET.toInt()) {
                this.handleGetRequest(objectMessage, jmsEventMessage, cache);
            } else {
                this.handleNotification(jmsEventMessage, cache);
            }
        } else {
            LOG.fine(this.getName() + ": Other ObjectMessage received - " + object);
            Ehcache cache = this.extractAndValidateCache((Message)objectMessage);
            Action action = this.extractAndValidateAction((Message)objectMessage);
            Serializable key = this.extractAndValidateKey((Message)objectMessage, action);
            this.handleNotification(object, key, cache, action);
        }
    }

    private void handleTextMessage(Message message) throws RemoteException, JMSException {
        TextMessage textMessage = (TextMessage)message;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getName() + ": Other ObjectMessage received - " + textMessage);
        }
        Ehcache cache = this.extractAndValidateCache(message);
        Action action = this.extractAndValidateAction(message);
        Serializable key = this.extractAndValidateKey(message, action);
        String mimeType = this.extractAndValidateMimeType(message, action);
        byte[] payload = new byte[]{};
        if (textMessage.getText() != null) {
            payload = textMessage.getText().getBytes();
        }
        MimeTypeByteArray value = new MimeTypeByteArray(mimeType, payload);
        this.handleNotification(value, key, cache, action);
    }

    private void handleBytesMessage(Message message) throws RemoteException, JMSException {
        BytesMessage bytesMessage = (BytesMessage)message;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getName() + ": Other ObjectMessage received - " + bytesMessage);
        }
        Ehcache cache = this.extractAndValidateCache(message);
        Action action = this.extractAndValidateAction(message);
        Serializable key = this.extractAndValidateKey(message, action);
        String mimeType = this.extractAndValidateMimeType(message, action);
        byte[] payload = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(payload);
        MimeTypeByteArray value = new MimeTypeByteArray(mimeType, payload);
        this.handleNotification(value, key, cache, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetRequest(ObjectMessage objectMessage, JMSEventMessage jmsEventMessage, Ehcache cache) throws JMSException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.cacheManager.getName() + ": JMSEventMessage message received - " + objectMessage.getJMSMessageID());
        }
        Serializable keyOrKeys = jmsEventMessage.getSerializableKey();
        boolean collectionLoad = false;
        if (keyOrKeys instanceof ArrayList) {
            collectionLoad = true;
        }
        QueueSender replyQueueSender = null;
        try {
            Serializable value = this.loadKeyOrKeys(cache, keyOrKeys, collectionLoad);
            int localCacheManagerUid = JMSUtil.localCacheManagerUid(cache);
            LOG.log(Level.FINE, "Receiver CacheManager UID: {}", localCacheManagerUid);
            assert (objectMessage.getIntProperty("cacheManagerUniqueId") != localCacheManagerUid) : "The JMSCachePeer received a getQueue request sent by a JMSCacheLoader belonging to the sameCacheManager, which is invalid";
            ObjectMessage reply = this.getQueueSession.createObjectMessage(value);
            String name = null;
            try {
                name = this.getName();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            reply.setStringProperty("responder", name);
            reply.setJMSCorrelationID(objectMessage.getJMSMessageID());
            Queue replyQueue = (Queue)objectMessage.getJMSReplyTo();
            replyQueueSender = this.getQueueSession.createSender(replyQueue);
            replyQueueSender.send((Message)reply);
        }
        finally {
            if (replyQueueSender != null) {
                replyQueueSender.close();
            }
        }
    }

    private Serializable loadKeyOrKeys(Ehcache cache, Serializable keyOrKeys, boolean collectionLoad) {
        if (collectionLoad) {
            ArrayList keys = (ArrayList)keyOrKeys;
            return this.loadKeys(cache, keys);
        }
        return this.loadKey(cache, keyOrKeys);
    }

    private Serializable loadKey(Ehcache cache, Serializable key) {
        Element element = cache.get(key);
        this.delayForTest(key);
        Serializable value = null;
        if (element != null) {
            value = element.getValue();
        }
        return value;
    }

    private HashMap loadKeys(Ehcache cache, ArrayList keys) {
        HashMap<Serializable, Serializable> responseMap = new HashMap<Serializable, Serializable>(keys.size());
        for (Object listKey : keys) {
            Serializable key = (Serializable)listKey;
            Element element = cache.get(listKey);
            if (element == null) continue;
            Serializable value = element.getValue();
            responseMap.put(key, value);
        }
        return responseMap;
    }

    private void delayForTest(Serializable key) {
        if (key.equals("net.sf.ehcache.distribution.jms.Delay")) {
            try {
                Thread.sleep(11000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Serializable extractAndValidateKey(Message message, Action action) throws JMSException {
        String key = message.getStringProperty("key");
        if (key == null && action.equals((Object)Action.REMOVE)) {
            throw new InvalidJMSMessageException("No key property specified. The key is required when the action is REMOVE.");
        }
        return key;
    }

    private String extractAndValidateMimeType(Message message, Action action) throws JMSException {
        String mimeType = message.getStringProperty("mimeType");
        if (mimeType == null && action.equals((Object)Action.PUT)) {
            if (message instanceof TextMessage) {
                mimeType = "text/plain";
            } else if (message instanceof BytesMessage) {
                mimeType = "application/octet-stream";
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("mimeType property not set. Auto setting MIME Type for message " + message.getJMSMessageID() + " to " + mimeType);
            }
        }
        return mimeType;
    }

    private Action extractAndValidateAction(Message message) throws JMSException {
        String actionString = message.getStringProperty("action");
        Action action = Action.valueOf(actionString);
        if (actionString == null || action == null) {
            throw new InvalidJMSMessageException("No action specified. Must be one of PUT, REMOVE or REMOVE_ALL");
        }
        return action;
    }

    private Ehcache extractAndValidateCache(Message message) throws JMSException {
        String cacheName = message instanceof ObjectMessage && ((ObjectMessage)message).getObject() instanceof JMSEventMessage ? ((JMSEventMessage)((Object)((ObjectMessage)message).getObject())).getCacheName() : message.getStringProperty("cacheName");
        if (cacheName == null) {
            throw new InvalidJMSMessageException("No cache name specified.");
        }
        Ehcache cache = this.cacheManager.getEhcache(cacheName);
        if (cache == null) {
            throw new InvalidJMSMessageException("No cache named " + cacheName + "exists in the target CacheManager.");
        }
        return cache;
    }

    public List getElements(List keys) throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public String getGuid() throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public List getKeys() throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public String getName() throws RemoteException {
        return this.cacheManager.getName() + " JMSCachePeer";
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public String getUrl() throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public String getUrlBase() throws RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public boolean remove(Serializable key) throws IllegalStateException, RemoteException {
        throw new RemoteException("Not implemented for JMS");
    }

    public void removeAll() throws RemoteException, IllegalStateException {
        throw new RemoteException("Not implemented for JMS");
    }
}

