/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;

public final class JMSUtil {
    public static final String PROVIDER_URL = "providerURL";
    public static final String REPLICATION_TOPIC_BINDING_NAME = "replicationTopicBindingName";
    public static final String GET_QUEUE_BINDING_NAME = "getQueueBindingName";
    public static final String TOPIC_CONNECTION_FACTORY_BINDING_NAME = "replicationTopicConnectionFactoryBindingName";
    public static final String GET_QUEUE_CONNECTION_FACTORY_BINDING_NAME = "getQueueConnectionFactoryBindingName";
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String SECURITY_PRINCIPAL_NAME = "securityPrincipalName";
    public static final String SECURITY_CREDENTIALS = "securityCredentials";
    public static final String INITIAL_CONTEXT_FACTORY_NAME = "initialContextFactoryName";
    public static final String URL_PKG_PREFIXES = "urlPkgPrefixes";
    public static final String ACKNOWLEDGEMENT_MODE = "acknowledgementMode";
    public static final String TIMEOUT_MILLIS = "timeoutMillis";
    public static final String DEFAULT_LOADER_ARGUMENT = "defaultLoaderArgument";
    public static final int MAX_PRIORITY = 9;
    public static final String CACHE_MANAGER_UID = "cacheManagerUniqueId";
    public static final String LISTEN_TO_TOPIC = "listenToTopic";
    private static final Logger LOG = Logger.getLogger(JMSUtil.class.getName());

    private JMSUtil() {
    }

    public static Context createInitialContext(String securityPrincipalName, String securityCredentials, String initialContextFactoryName, String urlPkgPrefixes, String providerURL, String replicationTopicBindingName, String replicationTopicConnectionFactoryBindingName, String getQueueBindingName, String getQueueConnectionFactoryBindingName) {
        InitialContext context;
        Properties env = new Properties();
        if (replicationTopicConnectionFactoryBindingName != null) {
            env.put(TOPIC_CONNECTION_FACTORY_BINDING_NAME, replicationTopicConnectionFactoryBindingName);
        }
        if (replicationTopicBindingName != null) {
            env.put(REPLICATION_TOPIC_BINDING_NAME, replicationTopicBindingName);
        }
        if (getQueueConnectionFactoryBindingName != null) {
            env.put(GET_QUEUE_CONNECTION_FACTORY_BINDING_NAME, getQueueConnectionFactoryBindingName);
        }
        if (getQueueBindingName != null) {
            env.put(GET_QUEUE_BINDING_NAME, getQueueBindingName);
        }
        env.put("java.naming.provider.url", providerURL);
        if (initialContextFactoryName != null) {
            env.put("java.naming.factory.initial", initialContextFactoryName);
            if (urlPkgPrefixes != null) {
                env.put("java.naming.factory.url.pkgs", urlPkgPrefixes);
            }
        }
        if (securityPrincipalName != null) {
            env.put("java.naming.security.principal", securityPrincipalName);
            if (securityCredentials != null) {
                env.put("java.naming.security.credentials", securityCredentials);
            } else {
                LOG.warning("You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
            }
        }
        try {
            context = new InitialContext(env);
        }
        catch (NamingException ne) {
            throw new CacheException("NamingException " + ne.getMessage(), (Throwable)ne);
        }
        return context;
    }

    public static Object lookup(Context ctx, String name) throws NamingException {
        try {
            LOG.fine("Looking up " + name);
            return ctx.lookup(name);
        }
        catch (NameNotFoundException e) {
            LOG.log(Level.SEVERE, "Could not find name [" + name + "].");
            throw e;
        }
    }

    public static void closeContext(Context context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            throw new CacheException("Exception while closing context", (Throwable)e);
        }
    }

    public static int localCacheManagerUid(Ehcache cache) {
        return JMSUtil.localCacheManagerUid(cache.getCacheManager());
    }

    public static int localCacheManagerUid(CacheManager cacheManager) {
        return System.identityHashCode(cacheManager);
    }
}

