/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXException;

public class HTMLPage
extends ParsedHTML {
    private Scriptable _scriptable;

    HTMLPage(WebResponse response, FrameSelector frame, URL baseURL, String baseTarget, String characterSet) {
        super(response, frame, baseURL, baseTarget, null, characterSet);
    }

    public String getTitle() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("title");
        if (nl.getLength() == 0) {
            return "";
        }
        if (!nl.item(0).hasChildNodes()) {
            return "";
        }
        return nl.item(0).getFirstChild().getNodeValue();
    }

    public String getOnLoadEvent() throws SAXException {
        Element mainElement = this.getMainElement((Document)this.getOriginalDOM());
        return mainElement == null ? "" : mainElement.getAttribute("onload");
    }

    private Element getMainElement(Document document) {
        NodeList nl = document.getElementsByTagName("frameset");
        if (nl.getLength() == 0) {
            nl = document.getElementsByTagName("body");
        }
        return nl.getLength() == 0 ? null : (Element)nl.item(0);
    }

    public String getExternalStyleSheet() throws SAXException {
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("link");
        int length = nl.getLength();
        if (length == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            if (!"stylesheet".equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), "rel"))) continue;
            return NodeUtils.getNodeAttribute(nl.item(i), "href");
        }
        return "";
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) {
        Vector<String> matches = new Vector<String>();
        NodeList nl = ((Document)this.getOriginalDOM()).getElementsByTagName("meta");
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            if (!attributeValue.equalsIgnoreCase(NodeUtils.getNodeAttribute(nl.item(i), attribute))) continue;
            matches.addElement(NodeUtils.getNodeAttribute(nl.item(i), "content"));
        }
        Object[] result = new String[matches.size()];
        matches.copyInto(result);
        return result;
    }

    Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
            this._scriptable.setScriptEngine(this.getResponse().getScriptableObject().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public void parse(String text, URL pageURL) throws SAXException, IOException {
        HTMLParserFactory.getHTMLParser().parse(pageURL, text, new DocumentAdapter(){

            public void setDocument(HTMLDocument document) {
                HTMLPage.this.setRootNode(document);
            }

            public String getIncludedScript(String srcAttribute) throws IOException {
                return HTMLPage.this.getIncludedScript(srcAttribute);
            }

            public ScriptingHandler getScriptingHandler() {
                return HTMLPage.this.getResponse().getScriptingHandler();
            }
        });
    }

    public class Scriptable
    extends ScriptableDelegate {
        public Object get(String propertyName) {
            NamedDelegate delegate = this.getNamedItem(this.getForms(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.getNamedItem(this.getLinks(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.getNamedItem(this.getImages(), propertyName);
            if (delegate != null) {
                return delegate;
            }
            return null;
        }

        private NamedDelegate getNamedItem(ScriptingHandler[] items, String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof NamedDelegate) || !name.equals(((NamedDelegate)((Object)items[i])).getName())) continue;
                return (NamedDelegate)((Object)items[i]);
            }
            return null;
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("location")) {
                HTMLPage.this.getResponse().getScriptableObject().set("location", value);
            } else {
                super.set(propertyName, value);
            }
        }

        public WebResponse.Scriptable getParent() {
            return HTMLPage.this.getResponse().getScriptableObject();
        }

        public String getTitle() throws SAXException {
            return HTMLPage.this.getTitle();
        }

        public ScriptingHandler[] getLinks() {
            WebLink[] links = HTMLPage.this.getLinks();
            ScriptingHandler[] result = new WebLink.Scriptable[links.length];
            for (int i = 0; i < links.length; ++i) {
                result[i] = links[i].getScriptingHandler();
            }
            return result;
        }

        public ScriptingHandler[] getForms() {
            WebForm[] forms = HTMLPage.this.getForms();
            ScriptingHandler[] result = new ScriptingHandler[forms.length];
            for (int i = 0; i < forms.length; ++i) {
                result[i] = forms[i].getScriptingHandler();
            }
            return result;
        }

        public ScriptingHandler[] getImages() {
            WebImage[] images = HTMLPage.this.getImages();
            ScriptingHandler[] result = new WebImage.Scriptable[images.length];
            for (int i = 0; i < images.length; ++i) {
                result[i] = images[i].getScriptingHandler();
            }
            return result;
        }

        Scriptable() {
        }

        public boolean replaceText(String text, String contentType) {
            return HTMLPage.this.getResponse().replaceText(text, contentType);
        }

        public void setCookie(String name, String value) {
            HTMLPage.this.getResponse().setCookie(name, value);
        }

        public String getCookie() {
            return this.emptyIfNull(HTMLPage.this.getResponse().getCookieHeader());
        }

        private String emptyIfNull(String string) {
            return string == null ? "" : string;
        }

        public ScriptableDelegate getElementWithID(String id) {
            HTMLElement elementWithID = HTMLPage.this.getElementWithID(id);
            return elementWithID == null ? null : (ScriptableDelegate)elementWithID.getScriptingHandler();
        }

        public ScriptableDelegate[] getElementsByName(String name) {
            return this.getDelegates(HTMLPage.this.getElementsWithName(name));
        }

        public ScriptableDelegate[] getElementsByTagName(String name) {
            return this.getDelegates(HTMLPage.this.getElementsByTagName(HTMLPage.this.getRootNode(), name));
        }
    }
}

