/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.BlockElement;
import com.meterware.httpunit.Button;
import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.ContentConcealer;
import com.meterware.httpunit.ElementRegistry;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.TableRow;
import com.meterware.httpunit.TextBlock;
import com.meterware.httpunit.WebApplet;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebList;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.dom.HTMLContainerElement;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLAppletElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class ParsedHTML {
    private static final HTMLElement[] NO_ELEMENTS = new HTMLElement[0];
    private static final String[] TEXT_ELEMENTS = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6"};
    private Node _rootNode;
    private URL _baseURL;
    private FrameSelector _frame;
    private String _baseTarget;
    private String _characterSet;
    private WebResponse _response;
    private boolean _updateElements = true;
    private boolean _enableNoScriptNodes;
    private HashMap _elementsByID = new HashMap();
    private HashMap _elementsByName = new HashMap();
    private ElementRegistry _registry = new ElementRegistry();
    private ArrayList _blocksList = new ArrayList();
    private TextBlock[] _blocks;
    private ArrayList _tableList = new ArrayList();
    private WebTable[] _tables;
    private ArrayList _frameList = new ArrayList();
    private WebFrame[] _frames;
    private static HashMap _htmlFactoryClasses = new HashMap();
    private static HTMLElementFactory _defaultFactory = new DefaultElementFactory();
    static /* synthetic */ Class class$com$meterware$httpunit$HTMLElement;
    static /* synthetic */ Class class$com$meterware$httpunit$WebForm;
    static /* synthetic */ Class class$com$meterware$httpunit$WebLink;
    static /* synthetic */ Class class$com$meterware$httpunit$ParsedHTML;
    static /* synthetic */ Class class$com$meterware$httpunit$WebTable;
    static /* synthetic */ Class class$com$meterware$httpunit$TableRow;
    static /* synthetic */ Class class$com$meterware$httpunit$TextBlock;
    static /* synthetic */ Class class$com$meterware$httpunit$WebList;
    static /* synthetic */ Class class$com$meterware$httpunit$ContentConcealer;

    ParsedHTML(WebResponse response, FrameSelector frame, URL baseURL, String baseTarget, Node rootNode, String characterSet) {
        this._response = response;
        this._frame = frame;
        this._baseURL = baseURL;
        this._baseTarget = baseTarget;
        this._rootNode = rootNode;
        this._characterSet = characterSet;
    }

    public WebForm[] getForms() {
        HTMLCollection forms = ((HTMLContainerElement)((Object)this._rootNode)).getForms();
        WebForm[] result = new WebForm[forms.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getWebForm(forms.item(i));
        }
        return result;
    }

    private WebForm getWebForm(Node node) {
        WebForm webForm = (WebForm)this._registry.getRegisteredElement(node);
        return webForm != null ? webForm : (WebForm)this._registry.registerElement(node, this.toWebForm((Element)node));
    }

    public WebLink[] getLinks() {
        HTMLCollection links = ((HTMLContainerElement)((Object)this._rootNode)).getLinks();
        WebLink[] result = new WebLink[links.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (WebLink)this._registry.getRegisteredElement(links.item(i));
            if (result[i] != null) continue;
            result[i] = new WebLink(this._response, this._baseURL, links.item(i), this._frame, this._baseTarget, this._characterSet);
            this._registry.registerElement(links.item(i), result[i]);
        }
        return result;
    }

    public WebApplet[] getApplets() {
        HTMLCollection applets = ((HTMLContainerElement)((Object)this._rootNode)).getApplets();
        WebApplet[] result = new WebApplet[applets.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (WebApplet)this._registry.getRegisteredElement(applets.item(i));
            if (result[i] != null) continue;
            result[i] = new WebApplet(this._response, (HTMLAppletElement)applets.item(i), this._baseTarget);
            this._registry.registerElement(applets.item(i), result[i]);
        }
        return result;
    }

    public WebImage[] getImages() {
        HTMLCollection images = ((HTMLContainerElement)((Object)this._rootNode)).getImages();
        WebImage[] result = new WebImage[images.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (WebImage)this._registry.getRegisteredElement(images.item(i));
            if (result[i] != null) continue;
            result[i] = new WebImage(this._response, this, this._baseURL, (HTMLImageElement)images.item(i), this._frame, this._baseTarget, this._characterSet);
            this._registry.registerElement(images.item(i), result[i]);
        }
        return result;
    }

    public TextBlock[] getTextBlocks() {
        if (this._blocks == null) {
            this.loadElements();
            this._blocks = this._blocksList.toArray(new TextBlock[this._blocksList.size()]);
        }
        return this._blocks;
    }

    public TextBlock getFirstMatchingTextBlock(HTMLElementPredicate predicate, Object criteria) {
        TextBlock[] blocks = this.getTextBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            if (!predicate.matchesCriteria(blocks[i], criteria)) continue;
            return blocks[i];
        }
        return null;
    }

    public TextBlock getNextTextBlock(TextBlock block) {
        int index = this._blocksList.indexOf(block);
        if (index < 0 || index == this._blocksList.size() - 1) {
            return null;
        }
        return (TextBlock)this._blocksList.get(index + 1);
    }

    public WebTable[] getTables() {
        if (this._tables == null) {
            this.loadElements();
            this._tables = this._tableList.toArray(new WebTable[this._tableList.size()]);
        }
        return this._tables;
    }

    public HTMLElement getElementWithID(String id) {
        return (HTMLElement)this.getElementWithID(id, class$com$meterware$httpunit$HTMLElement == null ? (class$com$meterware$httpunit$HTMLElement = ParsedHTML.class$("com.meterware.httpunit.HTMLElement")) : class$com$meterware$httpunit$HTMLElement);
    }

    public HTMLElement[] getElementsWithName(String name) {
        this.loadElements();
        ArrayList elements = (ArrayList)this._elementsByName.get(name);
        return elements == null ? NO_ELEMENTS : elements.toArray(new HTMLElement[elements.size()]);
    }

    public HTMLElement[] getElementsWithAttribute(String name, String value) {
        this.loadElements();
        ArrayList<HTMLElement> elements = new ArrayList<HTMLElement>();
        Iterator i = this._registry.iterator();
        while (i.hasNext()) {
            HTMLElement element = (HTMLElement)i.next();
            String aValue = element.getAttribute(name);
            if (!value.equals(aValue)) continue;
            elements.add(element);
        }
        return elements.toArray(new HTMLElement[elements.size()]);
    }

    public String[] getElementNames() {
        this.loadElements();
        return this._elementsByName.keySet().toArray(new String[this._elementsByName.size()]);
    }

    HTMLElement[] getElementsByTagName(Node dom, String name) {
        this.loadElements();
        if (dom instanceof Element) {
            return this.getElementsFromList(((Element)dom).getElementsByTagName(name));
        }
        return this.getElementsFromList(((Document)dom).getElementsByTagName(name));
    }

    private HTMLElement[] getElementsFromList(NodeList nl) {
        HTMLElement[] elements = new HTMLElement[nl.getLength()];
        for (int i = 0; i < elements.length; ++i) {
            Node node = nl.item(i);
            elements[i] = (HTMLElement)this._registry.getRegisteredElement(node);
            if (elements[i] != null) continue;
            elements[i] = this.toDefaultElement((Element)node);
            this._registry.registerElement(node, elements[i]);
        }
        return elements;
    }

    public WebForm getFormWithID(String id) {
        return (WebForm)this.getElementWithID(id, class$com$meterware$httpunit$WebForm == null ? (class$com$meterware$httpunit$WebForm = ParsedHTML.class$("com.meterware.httpunit.WebForm")) : class$com$meterware$httpunit$WebForm);
    }

    public WebLink getLinkWithID(String id) {
        return (WebLink)this.getElementWithID(id, class$com$meterware$httpunit$WebLink == null ? (class$com$meterware$httpunit$WebLink = ParsedHTML.class$("com.meterware.httpunit.WebLink")) : class$com$meterware$httpunit$WebLink);
    }

    private Object getElementWithID(String id, Class klass) {
        this.loadElements();
        return this.whenCast(this._elementsByID.get(id), klass);
    }

    private Object whenCast(Object o, Class klass) {
        return klass.isInstance(o) ? o : null;
    }

    public WebForm getFirstMatchingForm(HTMLElementPredicate predicate, Object criteria) {
        WebForm[] forms = this.getForms();
        for (int i = 0; i < forms.length; ++i) {
            if (!predicate.matchesCriteria(forms[i], criteria)) continue;
            return forms[i];
        }
        return null;
    }

    public WebForm[] getMatchingForms(HTMLElementPredicate predicate, Object criteria) {
        ArrayList<WebForm> matches = new ArrayList<WebForm>();
        WebForm[] forms = this.getForms();
        for (int i = 0; i < forms.length; ++i) {
            if (!predicate.matchesCriteria(forms[i], criteria)) continue;
            matches.add(forms[i]);
        }
        return matches.toArray(new WebForm[matches.size()]);
    }

    public WebForm getFormWithName(String name) {
        return this.getFirstMatchingForm(WebForm.MATCH_NAME, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpretScriptElement(Element element) {
        String script = this.getScript(element);
        if (script != null) {
            try {
                this._updateElements = false;
                String language = NodeUtils.getNodeAttribute(element, "language", null);
                if (!this.getResponse().getScriptingHandler().supportsScriptLanguage(language)) {
                    this._enableNoScriptNodes = true;
                }
                this.getResponse().getScriptingHandler().runScript(language, script);
            }
            finally {
                this.clearCaches();
            }
        }
    }

    private String getScript(Node scriptNode) {
        String scriptLocation = NodeUtils.getNodeAttribute(scriptNode, "src", null);
        if (scriptLocation == null) {
            return NodeUtils.asText(scriptNode.getChildNodes());
        }
        try {
            return this.getIncludedScript(scriptLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading included script: " + e);
        }
    }

    String getIncludedScript(String srcAttribute) throws IOException {
        GetMethodWebRequest req = new GetMethodWebRequest(this.getBaseURL(), srcAttribute);
        WebWindow window = this.getResponse().getWindow();
        if (window == null) {
            throw new IllegalStateException("Unable to retrieve script included by this response, since it was loaded by getResource(). Use getResponse() instead.");
        }
        return window.getResource(req).getText();
    }

    private HTMLElement toNoscriptElement(Element element) {
        NoScriptElement result = null;
        if (!this._enableNoScriptNodes) {
            result = new NoScriptElement(element);
        }
        return result;
    }

    private HTMLElement toDefaultElement(Element element) {
        return new HTMLElementBase(element){

            public ScriptableDelegate newScriptable() {
                return new HTMLElementScriptable(this);
            }

            public ScriptableDelegate getParentDelegate() {
                return ParsedHTML.this.getResponse().getDocumentScriptable();
            }
        };
    }

    private static HTMLElementFactory getHTMLElementFactory(String tagName) {
        HTMLElementFactory factory = (HTMLElementFactory)_htmlFactoryClasses.get(tagName);
        return factory != null ? factory : _defaultFactory;
    }

    private void loadElements() {
        if (!this._updateElements) {
            return;
        }
        NodeUtils.NodeAction action = new NodeUtils.NodeAction(){

            public boolean processElement(NodeUtils.PreOrderTraversal pot, Element element) {
                HTMLElementFactory factory = ParsedHTML.getHTMLElementFactory(element.getNodeName().toLowerCase());
                if (factory == null || !factory.isRecognized(ParsedHTML.this.getClientProperties())) {
                    return true;
                }
                if (pot.getClosestContext(class$com$meterware$httpunit$ContentConcealer == null ? (class$com$meterware$httpunit$ContentConcealer = ParsedHTML.class$("com.meterware.httpunit.ContentConcealer")) : class$com$meterware$httpunit$ContentConcealer) != null) {
                    return true;
                }
                if (!ParsedHTML.this._registry.hasNode(element)) {
                    factory.recordElement(pot, element, ParsedHTML.this);
                }
                if (factory.addToContext()) {
                    pot.pushContext(ParsedHTML.this._registry.getRegisteredElement(element));
                }
                return true;
            }

            public void processTextNode(NodeUtils.PreOrderTraversal pot, Node textNode) {
                if (textNode.getNodeValue().trim().length() == 0) {
                    return;
                }
                Node parent = textNode.getParentNode();
                if (!parent.getNodeName().equalsIgnoreCase("body")) {
                    return;
                }
                if (pot.getClosestContext(class$com$meterware$httpunit$ContentConcealer == null ? (class$com$meterware$httpunit$ContentConcealer = ParsedHTML.class$("com.meterware.httpunit.ContentConcealer")) : class$com$meterware$httpunit$ContentConcealer) != null) {
                    return;
                }
                new HtmlElementRecorder().recordHtmlElement(pot, textNode, ParsedHTML.this.newTextBlock(textNode));
            }
        };
        NodeUtils.PreOrderTraversal nt = new NodeUtils.PreOrderTraversal(this.getRootNode());
        nt.pushBaseContext(this);
        nt.perform(action);
        this._updateElements = false;
    }

    private ClientProperties getClientProperties() {
        WebWindow window = this._response.getWindow();
        return window == null ? ClientProperties.getDefaultProperties() : window.getClient().getClientProperties();
    }

    private Button toButtonWithoutForm(Element element) {
        return new Button(this._response, (HTMLControl)element);
    }

    private WebForm toWebForm(Element element) {
        return new WebForm(this._response, this._baseURL, element, this._frame, this._baseTarget, this._characterSet, this._registry);
    }

    private WebFrame toWebFrame(Element element) {
        return new WebFrame(this._response, this._baseURL, element, this._frame);
    }

    private WebFrame toWebIFrame(Element element) {
        return new WebIFrame(this._baseURL, (Node)element, this._frame);
    }

    private WebLink toLinkAnchor(Element child) {
        return !ParsedHTML.isWebLink(child) ? null : new WebLink(this._response, this._baseURL, child, this._frame, this._baseTarget, this._characterSet);
    }

    public static boolean isWebLink(Node node) {
        boolean result = false;
        String tagName = ((Element)node).getTagName();
        if (tagName.equalsIgnoreCase("area") || tagName.equalsIgnoreCase("a")) {
            result = node.getAttributes().getNamedItem("href") != null;
        }
        return result;
    }

    private WebImage toWebImage(Element child) {
        return new WebImage(this._response, this, this._baseURL, (HTMLImageElement)child, this._frame, this._baseTarget, this._characterSet);
    }

    private WebApplet toWebApplet(Element element) {
        return new WebApplet(this._response, (HTMLAppletElement)element, this._baseTarget);
    }

    private WebTable toWebTable(Element element) {
        return new WebTable(this._response, this._frame, element, this._baseURL, this._baseTarget, this._characterSet);
    }

    private TextBlock toTextBlock(Element element) {
        return new TextBlock(this._response, this._frame, this._baseURL, this._baseTarget, element, this._characterSet);
    }

    private TextBlock newTextBlock(Node textNode) {
        return new TextBlock(this._response, this._frame, this._baseURL, this._baseTarget, textNode, this._characterSet);
    }

    private WebList toOrderedList(Element element) {
        return new WebList(this._response, this._frame, this._baseURL, this._baseTarget, element, this._characterSet);
    }

    private void addToMaps(Node node, HTMLElement htmlElement) {
        this._registry.registerElement(node, htmlElement);
        if (htmlElement.getID() != null) {
            this._elementsByID.put(htmlElement.getID(), htmlElement);
        }
        if (htmlElement.getName() != null) {
            this.addNamedElement(htmlElement.getName(), htmlElement);
        }
    }

    private void addNamedElement(String name, HTMLElement htmlElement) {
        ArrayList<HTMLElement> list = (ArrayList<HTMLElement>)this._elementsByName.get(name);
        if (list == null) {
            list = new ArrayList<HTMLElement>();
            this._elementsByName.put(name, list);
        }
        list.add(htmlElement);
    }

    private void addToList(HTMLElement htmlElement) {
        ArrayList list = this.getListForElement(htmlElement);
        if (list != null) {
            list.add(htmlElement);
        }
    }

    private ArrayList getListForElement(HTMLElement element) {
        if (element instanceof WebTable) {
            return this._tableList;
        }
        if (element instanceof WebFrame) {
            return this._frameList;
        }
        if (element instanceof BlockElement) {
            return this._blocksList;
        }
        return null;
    }

    public WebLink getLinkWith(String text) {
        return this.getFirstMatchingLink(WebLink.MATCH_CONTAINED_TEXT, text);
    }

    public WebLink getLinkWithImageText(String text) {
        WebImage image = this.getImageWithAltText(text);
        return image == null ? null : image.getLink();
    }

    public WebLink getLinkWithName(String name) {
        return this.getFirstMatchingLink(WebLink.MATCH_NAME, name);
    }

    public WebLink getFirstMatchingLink(HTMLElementPredicate predicate, Object criteria) {
        WebLink[] links = this.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (!predicate.matchesCriteria(links[i], criteria)) continue;
            return links[i];
        }
        return null;
    }

    public WebLink[] getMatchingLinks(HTMLElementPredicate predicate, Object criteria) {
        ArrayList<WebLink> matches = new ArrayList<WebLink>();
        WebLink[] links = this.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (!predicate.matchesCriteria(links[i], criteria)) continue;
            matches.add(links[i]);
        }
        return matches.toArray(new WebLink[matches.size()]);
    }

    public WebImage getImageWithName(String name) {
        WebImage[] images = this.getImages();
        for (int i = 0; i < images.length; ++i) {
            if (!HttpUnitUtils.matches(name, images[i].getName())) continue;
            return images[i];
        }
        return null;
    }

    public WebImage getImageWithSource(String source) {
        WebImage[] images = this.getImages();
        for (int i = 0; i < images.length; ++i) {
            if (!HttpUnitUtils.matches(source, images[i].getSource())) continue;
            return images[i];
        }
        return null;
    }

    public WebImage getImageWithAltText(String altText) {
        WebImage[] images = this.getImages();
        for (int i = 0; i < images.length; ++i) {
            if (!HttpUnitUtils.matches(altText, images[i].getAltText())) continue;
            return images[i];
        }
        return null;
    }

    public WebTable getFirstMatchingTable(HTMLElementPredicate predicate, Object criteria) {
        return this.getTableSatisfyingPredicate(this.getTables(), predicate, criteria);
    }

    public WebTable[] getMatchingTables(HTMLElementPredicate predicate, Object criteria) {
        return this.getTablesSatisfyingPredicate(this.getTables(), predicate, criteria);
    }

    public WebTable getTableStartingWith(String text) {
        return this.getFirstMatchingTable(WebTable.MATCH_FIRST_NONBLANK_CELL, text);
    }

    public WebTable getTableStartingWithPrefix(String text) {
        return this.getFirstMatchingTable(WebTable.MATCH_FIRST_NONBLANK_CELL_PREFIX, text);
    }

    public WebTable getTableWithSummary(String summary) {
        return this.getFirstMatchingTable(WebTable.MATCH_SUMMARY, summary);
    }

    public WebTable getTableWithID(String ID) {
        return this.getFirstMatchingTable(WebTable.MATCH_ID, ID);
    }

    public Node getDOM() {
        return this.getRootNode().cloneNode(true);
    }

    public String toString() {
        return this._baseURL.toExternalForm() + System.getProperty("line.separator") + this._rootNode;
    }

    void setRootNode(Node rootNode) {
        if (this._rootNode != null && rootNode != this._rootNode) {
            throw new IllegalStateException("The root node has already been defined as " + this._rootNode + " and cannot be redefined as " + rootNode);
        }
        this._rootNode = rootNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            ((HTMLDocumentImpl)rootNode).setIFramesEnabled(this.getClientProperties().isIframeSupported());
        }
        this.clearCaches();
    }

    private void clearCaches() {
        this._tables = null;
        this._frames = null;
        this._blocks = null;
        this._updateElements = true;
    }

    URL getBaseURL() {
        return this._baseURL;
    }

    WebResponse getResponse() {
        return this._response;
    }

    Node getOriginalDOM() {
        return this.getRootNode();
    }

    HTMLElement getElement(Node node) {
        return (HTMLElement)this._registry.getRegisteredElement(node);
    }

    public WebFrame[] getFrames() {
        if (this._frames == null) {
            this.loadElements();
            this._frames = this._frameList.toArray(new WebFrame[this._frameList.size()]);
        }
        return this._frames;
    }

    Node getRootNode() {
        if (this._rootNode == null) {
            throw new IllegalStateException("The root node has not been specified");
        }
        return this._rootNode;
    }

    private WebTable getTableSatisfyingPredicate(WebTable[] tables, HTMLElementPredicate predicate, Object value) {
        for (int i = 0; i < tables.length; ++i) {
            if (predicate.matchesCriteria(tables[i], value)) {
                return tables[i];
            }
            for (int j = 0; j < tables[i].getRowCount(); ++j) {
                for (int k = 0; k < tables[i].getColumnCount(); ++k) {
                    WebTable result;
                    WebTable[] innerTables;
                    TableCell cell = tables[i].getTableCell(j, k);
                    if (cell == null || (innerTables = cell.getTables()).length == 0 || (result = this.getTableSatisfyingPredicate(innerTables, predicate, value)) == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private WebTable[] getTablesSatisfyingPredicate(WebTable[] tables, HTMLElementPredicate predicate, Object value) {
        ArrayList<WebTable> matches = new ArrayList<WebTable>();
        for (int i = 0; i < tables.length; ++i) {
            if (predicate.matchesCriteria(tables[i], value)) {
                matches.add(tables[i]);
            }
            for (int j = 0; j < tables[i].getRowCount(); ++j) {
                for (int k = 0; k < tables[i].getColumnCount(); ++k) {
                    WebTable[] result;
                    WebTable[] innerTables;
                    TableCell cell = tables[i].getTableCell(j, k);
                    if (cell == null || (innerTables = cell.getTables()).length == 0 || (result = this.getTablesSatisfyingPredicate(innerTables, predicate, value)) == null || result.length <= 0) continue;
                    for (int l = 0; l < result.length; ++l) {
                        matches.add(result[l]);
                    }
                }
            }
        }
        if (matches.size() > 0) {
            return matches.toArray(new WebTable[matches.size()]);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _htmlFactoryClasses.put("a", new WebLinkFactory());
        _htmlFactoryClasses.put("area", new WebLinkFactory());
        _htmlFactoryClasses.put("form", new WebFormFactory());
        _htmlFactoryClasses.put("img", new WebImageFactory());
        _htmlFactoryClasses.put("applet", new WebAppletFactory());
        _htmlFactoryClasses.put("table", new WebTableFactory());
        _htmlFactoryClasses.put("tr", new TableRowFactory());
        _htmlFactoryClasses.put("td", new TableCellFactory());
        _htmlFactoryClasses.put("th", new TableCellFactory());
        _htmlFactoryClasses.put("frame", new WebFrameFactory());
        _htmlFactoryClasses.put("iframe", new WebIFrameFactory());
        _htmlFactoryClasses.put("script", new ScriptFactory());
        _htmlFactoryClasses.put("noscript", new NoScriptFactory());
        _htmlFactoryClasses.put("ol", new WebListFactory());
        _htmlFactoryClasses.put("ul", new WebListFactory());
        _htmlFactoryClasses.put("li", new ListItemFactory());
        for (int i = 0; i < TEXT_ELEMENTS.length; ++i) {
            _htmlFactoryClasses.put(TEXT_ELEMENTS[i], new TextBlockFactory());
        }
        Iterator<String> i = Arrays.asList(FormControl.getControlElementTags()).iterator();
        while (i.hasNext()) {
            _htmlFactoryClasses.put(i.next(), new FormControlFactory());
        }
    }

    class NoScriptElement
    extends HTMLElementBase
    implements ContentConcealer {
        public NoScriptElement(Node node) {
            super(node);
        }

        public ScriptableDelegate newScriptable() {
            return null;
        }

        public ScriptableDelegate getParentDelegate() {
            return null;
        }
    }

    class WebIFrame
    extends WebFrame
    implements ContentConcealer {
        public WebIFrame(URL baseURL, Node frameNode, FrameSelector parentFrame) {
            super(ParsedHTML.this._response, baseURL, frameNode, parentFrame);
        }
    }

    static class ListItemFactory
    extends HTMLElementFactory {
        ListItemFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            WebList webList = this.getWebList(pot);
            if (webList == null) {
                return null;
            }
            return webList.addNewItem(element);
        }

        private WebList getWebList(NodeUtils.PreOrderTraversal pot) {
            return (WebList)this.getClosestContext(pot, class$com$meterware$httpunit$WebList == null ? (class$com$meterware$httpunit$WebList = ParsedHTML.class$("com.meterware.httpunit.WebList")) : class$com$meterware$httpunit$WebList);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
        }
    }

    static class WebListFactory
    extends HTMLElementFactory {
        WebListFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toOrderedList(element);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            TextBlock textBlock = this.getTextBlock(pot);
            if (textBlock != null) {
                textBlock.addList((WebList)htmlElement);
            }
        }

        private TextBlock getTextBlock(NodeUtils.PreOrderTraversal pot) {
            return (TextBlock)this.getClosestContext(pot, class$com$meterware$httpunit$TextBlock == null ? (class$com$meterware$httpunit$TextBlock = ParsedHTML.class$("com.meterware.httpunit.TextBlock")) : class$com$meterware$httpunit$TextBlock);
        }
    }

    static class FormControlFactory
    extends HTMLElementFactory {
        FormControlFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            HTMLFormElement form = ((HTMLControl)element).getForm();
            if (form == null) {
                return this.newControlWithoutForm(parsedHTML, element);
            }
            return parsedHTML.getWebForm(form).newFormControl(element);
        }

        private HTMLElement newControlWithoutForm(ParsedHTML parsedHTML, Element element) {
            if ((element.getNodeName().equalsIgnoreCase("button") || element.getNodeName().equalsIgnoreCase("input")) && this.isValidNonFormButtonType(NodeUtils.getNodeAttribute(element, "type"))) {
                return parsedHTML.toButtonWithoutForm(element);
            }
            return null;
        }

        private boolean isValidNonFormButtonType(String buttonType) {
            return buttonType.equals("") || buttonType.equalsIgnoreCase("button");
        }
    }

    static class TableCellFactory
    extends HTMLElementFactory {
        TableCellFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            TableRow tr = this.getTableRow(pot);
            if (tr == null) {
                return null;
            }
            return tr.newTableCell((HTMLTableCellElement)element);
        }

        private TableRow getTableRow(NodeUtils.PreOrderTraversal pot) {
            return (TableRow)this.getClosestContext(pot, class$com$meterware$httpunit$TableRow == null ? (class$com$meterware$httpunit$TableRow = ParsedHTML.class$("com.meterware.httpunit.TableRow")) : class$com$meterware$httpunit$TableRow);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            this.getTableRow(pot).addTableCell((TableCell)htmlElement);
        }
    }

    static class TableRowFactory
    extends HTMLElementFactory {
        TableRowFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            WebTable wt = this.getWebTable(pot);
            if (wt == null) {
                return null;
            }
            return wt.newTableRow((HTMLTableRowElement)element);
        }

        private WebTable getWebTable(NodeUtils.PreOrderTraversal pot) {
            return (WebTable)this.getClosestContext(pot, class$com$meterware$httpunit$WebTable == null ? (class$com$meterware$httpunit$WebTable = ParsedHTML.class$("com.meterware.httpunit.WebTable")) : class$com$meterware$httpunit$WebTable);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            this.getWebTable(pot).addRow((TableRow)htmlElement);
        }
    }

    static class WebTableFactory
    extends HTMLElementFactory {
        WebTableFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebTable(element);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            Iterator i = pot.getContexts();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof ParsedHTML) {
                    ((ParsedHTML)o).addToList(htmlElement);
                }
                if (!(o instanceof TableCell)) continue;
                break;
            }
        }
    }

    static class WebAppletFactory
    extends HTMLElementFactory {
        WebAppletFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebApplet(element);
        }

        protected boolean addToContext() {
            return true;
        }
    }

    static class WebImageFactory
    extends HTMLElementFactory {
        WebImageFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebImage(element);
        }
    }

    static class WebIFrameFactory
    extends HTMLElementFactory {
        WebIFrameFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebIFrame(element);
        }

        protected boolean isRecognized(ClientProperties properties) {
            return properties.isIframeSupported();
        }

        protected boolean addToContext() {
            return true;
        }
    }

    static class WebFrameFactory
    extends HTMLElementFactory {
        WebFrameFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebFrame(element);
        }
    }

    static class NoScriptFactory
    extends HTMLElementFactory {
        NoScriptFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toNoscriptElement(element);
        }

        protected boolean addToContext() {
            return true;
        }
    }

    static class ScriptFactory
    extends HTMLElementFactory {
        ScriptFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return null;
        }

        void recordElement(NodeUtils.PreOrderTraversal pot, Element element, ParsedHTML parsedHTML) {
            parsedHTML.interpretScriptElement(element);
        }
    }

    static class TextBlockFactory
    extends HTMLElementFactory {
        TextBlockFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toTextBlock(element);
        }

        protected boolean addToContext() {
            return true;
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            Iterator i = pot.getContexts();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof ParsedHTML)) continue;
                ((ParsedHTML)o).addToList(htmlElement);
                break;
            }
        }
    }

    static class WebLinkFactory
    extends HTMLElementFactory {
        WebLinkFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toLinkAnchor(element);
        }
    }

    static class WebFormFactory
    extends HTMLElementFactory {
        WebFormFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toWebForm(element);
        }
    }

    static class DefaultElementFactory
    extends HTMLElementFactory {
        DefaultElementFactory() {
        }

        HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal pot, ParsedHTML parsedHTML, Element element) {
            return parsedHTML.toDefaultElement(element);
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
        }
    }

    static abstract class HTMLElementFactory
    extends HtmlElementRecorder {
        HTMLElementFactory() {
        }

        abstract HTMLElement toHTMLElement(NodeUtils.PreOrderTraversal var1, ParsedHTML var2, Element var3);

        void recordElement(NodeUtils.PreOrderTraversal pot, Element element, ParsedHTML parsedHTML) {
            HTMLElement htmlElement = this.toHTMLElement(pot, parsedHTML, element);
            this.recordHtmlElement(pot, element, htmlElement);
        }

        protected boolean isRecognized(ClientProperties properties) {
            return true;
        }

        protected boolean addToContext() {
            return false;
        }

        protected final ParsedHTML getParsedHTML(NodeUtils.PreOrderTraversal pot) {
            return (ParsedHTML)this.getClosestContext(pot, class$com$meterware$httpunit$ParsedHTML == null ? (class$com$meterware$httpunit$ParsedHTML = ParsedHTML.class$("com.meterware.httpunit.ParsedHTML")) : class$com$meterware$httpunit$ParsedHTML);
        }

        protected final Object getClosestContext(NodeUtils.PreOrderTraversal pot, Class aClass) {
            return pot.getClosestContext(aClass);
        }

        protected ParsedHTML getRootContext(NodeUtils.PreOrderTraversal pot) {
            return (ParsedHTML)pot.getRootContext();
        }
    }

    static class HtmlElementRecorder {
        HtmlElementRecorder() {
        }

        protected void recordHtmlElement(NodeUtils.PreOrderTraversal pot, Node node, HTMLElement htmlElement) {
            if (htmlElement != null) {
                this.addToMaps(pot, node, htmlElement);
                this.addToLists(pot, htmlElement);
            }
        }

        protected void addToLists(NodeUtils.PreOrderTraversal pot, HTMLElement htmlElement) {
            Iterator i = pot.getContexts();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof ParsedHTML)) continue;
                ((ParsedHTML)o).addToList(htmlElement);
            }
        }

        protected void addToMaps(NodeUtils.PreOrderTraversal pot, Node node, HTMLElement htmlElement) {
            Iterator i = pot.getContexts();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof ParsedHTML)) continue;
                ((ParsedHTML)o).addToMaps(node, htmlElement);
            }
        }
    }
}

