/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.protocol.UploadFileSpec;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

final class UncheckedParameterHolder
extends ParameterHolder
implements ParameterProcessor {
    private static final String[] NO_VALUES = new String[0];
    private final String _characterSet;
    private Hashtable _parameters = new Hashtable();
    private boolean _submitAsMime;

    UncheckedParameterHolder() {
        this._characterSet = HttpUnitOptions.getDefaultCharacterSet();
    }

    UncheckedParameterHolder(WebRequestSource source) {
        this._characterSet = source.getCharacterSet();
        this._submitAsMime = source.isSubmitAsMime();
        try {
            source.recordPredefinedParameters(this);
            source.recordParameters(this);
        }
        catch (IOException e) {
            throw new RuntimeException("This should never happen");
        }
    }

    public void addParameter(String name, String value, String characterSet) throws IOException {
        Object[] values = (Object[])this._parameters.get(name);
        this._parameters.put(name, HttpUnitUtils.withNewValue(values, (Object)value));
    }

    public void addFile(String parameterName, UploadFileSpec fileSpec) throws IOException {
        Object[] values = (Object[])this._parameters.get(parameterName);
        this._parameters.put(parameterName, HttpUnitUtils.withNewValue(values, fileSpec));
    }

    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        if (imageButton.isValidImageButton()) {
            this.setParameter(imageButton.positionParameterName("x"), Integer.toString(x));
            this.setParameter(imageButton.positionParameterName("y"), Integer.toString(y));
        }
    }

    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
    }

    public void recordParameters(ParameterProcessor processor) throws IOException {
        Enumeration e = this._parameters.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object[] values = (Object[])this._parameters.get(name);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] instanceof String || values[i] == null) {
                    processor.addParameter(name, (String)values[i], this._characterSet);
                    continue;
                }
                if (!(values[i] instanceof UploadFileSpec)) continue;
                processor.addFile(name, (UploadFileSpec)values[i]);
            }
        }
    }

    String[] getParameterNames() {
        return this._parameters.keySet().toArray(new String[this._parameters.size()]);
    }

    String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? null : values[0];
    }

    String[] getParameterValues(String name) {
        Object[] values = (Object[])this._parameters.get(name);
        if (values == null) {
            return NO_VALUES;
        }
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = values[i] instanceof UploadFileSpec ? ((UploadFileSpec)values[i]).getFileName() : values[i].toString();
        }
        return result;
    }

    void removeParameter(String name) {
        this._parameters.remove(name);
    }

    void setParameter(String name, String value) {
        this._parameters.put(name, new Object[]{value});
    }

    void setParameter(String name, String[] values) {
        this._parameters.put(name, values);
    }

    void setParameter(String name, UploadFileSpec[] files) {
        this._parameters.put(name, files);
    }

    boolean isFileParameter(String name) {
        return true;
    }

    String getCharacterSet() {
        return this._characterSet;
    }

    boolean isSubmitAsMime() {
        return this._submitAsMime;
    }
}

