/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.controls;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.controls.IllegalParameterValueException;
import com.meterware.httpunit.dom.HTMLSelectElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.SelectionOption;
import com.meterware.httpunit.scripting.SelectionOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectionFormControl
extends FormControl {
    private final boolean _multiSelect;
    private final boolean _listBox;
    private Options _selectionOptions;

    public String getType() {
        return this.isMultiValued() ? "select-multiple" : "select-one";
    }

    public SelectionFormControl(WebForm form, HTMLSelectElementImpl element) {
        super(form, element);
        if (!element.getNodeName().equalsIgnoreCase("select")) {
            throw new RuntimeException("Not a select element");
        }
        int size = NodeUtils.getAttributeValue(element, "size", 0);
        this._multiSelect = NodeUtils.isNodeAttributePresent(element, "multiple");
        this._listBox = size > 1 || this._multiSelect && size != 1;
        this._selectionOptions = this._listBox ? new MultiSelectOptions(element) : new SingleSelectOptions(element);
    }

    public String[] getValues() {
        return this._selectionOptions.getSelectedValues();
    }

    public String[] getOptionValues() {
        return this._selectionOptions.getValues();
    }

    public String[] getDisplayedOptions() {
        return this._selectionOptions.getDisplayedText();
    }

    public boolean isMultiValued() {
        return this._multiSelect;
    }

    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    void updateRequiredParameters(Hashtable required) {
        if (this.isReadOnly()) {
            required.put(this.getName(), this.getValues());
        }
    }

    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.isDisabled()) {
            return;
        }
        for (int i = 0; i < this.getValues().length; ++i) {
            processor.addParameter(this.getName(), this.getValues()[i], characterSet);
        }
    }

    protected void claimUniqueValue(List values) {
        boolean changed = this._selectionOptions.claimUniqueValues(values);
        if (changed) {
            this.sendOnChangeEvent();
        }
    }

    protected void reset() {
        this._selectionOptions.reset();
    }

    class MultiSelectOptions
    extends Options {
        public MultiSelectOptions(Node selectionNode) {
            super(selectionNode);
        }

        protected void ensureUniqueOption(Option[] options, int i) {
        }

        protected int noOptionSelectedIndex() {
            return -1;
        }

        protected boolean claimUniqueValues(List values, Option[] options) {
            boolean changed = false;
            for (int i = 0; i < options.length; ++i) {
                boolean newValue = values.contains(options[i].getValue());
                if (newValue != options[i].isSelected()) {
                    changed = true;
                }
                options[i].setSelected(newValue);
                if (!newValue) continue;
                values.remove(options[i].getValue());
            }
            return changed;
        }
    }

    class SingleSelectOptions
    extends Options {
        public SingleSelectOptions(Node selectionNode) {
            super(selectionNode);
        }

        protected void ensureUniqueOption(Option[] options, int i) {
            for (int j = 0; j < options.length; ++j) {
                options[j]._selected = i == j;
            }
        }

        protected int noOptionSelectedIndex() {
            return 0;
        }

        protected boolean claimUniqueValues(List values, Option[] options) {
            boolean changed = false;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                for (int j = 0; j < options.length; ++j) {
                    boolean selected = value.equals(options[j].getValue());
                    if (selected != options[j].isSelected()) {
                        changed = true;
                    }
                    options[j].setSelected(selected);
                    if (!selected) continue;
                    values.remove(value);
                    ++j;
                    while (j < options.length) {
                        options[j].setSelected(false);
                        ++j;
                    }
                    return changed;
                }
            }
            this.reportNoMatches(values);
            return changed;
        }
    }

    public abstract class Options
    extends ScriptableDelegate
    implements SelectionOptions {
        private Option[] _options;

        Options(Node selectionNode) {
            NodeList nl = ((Element)selectionNode).getElementsByTagName("OPTION");
            this._options = new Option[nl.getLength()];
            for (int i = 0; i < this._options.length; ++i) {
                String displayedText = this.getValue(nl.item(i).getFirstChild()).trim();
                this._options[i] = new Option(displayedText, this.getOptionValue(nl.item(i), displayedText), nl.item(i).getAttributes().getNamedItem("selected") != null);
                this._options[i].setIndex(this, i);
            }
        }

        boolean claimUniqueValues(List values) {
            return this.claimUniqueValues(values, this._options);
        }

        protected abstract boolean claimUniqueValues(List var1, Option[] var2);

        protected final void reportNoMatches(List values) {
            if (!SelectionFormControl.this._listBox) {
                throw new IllegalParameterValueException(SelectionFormControl.this.getName(), values, SelectionFormControl.this.getOptionValues());
            }
        }

        String[] getSelectedValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this._options.length; ++i) {
                this._options[i].addValueIfSelected(list);
            }
            if (!SelectionFormControl.this._listBox && list.isEmpty() && this._options.length > 0) {
                list.add(this._options[0].getValue());
            }
            return list.toArray(new String[list.size()]);
        }

        void reset() {
            for (int i = 0; i < this._options.length; ++i) {
                this._options[i].reset();
            }
        }

        String[] getDisplayedText() {
            String[] displayedText = new String[this._options.length];
            for (int i = 0; i < displayedText.length; ++i) {
                displayedText[i] = this._options[i].getText();
            }
            return displayedText;
        }

        String[] getValues() {
            String[] values = new String[this._options.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this._options[i].getValue();
            }
            return values;
        }

        void setSelectedIndex(int index) {
            for (int i = 0; i < this._options.length; ++i) {
                this._options[i]._selected = i == index;
            }
        }

        int getFirstSelectedIndex() {
            for (int i = 0; i < this._options.length; ++i) {
                if (!this._options[i].isSelected()) continue;
                return i;
            }
            return this.noOptionSelectedIndex();
        }

        protected abstract int noOptionSelectedIndex();

        public int getLength() {
            return this._options.length;
        }

        public void setLength(int length) {
            if (length < 0) {
                return;
            }
            Option[] newArray = new Option[length];
            System.arraycopy(this._options, 0, newArray, 0, Math.min(length, this._options.length));
            for (int i = this._options.length; i < length; ++i) {
                newArray[i] = new Option();
            }
            this._options = newArray;
        }

        public void put(int i, SelectionOption option) {
            if (i < 0) {
                return;
            }
            if (option == null) {
                if (i >= this._options.length) {
                    return;
                }
                this.deleteOptionsEntry(i);
            } else {
                if (i >= this._options.length) {
                    i = this._options.length;
                    this.expandOptionsArray();
                }
                this._options[i] = (Option)option;
                this._options[i].setIndex(this, i);
                if (option.isSelected()) {
                    this.ensureUniqueOption(this._options, i);
                }
            }
        }

        protected abstract void ensureUniqueOption(Option[] var1, int var2);

        private void deleteOptionsEntry(int i) {
            Option[] newArray = new Option[this._options.length - 1];
            System.arraycopy(this._options, 0, newArray, 0, i);
            System.arraycopy(this._options, i + 1, newArray, i, newArray.length - i);
            this._options = newArray;
        }

        private void expandOptionsArray() {
            Option[] newArray = new Option[this._options.length + 1];
            System.arraycopy(this._options, 0, newArray, 0, this._options.length);
            this._options = newArray;
        }

        public Object get(int index) {
            if (index < 0 || index >= this._options.length) {
                String msg = "invalid index " + index + " for Options ";
                for (int i = 0; i < this._options.length; ++i) {
                    msg = msg + this._options[i]._text;
                    if (i >= this._options.length - 1) continue;
                    msg = msg + ",";
                }
                throw new RuntimeException(msg);
            }
            return this._options[index];
        }

        void optionSet(int i) {
            this.ensureUniqueOption(this._options, i);
        }

        private String getOptionValue(Node optionNode, String displayedText) {
            NamedNodeMap nnm = optionNode.getAttributes();
            if (nnm.getNamedItem("value") != null) {
                return this.getValue(nnm.getNamedItem("value"));
            }
            return displayedText;
        }

        private String getValue(Node node) {
            return node == null ? "" : SelectionFormControl.this.emptyIfNull(node.getNodeValue());
        }
    }

    public static class Option
    extends ScriptableDelegate
    implements SelectionOption {
        private String _text = "";
        private String _value;
        private boolean _defaultSelected;
        private boolean _selected;
        private int _index;
        private Options _container;

        public Option() {
        }

        Option(String text, String value, boolean selected) {
            this._text = text;
            this._value = value;
            this._defaultSelected = this._selected = selected;
        }

        void reset() {
            this._selected = this._defaultSelected;
        }

        void addValueIfSelected(List list) {
            if (this._selected) {
                list.add(this._value);
            }
        }

        void setIndex(Options container, int index) {
            this._container = container;
            this._index = index;
        }

        public void initialize(String text, String value, boolean defaultSelected, boolean selected) {
            this._text = text;
            this._value = value;
            this._defaultSelected = defaultSelected;
            this._selected = selected;
        }

        public int getIndex() {
            return this._index;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public boolean isDefaultSelected() {
            return this._defaultSelected;
        }

        public void setSelected(boolean selected) {
            this._selected = selected;
            if (selected) {
                this._container.optionSet(this._index);
            }
        }

        public boolean isSelected() {
            return this._selected;
        }
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("options")) {
                return SelectionFormControl.this._selectionOptions;
            }
            if (propertyName.equalsIgnoreCase("length")) {
                return new Integer(SelectionFormControl.this.getOptionValues().length);
            }
            if (propertyName.equalsIgnoreCase("value")) {
                return this.getSelectedValue();
            }
            if (propertyName.equalsIgnoreCase("selectedIndex")) {
                return new Integer(SelectionFormControl.this._selectionOptions.getFirstSelectedIndex());
            }
            return super.get(propertyName);
        }

        public Object get(int index) {
            return SelectionFormControl.this._selectionOptions.get(index);
        }

        private String getSelectedValue() {
            String[] values = SelectionFormControl.this.getValues();
            return values.length == 0 ? "" : values[0];
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("value")) {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(value);
                SelectionFormControl.this._selectionOptions.claimUniqueValues(values);
            } else if (propertyName.equalsIgnoreCase("selectedIndex")) {
                if (!(value instanceof Number)) {
                    throw new RuntimeException("selectedIndex must be set to an integer");
                }
                SelectionFormControl.this._selectionOptions.setSelectedIndex(((Number)value).intValue());
            } else if (propertyName.equalsIgnoreCase("length")) {
                SelectionFormControl.this._selectionOptions.setLength(((Number)value).intValue());
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

