/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLCollectionImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLOptionElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class HTMLSelectElementImpl
extends HTMLControl
implements HTMLSelectElement {
    public static final String TYPE_SELECT_ONE = "select-one";
    public static final String TYPE_SELECT_MULTIPLE = "select-multiple";

    ElementImpl create() {
        return new HTMLSelectElementImpl();
    }

    public void add(HTMLElement element, HTMLElement before) throws DOMException {
    }

    public void blur() {
        this.handleEvent("onblur");
    }

    public void focus() {
        this.handleEvent("onfocus");
    }

    public String getType() {
        return this.isMultiSelect() ? TYPE_SELECT_MULTIPLE : TYPE_SELECT_ONE;
    }

    private boolean isMultiSelect() {
        return this.getMultiple() && this.getSize() > 1;
    }

    public int getLength() {
        return this.getOptions().getLength();
    }

    public boolean getMultiple() {
        return this.getBooleanAttribute("multiple");
    }

    public HTMLCollection getOptions() {
        return HTMLCollectionImpl.createHTMLCollectionImpl(this.getElementsByTagName(this.getHtmlDocument().toNodeCase("option")));
    }

    public int getSelectedIndex() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            if (!((HTMLOptionElement)options.item(i)).getSelected()) continue;
            return i;
        }
        return this.isMultiSelect() ? -1 : 0;
    }

    public String getValue() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLOptionElement optionElement = (HTMLOptionElement)options.item(i);
            if (!optionElement.getSelected()) continue;
            return optionElement.getValue();
        }
        return this.isMultiSelect() || options.getLength() == 0 ? null : ((HTMLOptionElement)options.item(0)).getValue();
    }

    public int getSize() {
        return this.getIntegerAttribute("size");
    }

    public void remove(int index) {
    }

    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple);
    }

    public void setSelectedIndex(int selectedIndex) {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLOptionElementImpl optionElement = (HTMLOptionElementImpl)options.item(i);
            optionElement.setSelected(i == selectedIndex);
        }
    }

    public void setSize(int size) {
        this.setAttribute("size", size);
    }

    int getIndexOf(HTMLOptionElementImpl option) {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            if (options.item(i) != option) continue;
            return i;
        }
        throw new IllegalStateException("option is not part of this select");
    }

    void clearSelected() {
        this.setSelectedIndex(-1);
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        HTMLCollection options = this.getOptions();
        String name = this.getName();
        for (int i = 0; i < options.getLength(); ++i) {
            ((HTMLOptionElementImpl)options.item(i)).addValueIfSelected(processor, name, characterSet);
        }
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public void reset() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLControl optionElement = (HTMLControl)options.item(i);
            optionElement.reset();
        }
    }
}

