/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AbstractDomComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;

class ScriptingSupport {
    private static final Method NO_SUCH_PROPERTY = (class$com$meterware$httpunit$dom$ScriptingSupport == null ? (class$com$meterware$httpunit$dom$ScriptingSupport = ScriptingSupport.class$("com.meterware.httpunit.dom.ScriptingSupport")) : class$com$meterware$httpunit$dom$ScriptingSupport).getDeclaredMethods()[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static Hashtable _classFunctionMaps = new Hashtable();
    private static Hashtable _classGetterMaps = new Hashtable();
    private static Hashtable _classSetterMaps = new Hashtable();
    static /* synthetic */ Class class$com$meterware$httpunit$dom$ScriptingSupport;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;

    ScriptingSupport() {
    }

    static boolean hasNamedProperty(Object element, String javaPropertyName, Scriptable scriptable) {
        Method getter = ScriptingSupport.getPropertyGetter(element.getClass(), javaPropertyName);
        if (getter != NO_SUCH_PROPERTY) {
            return true;
        }
        FunctionObject function = ScriptingSupport.getFunctionObject(element.getClass(), javaPropertyName, scriptable);
        return function != null;
    }

    static Object getNamedProperty(Object element, String javaPropertyName, Scriptable scriptable) {
        Method getter = ScriptingSupport.getPropertyGetter(element.getClass(), javaPropertyName);
        if (getter == NO_SUCH_PROPERTY) {
            FunctionObject function = ScriptingSupport.getFunctionObject(element.getClass(), javaPropertyName, scriptable);
            return function == null ? Scriptable.NOT_FOUND : function;
        }
        try {
            return getter.invoke(element, NO_ARGS);
        }
        catch (IllegalAccessException e) {
            return Scriptable.NOT_FOUND;
        }
        catch (InvocationTargetException e) {
            return Scriptable.NOT_FOUND;
        }
    }

    private static FunctionObject getFunctionObject(Class aClass, String methodName, Scriptable scriptable) {
        Object result;
        Hashtable<String, Object> functionMap = (Hashtable<String, Object>)_classFunctionMaps.get(aClass);
        if (functionMap == null) {
            functionMap = new Hashtable<String, Object>();
            _classFunctionMaps.put(aClass, functionMap);
        }
        if ((result = functionMap.get(methodName)) == NO_SUCH_PROPERTY) {
            return null;
        }
        if (result != null) {
            return (FunctionObject)result;
        }
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            FunctionObject function = new FunctionObject(methodName, (Member)method, scriptable);
            functionMap.put(methodName, function);
            return function;
        }
        functionMap.put(methodName, NO_SUCH_PROPERTY);
        return null;
    }

    private static Method getPropertyGetter(Class aClass, String propertyName) {
        Method result;
        Hashtable<String, Method> methodMap = (Hashtable<String, Method>)_classGetterMaps.get(aClass);
        if (methodMap == null) {
            methodMap = new Hashtable<String, Method>();
            _classGetterMaps.put(aClass, methodMap);
        }
        if ((result = (Method)methodMap.get(propertyName)) != null) {
            return result;
        }
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length > 0 || !method.getName().equalsIgnoreCase("is" + propertyName) && !method.getName().equalsIgnoreCase("get" + propertyName)) continue;
            methodMap.put(propertyName, method);
            return method;
        }
        methodMap.put(propertyName, NO_SUCH_PROPERTY);
        return NO_SUCH_PROPERTY;
    }

    static void setNamedProperty(AbstractDomComponent element, String javaPropertyName, Object value) {
        Method setter = ScriptingSupport.getPropertySetter(element.getClass(), javaPropertyName, value);
        if (setter == NO_SUCH_PROPERTY) {
            return;
        }
        try {
            setter.invoke((Object)element, ScriptingSupport.adjustedForSetter(value, setter));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    private static Object adjustedForSetter(Object value, Method setter) {
        if (value == null) {
            return null;
        }
        Class<?> targetValueClass = setter.getParameterTypes()[0];
        if (targetValueClass.equals(class$java$lang$String == null ? (class$java$lang$String = ScriptingSupport.class$("java.lang.String")) : class$java$lang$String)) {
            return value.toString();
        }
        if (!(value instanceof Number) || !ScriptingSupport.isNumericParameter(targetValueClass)) {
            return value;
        }
        if (targetValueClass.getName().equals("int")) {
            return new Integer(((Number)value).intValue());
        }
        if (targetValueClass.getName().equals("byte")) {
            return new Byte(((Number)value).byteValue());
        }
        if (targetValueClass.getName().equals("long")) {
            return new Long(((Number)value).longValue());
        }
        if (targetValueClass.getName().equals("short")) {
            return new Short(((Number)value).shortValue());
        }
        if (targetValueClass.getName().equals("float")) {
            return new Float(((Number)value).intValue());
        }
        if (targetValueClass.getName().equals("double")) {
            return new Double(((Number)value).intValue());
        }
        return value;
    }

    static Method getPropertySetter(Class aClass, String propertyName, Object value) {
        Method result;
        Hashtable<String, Method> methodMap = (Hashtable<String, Method>)_classSetterMaps.get(aClass);
        if (methodMap == null) {
            methodMap = new Hashtable<String, Method>();
            _classSetterMaps.put(aClass, methodMap);
        }
        if ((result = (Method)methodMap.get(propertyName)) != null) {
            return result;
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(setterName) || method.getParameterTypes().length != 1 || !ScriptingSupport.isConvertableTo(value.getClass(), method.getParameterTypes()[0])) continue;
            methodMap.put(propertyName, method);
            return method;
        }
        methodMap.put(propertyName, NO_SUCH_PROPERTY);
        return NO_SUCH_PROPERTY;
    }

    public static boolean isConvertableTo(Class valueType, Class parameterType) {
        if (valueType.equals(parameterType)) {
            return true;
        }
        if (parameterType.equals(class$java$lang$String == null ? (class$java$lang$String = ScriptingSupport.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (valueType.equals(class$java$lang$String == null ? (class$java$lang$String = ScriptingSupport.class$("java.lang.String")) : class$java$lang$String) && ScriptingSupport.isNumericParameter(parameterType)) {
            return true;
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ScriptingSupport.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueType) && ScriptingSupport.isNumericParameter(parameterType)) {
            return true;
        }
        if (valueType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScriptingSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean) && parameterType.equals(Boolean.TYPE)) {
            return true;
        }
        return valueType.equals(class$java$lang$String == null ? (class$java$lang$String = ScriptingSupport.class$("java.lang.String")) : class$java$lang$String) && parameterType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScriptingSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    private static boolean isNumericParameter(Class parameterType) {
        if (parameterType.isPrimitive() && !parameterType.equals(Boolean.TYPE)) {
            return true;
        }
        return (class$java$lang$Number == null ? (class$java$lang$Number = ScriptingSupport.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(parameterType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

