/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.parsing.JTidyPrintWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

class JTidyHTMLParser
implements HTMLParser {
    private static final char NBSP = '\u00a0';
    private static final String UTF_ENCODING = "UTF-8";

    JTidyHTMLParser() {
    }

    public void parse(URL pageURL, String pageText, DocumentAdapter adapter) throws IOException, SAXException {
        try {
            Document jtidyDocument = JTidyHTMLParser.getParser(pageURL).parseDOM((InputStream)new ByteArrayInputStream(pageText.getBytes(UTF_ENCODING)), null);
            HTMLDocumentImpl htmlDocument = new HTMLDocumentImpl();
            NodeList nl = jtidyDocument.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node importedNode = nl.item(i);
                if (importedNode.getNodeType() == 10) continue;
                htmlDocument.appendChild(htmlDocument.importNode(importedNode, true));
            }
            adapter.setDocument(htmlDocument);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    public String getCleanedText(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }

    public boolean supportsPreserveTagCase() {
        return false;
    }

    public boolean supportsForceTagCase() {
        return false;
    }

    public boolean supportsReturnHTMLDocument() {
        return true;
    }

    public boolean supportsParserWarnings() {
        return true;
    }

    private static Tidy getParser(URL url) {
        Tidy tidy = new Tidy();
        tidy.setCharEncoding(3);
        tidy.setQuiet(true);
        tidy.setShowWarnings(HTMLParserFactory.isParserWarningsEnabled());
        if (!HTMLParserFactory.getHTMLParserListeners().isEmpty()) {
            tidy.setErrout((PrintWriter)new JTidyPrintWriter(url));
        }
        return tidy;
    }
}

