/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class ReceivedHttpMessage {
    private static final int CR = 13;
    private static final int LF = 10;
    private Reader _reader;
    private Hashtable _headers = new Hashtable();
    private byte[] _requestBody;

    ReceivedHttpMessage(InputStream inputStream) throws IOException {
        this.interpretMessageHeader(this.readHeaderLine(inputStream));
        this.readHeaders(inputStream);
        this.readMessageBody(inputStream);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClassName()).append("[ ");
        this.appendMessageHeader(sb);
        sb.append("\n");
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            sb.append("      ").append(key).append(": ").append(this._headers.get(key)).append("\n");
        }
        sb.append("   body contains ").append(this.getBody().length).append(" byte(s)]");
        return sb.toString();
    }

    private String readHeaderLine(InputStream inputStream) throws IOException {
        return new String(this.readDelimitedChunk(inputStream));
    }

    private byte[] readDelimitedChunk(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = inputStream.read();
        while (b != 13) {
            baos.write(b);
            b = inputStream.read();
        }
        b = inputStream.read();
        if (b != 10) {
            throw new IOException("Bad header line termination: " + b);
        }
        return baos.toByteArray();
    }

    void appendContents(StringBuffer sb) {
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            sb.append("      ").append(key).append(": ").append(this._headers.get(key)).append("\n");
        }
        sb.append("   body contains ").append(this.getBody().length).append(" byte(s)");
    }

    Reader getReader() {
        return this._reader;
    }

    String getHeader(String name) {
        return (String)this._headers.get(name.toUpperCase());
    }

    byte[] getBody() {
        return this._requestBody;
    }

    private void readMessageBody(InputStream inputStream) throws IOException {
        if ("chunked".equalsIgnoreCase(this.getHeader("Transfer-Encoding"))) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (this.getNextChunkLength(inputStream) > 0) {
                baos.write(this.readDelimitedChunk(inputStream));
            }
            this.flushChunkTrailer(inputStream);
            this._requestBody = baos.toByteArray();
        } else {
            int totalExpected = this.getContentLength();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(totalExpected);
            byte[] buffer = new byte[1024];
            int count = -1;
            for (int total = 0; total < totalExpected && (count = inputStream.read(buffer)) != -1; total += count) {
                baos.write(buffer, 0, count);
            }
            baos.flush();
            this._requestBody = baos.toByteArray();
        }
        this._reader = new InputStreamReader(new ByteArrayInputStream(this._requestBody));
    }

    private void flushChunkTrailer(InputStream inputStream) throws IOException {
        byte[] line;
        while ((line = this.readDelimitedChunk(inputStream)).length > 0) {
        }
    }

    private int getNextChunkLength(InputStream inputStream) throws IOException {
        try {
            return Integer.parseInt(this.readHeaderLine(inputStream), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Unabled to read chunk length: " + e);
        }
    }

    private int getContentLength() {
        try {
            return Integer.parseInt(this.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readHeaders(InputStream inputStream) throws IOException {
        String lastHeader = null;
        String header = this.readHeaderLine(inputStream);
        while (header.length() > 0) {
            if (header.charAt(0) <= ' ') {
                if (lastHeader == null) continue;
                this._headers.put(lastHeader, this._headers.get(lastHeader) + header.trim());
            } else {
                lastHeader = header.substring(0, header.indexOf(58)).toUpperCase();
                this._headers.put(lastHeader, header.substring(header.indexOf(58) + 1).trim());
            }
            header = this.readHeaderLine(inputStream);
        }
    }

    private String getClassName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    abstract void appendMessageHeader(StringBuffer var1);

    abstract void interpretMessageHeader(String var1);
}

