/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.engine.JRGenericPrintElement;

public class CVUtils {
    public static final String ELEMENT_ID_PREFIX = "element";

    public static boolean isRenderAsPng(JRGenericPrintElement element) {
        Object renderAsPngProperty;
        Map componentConfiguration;
        if (element.hasParameter("configuration") && (componentConfiguration = (Map)element.getParameterValue("configuration")).containsKey("renderAsPng") && (renderAsPngProperty = componentConfiguration.get("renderAsPng")) != null) {
            return Boolean.valueOf(renderAsPngProperty.toString());
        }
        return false;
    }

    public static float getZoomFactor(JRGenericPrintElement element) {
        Object property;
        Map componentConfiguration;
        if (element.hasParameter("configuration") && (componentConfiguration = (Map)element.getParameterValue("configuration")).containsKey("render-zoom-factor") && (property = componentConfiguration.get("render-zoom-factor")) != null) {
            try {
                return Float.valueOf(property.toString()).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1.0f;
    }

    public static long getTimeout(JRGenericPrintElement element) {
        Object property;
        Map componentConfiguration;
        if (element.hasParameter("configuration") && (componentConfiguration = (Map)element.getParameterValue("configuration")).containsKey("render-timeout") && (property = componentConfiguration.get("render-timeout")) != null) {
            try {
                return Long.valueOf(property.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 3000L;
    }

    public static void byteStreamCopy(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        while ((read = is.read(buf)) != -1) {
            os.write(buf, 0, read);
        }
    }

    public static String getResourceName(String resourceLocation) {
        int separatorIndex;
        int slashIndex = resourceLocation.lastIndexOf(47);
        int nameIndex = Math.max(slashIndex, separatorIndex = resourceLocation.lastIndexOf(File.separator));
        return nameIndex >= 0 ? resourceLocation.substring(nameIndex + 1) : resourceLocation;
    }

    public static String generateElementId() {
        UUID uuid = UUID.randomUUID();
        return ELEMENT_ID_PREFIX + Long.toUnsignedString(uuid.getMostSignificantBits()) + Long.toUnsignedString(uuid.getLeastSignificantBits());
    }

    public static String getElementId(JRGenericPrintElement element) {
        String elementId = (String)element.getParameterValue("elementId");
        if (elementId == null) {
            elementId = ELEMENT_ID_PREFIX + element.hashCode();
        }
        return elementId;
    }
}

