/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.fill;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.customvisualization.CVComponent;
import net.sf.jasperreports.customvisualization.CVPrintElement;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.Processor;
import net.sf.jasperreports.customvisualization.fill.CVFillItemData;
import net.sf.jasperreports.customvisualization.fill.CVFillItemProperty;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillContextProvider;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVFillComponent
extends BaseFillComponent
implements Serializable,
FillContextProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CVFillComponent.class);
    private final CVComponent component;
    private List<CVFillItemProperty> itemProperties;
    private List<CVFillItemData> itemDataList = new ArrayList<CVFillItemData>();
    private List<List<Map<String, Object>>> datasetsData = new ArrayList<List<Map<String, Object>>>();
    private Processor processor = null;
    private JasperReportsContext context = null;

    public CVFillComponent(CVComponent component, JRFillObjectFactory factory) {
        String processingClass;
        this.component = component;
        this.itemProperties = new ArrayList<CVFillItemProperty>();
        if (factory != null) {
            for (ItemProperty itemProperty : component.getItemProperties()) {
                this.itemProperties.add(new CVFillItemProperty(itemProperty, factory));
            }
            for (ItemData data : component.getItemData()) {
                if (data == null) continue;
                this.itemDataList.add(new CVFillItemData(this, data, factory));
                this.datasetsData.add(null);
            }
            this.context = factory.getFiller().getJasperReportsContext();
        }
        if ((processingClass = component.getProcessingClass()) != null && processingClass.length() > 0) {
            try {
                Class myClass = JRClassLoader.loadClassForName((String)processingClass);
                this.processor = (Processor)myClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException("Could not create processor instance.", (Throwable)e);
            }
        }
    }

    protected boolean isEvaluateNow() {
        return this.getComponent().getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    protected CVComponent getComponent() {
        return this.component;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateComponent(evaluation);
        }
    }

    public void evaluateComponent(byte evaluation) throws JRException {
        if (this.fillContext != null) {
            for (CVFillItemProperty itemProperty : this.itemProperties) {
                itemProperty.evaluate((JRFillExpressionEvaluator)this.fillContext, evaluation);
            }
            for (int i = 0; i < this.itemDataList.size(); ++i) {
                CVFillItemData itemData = this.itemDataList.get(i);
                if (itemData != null) {
                    List newSet = itemData.getEvaluateItems(evaluation);
                    ArrayList<Map> reallyNewSet = new ArrayList<Map>();
                    for (Map m : newSet) {
                        reallyNewSet.add(m);
                    }
                    this.datasetsData.set(i, reallyNewSet);
                    continue;
                }
                this.datasetsData.set(i, null);
            }
        }
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    protected JRTemplateGenericPrintElement createGenericPrintElement() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), (JRElement)this.fillContext.getComponentElement(), CVPrintElement.CV_ELEMENT_TYPE);
        template = (JRTemplateGenericElement)this.deduplicate((Deduplicable)template);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.printElementOriginator);
        printElement.setUUID(element.getUUID());
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (element.hasProperties()) {
            if (element.getPropertiesMap().getProperty("cv.keepTemporaryFiles") != null && element.getPropertiesMap().getProperty("cv.keepTemporaryFiles").equals("true")) {
                printElement.getPropertiesMap().setProperty("cv.keepTemporaryFiles", "true");
            }
            for (String ownPropName : element.getPropertiesMap().getOwnPropertyNames()) {
                if (!ownPropName.startsWith("com.jaspersoft.jasperreports.components.customvisualization.")) continue;
                printElement.getPropertiesMap().setProperty(ownPropName, element.getPropertiesMap().getProperty(ownPropName));
            }
        }
        String elementId = CVUtils.generateElementId();
        printElement.setParameterValue("elementId", (Object)elementId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("generating element " + elementId));
        }
        return printElement;
    }

    public JRPrintElement fill() {
        JRTemplateGenericPrintElement printElement = this.createGenericPrintElement();
        if (this.isEvaluateNow()) {
            this.evaluationPerformed(printElement);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printElement, this.getComponent().getEvaluationTime(), this.getComponent().getEvaluationGroup());
        }
        return printElement;
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateComponent(evaluation);
        this.evaluationPerformed((JRTemplateGenericPrintElement)element);
    }

    protected void evaluationPerformed(JRTemplateGenericPrintElement element) {
        String moduleName;
        Map<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("element", element);
        element.setParameterValue("onErrorType", (Object)this.component.getOnErrorType().getName());
        ArrayList<List<Map<String, Object>>> savedDatasetsData = new ArrayList<List<Map<String, Object>>>();
        for (int i = 0; i < this.datasetsData.size(); ++i) {
            savedDatasetsData.add(this.datasetsData.get(i));
            this.datasetsData.set(i, null);
        }
        configuration.put("series", savedDatasetsData);
        String scriptSource = null;
        String cssSource = null;
        for (CVFillItemProperty p : this.itemProperties) {
            if ("script".equals(p.getName())) {
                scriptSource = p.getValue();
                continue;
            }
            if ("css".equals(p.getName())) {
                cssSource = p.getValue();
                continue;
            }
            configuration.put(p.getName(), p.getValue());
        }
        if (this.processor != null) {
            try {
                configuration = this.processor.processConfiguration(configuration);
            }
            catch (Throwable t) {
                throw new JRRuntimeException("Custom Visualization component processing failed.", t);
            }
        }
        element.setParameterValue("configuration", configuration);
        element.setParameterValue("script_uri", (Object)this.toPrintLocation(scriptSource));
        if (cssSource != null && cssSource.trim().length() > 0) {
            element.setParameterValue("css_uri", (Object)this.toPrintLocation(cssSource));
        }
        String string = moduleName = configuration.containsKey("module") ? (String)configuration.get("module") : null;
        if (moduleName == null || moduleName.isEmpty()) {
            String location = null;
            if (scriptSource instanceof File) {
                location = ((File)((Object)scriptSource)).toURI().toString();
            } else if (scriptSource instanceof String) {
                location = scriptSource;
            }
            if (location != null) {
                File f = new File(location);
                String name = f.getName();
                if (name.toLowerCase().endsWith(".min.js")) {
                    name = name.substring(0, name.length() - 7);
                } else if (name.toLowerCase().endsWith(".js")) {
                    name = name.substring(0, name.length() - 3);
                }
                element.setParameterValue("module", (Object)name);
            }
        } else {
            element.setParameterValue("module", (Object)moduleName);
        }
        if (element.getParameterValue("module") == null) {
            throw new JRRuntimeException("No 'module' property defined for a Custom Visualization Component.");
        }
    }

    protected String toPrintLocation(String location) {
        RepositoryContext repositoryContext = this.fillContext.getFiller().getRepositoryContext();
        ResourceInfo resourceInfo = RepositoryUtil.getInstance((RepositoryContext)repositoryContext).getResourceInfo(location);
        return resourceInfo == null ? location : resourceInfo.getRepositoryResourceLocation();
    }

    public FillContext getFillContext() {
        return this.fillContext;
    }

    protected String loadResource(Object source, boolean fromClasspathOnly) {
        try {
            String location;
            byte[] scriptBytes = null;
            if (!fromClasspathOnly) {
                if (source instanceof InputStream) {
                    scriptBytes = JRLoader.loadBytes((InputStream)((InputStream)source));
                } else if (source instanceof URL) {
                    scriptBytes = JRLoader.loadBytes((URL)((URL)source));
                } else if (source instanceof File) {
                    scriptBytes = JRLoader.loadBytes((File)((File)source));
                } else if (source instanceof String) {
                    location = (String)source;
                    scriptBytes = RepositoryUtil.getInstance((JasperReportsContext)this.context).getBytesFromLocation(location);
                }
            }
            if (scriptBytes == null && source != null && source instanceof String && ((String)source).length() > 0 && this.checkResourceName(this.context, location = (String)source)) {
                scriptBytes = JRLoader.loadBytes((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(location));
            }
            if (scriptBytes == null) {
                String message = "No script provided for the Custom Visualization component. ";
                if (fromClasspathOnly) {
                    message = message + "(Loading of this resource is restricted to the classpath)";
                }
                throw new JRRuntimeException(message);
            }
            return new String(scriptBytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new JRRuntimeException("No script provided for the Custom Visualization component.", (Throwable)ex);
        }
    }

    protected boolean checkResourceName(JasperReportsContext jasperReportsContext, String resourceName) {
        boolean matched = false;
        List patternProps = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).getProperties("net.sf.jasperreports.web.resource.pattern.");
        for (JRPropertiesUtil.PropertySuffix patternProp : patternProps) {
            Pattern resourcePattern;
            String patternStr = patternProp.getValue();
            if (patternStr == null || patternStr.length() <= 0 || !(resourcePattern = Pattern.compile(patternStr)).matcher(resourceName).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("resource " + resourceName + " matched pattern " + resourcePattern));
            }
            matched = true;
            break;
        }
        if (!matched && log.isDebugEnabled()) {
            log.debug((Object)("Resource " + resourceName + " does not matched any allowed pattern"));
        }
        return matched;
    }
}

