/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.fill;

import net.sf.jasperreports.customvisualization.CVComponent;
import net.sf.jasperreports.customvisualization.export.CVElementImageProvider;
import net.sf.jasperreports.customvisualization.fill.CVFillComponent;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.renderers.Renderable;

public class CVFillImage
extends CVFillComponent {
    private JasperReportsContext jasperReportsContext;

    public CVFillImage(CVComponent component, JRFillObjectFactory factory) {
        super(component, factory);
        this.jasperReportsContext = factory.getFiller().getJasperReportsContext();
    }

    @Override
    public JRPrintElement fill() {
        JRPrintImage printImage = this.createPrintImage();
        if (this.isEvaluateNow()) {
            try {
                this.setImageRenderer(printImage);
            }
            catch (JRException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printImage, this.getComponent().getEvaluationTime(), this.getComponent().getEvaluationGroup());
        }
        return printImage;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateComponent(evaluation);
        this.setImageRenderer((JRPrintImage)element);
    }

    protected JRPrintImage createPrintImage() {
        JRComponentElement componentElement = this.fillContext.getComponentElement();
        JRTemplateImage template = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
        template.setElement((JRElement)componentElement);
        template.setLazy(false);
        template.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        template.setHorizontalImageAlign(HorizontalImageAlignEnum.LEFT);
        template.setVerticalImageAlign(VerticalImageAlignEnum.TOP);
        template = (JRTemplateImage)this.deduplicate((Deduplicable)template);
        JRTemplatePrintImage printImage = new JRTemplatePrintImage(template, this.printElementOriginator);
        printImage.setX(componentElement.getX());
        printImage.setY(this.fillContext.getElementPrintY());
        printImage.setWidth(componentElement.getWidth());
        printImage.setHeight(componentElement.getHeight());
        printImage.setUUID(componentElement.getUUID());
        printImage.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.embed.image", Boolean.TRUE.toString());
        printImage.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.embedded.svg.use.fonts", Boolean.TRUE.toString());
        return printImage;
    }

    protected void setImageRenderer(JRPrintImage image) throws JRException {
        JRTemplateGenericPrintElement genericPrintElement = this.createGenericPrintElement();
        this.evaluationPerformed(genericPrintElement);
        Renderable renderer = CVElementImageProvider.getInstance().createRenderable((JRGenericPrintElement)genericPrintElement, this.jasperReportsContext);
        image.setRenderer(renderer);
    }
}

