/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi;

import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.dataadapters.DataAdapterContributorFactory;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.poi.components.iconlabel.IconLabelElementXlsHandler;
import net.sf.jasperreports.poi.data.PoiDataAdapterServiceFactory;
import net.sf.jasperreports.poi.query.PoiQueryExecuterFactoryBundle;

public class PoiExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final GenericElementHandlerBundle HANDLER_BUNDLE = new GenericElementHandlerBundle(){

        public String getNamespace() {
            return "http://jasperreports.sourceforge.net/jasperreports";
        }

        public GenericElementHandler getHandler(String elementName, String exporterKey) {
            if ("iconLabel".equals(elementName) && "net.sf.jasperreports.xls".equals(exporterKey)) {
                return IconLabelElementXlsHandler.getInstance();
            }
            return null;
        }
    };
    private static final ExtensionsRegistry extensionsRegistry = new ExtensionsRegistry(){

        public <T> List<T> getExtensions(Class<T> extensionType) {
            if (JRQueryExecuterFactoryBundle.class.equals(extensionType)) {
                return Collections.singletonList(PoiQueryExecuterFactoryBundle.getInstance());
            }
            if (DataAdapterContributorFactory.class.equals(extensionType)) {
                return Collections.singletonList(PoiDataAdapterServiceFactory.getInstance());
            }
            if (GenericElementHandlerBundle.class.equals(extensionType)) {
                return Collections.singletonList(HANDLER_BUNDLE);
            }
            return null;
        }
    };

    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        return extensionsRegistry;
    }
}

