/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.io.IOException;
import java.util.Locale;
import net.sf.mmm.util.nls.api.NlsObject;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsMessage;

public class ComposedNlsMessage
extends AbstractNlsMessage {
    private static final long serialVersionUID = 1L;
    private Object[] arguments;

    protected ComposedNlsMessage() {
    }

    public ComposedNlsMessage(Object[] arguments) {
        assert (arguments != null);
        this.arguments = arguments;
    }

    @Override
    public Object getArgument(int index) {
        if (index >= this.arguments.length) {
            return null;
        }
        return this.arguments[index];
    }

    @Override
    public int getArgumentCount() {
        return this.arguments.length;
    }

    @Override
    public String getInternationalizedMessage() {
        return "";
    }

    @Override
    public Object getArgument(String key) {
        try {
            int index = Integer.parseInt(key);
            return this.getArgument(index);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void getLocalizedMessage(Locale locale, NlsTemplateResolver resolver, Appendable buffer) {
        try {
            boolean newline = false;
            for (Object message : this.arguments) {
                if (newline) {
                    buffer.append('\n');
                } else {
                    newline = true;
                }
                if (message == null) {
                    buffer.append("null");
                    continue;
                }
                if (message instanceof NlsObject) {
                    NlsObject nlsObject = (NlsObject)message;
                    nlsObject.toNlsMessage().getLocalizedMessage(locale, resolver, buffer);
                    continue;
                }
                buffer.append(message.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing to Appendable.", e);
        }
    }
}

