/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.base.NlsArgumentDescriptor;
import net.sf.mmm.util.nls.base.NlsBundleHelper;
import net.sf.mmm.util.nls.base.NlsMessageDescriptor;

public class NlsBundleDescriptor {
    private final ResourceBundle resourceBundle;
    private final Class<? extends NlsBundle> nlsBundleInterface;
    private Map<String, NlsMessageDescriptor> properties;
    private final String qualifiedName;
    private final String packageName;
    private final String packagePath;
    private final String qualifiedNamePath;
    private final String name;
    private final NlsBundleHelper bundleHelper;

    public NlsBundleDescriptor(ResourceBundle resourceBundle) {
        this(null, resourceBundle);
    }

    public NlsBundleDescriptor(Class<? extends NlsBundle> nlsBundleInterface) {
        this(nlsBundleInterface, null);
    }

    private NlsBundleDescriptor(Class<? extends NlsBundle> nlsBundleInterface, ResourceBundle resourceBundle) {
        this(nlsBundleInterface, resourceBundle, NlsBundleHelper.getInstance());
    }

    private NlsBundleDescriptor(Class<? extends NlsBundle> nlsBundleInterface, ResourceBundle resourceBundle, NlsBundleHelper bundleHelper) {
        this.bundleHelper = bundleHelper;
        this.nlsBundleInterface = nlsBundleInterface;
        this.resourceBundle = resourceBundle;
        this.qualifiedName = this.nlsBundleInterface != null ? this.bundleHelper.getQualifiedLocation(this.nlsBundleInterface) : this.resourceBundle.getClass().getName();
        int lastDot = this.qualifiedName.lastIndexOf(46);
        if (lastDot > 0) {
            this.packageName = this.qualifiedName.substring(0, lastDot);
            this.name = this.qualifiedName.substring(lastDot + 1);
        } else {
            this.packageName = "";
            this.name = this.qualifiedName;
        }
        this.qualifiedNamePath = this.qualifiedName.replace('.', '/');
        this.packagePath = this.packageName.replace('.', '/');
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getQualifiedNamePath() {
        return this.qualifiedNamePath;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public Map<String, NlsMessageDescriptor> getMessages() {
        block4: {
            if (this.properties != null) break block4;
            this.properties = new HashMap<String, NlsMessageDescriptor>();
            if (this.resourceBundle == null) {
                for (Method method : this.nlsBundleInterface.getMethods()) {
                    if (!this.bundleHelper.isNlsBundleMethod(method, false)) continue;
                    NlsMessageDescriptor descriptor = this.bundleHelper.getDescriptor(method);
                    this.properties.put(descriptor.getKey(), descriptor);
                }
            } else {
                Enumeration<String> keyEnum = this.resourceBundle.getKeys();
                while (keyEnum.hasMoreElements()) {
                    String key = keyEnum.nextElement();
                    String message = this.resourceBundle.getString(key);
                    NlsArgumentDescriptor[] arguments = this.getArguments(message);
                    NlsMessageDescriptor descriptor = new NlsMessageDescriptor(key, message, arguments);
                    this.properties.put(key, descriptor);
                }
            }
        }
        return this.properties;
    }

    public NlsMessageDescriptor getMessage(String key) {
        return this.getMessages().get(key);
    }

    public NlsMessageDescriptor getMessageRequired(String key) {
        NlsMessageDescriptor message = this.getMessage(key);
        if (message == null) {
            throw new IllegalArgumentException(key);
        }
        return message;
    }

    private NlsArgumentDescriptor[] getArguments(String message) {
        return null;
    }
}

