/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.base.NlsBundleLocator;
import net.sf.mmm.util.nls.base.NlsBundleLocatorClasspathScanner;
import net.sf.mmm.util.nls.base.NlsBundleLocatorReflectionUtil;
import net.sf.mmm.util.nls.base.NlsBundleLocatorSpring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlsBundleLocatorDefault
implements NlsBundleLocator {
    private static final Logger LOG = LoggerFactory.getLogger(NlsBundleLocatorDefault.class);

    @Override
    public Iterable<Class<? extends NlsBundle>> findBundles() {
        try {
            return new NlsBundleLocatorClasspathScanner().findBundles();
        }
        catch (Throwable e) {
            LOG.debug("mmm-util-resource (ClasspathScanner) not available.", e);
            try {
                return new NlsBundleLocatorReflectionUtil().findBundles();
            }
            catch (Throwable e2) {
                LOG.debug("mmm-util-reflect (ReflectionUtil) not available.", e2);
                try {
                    return new NlsBundleLocatorSpring().findBundles();
                }
                catch (Throwable e3) {
                    LOG.debug("spring-core (PathMatchingResourcePatternResolver) not available.", e3);
                    throw new IllegalStateException("None of mmm-util-resource, mmm-util-reflect, or spring-core on your classpath. Giving up!");
                }
            }
        }
    }
}

