/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.base.NlsBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class NlsBundleLocatorSpring
implements NlsBundleLocator {
    private static final Logger LOG = LoggerFactory.getLogger(NlsBundleLocatorSpring.class);

    @Override
    public Iterable<Class<? extends NlsBundle>> findBundles() {
        try {
            PathMatchingResourcePatternResolver scanner = new PathMatchingResourcePatternResolver();
            Resource[] resources = scanner.getResources("classpath*:**/NlsBundle*Root.class");
            BundleClassVisitor visitor = new BundleClassVisitor();
            for (Resource resource : resources) {
                try (InputStream in = resource.getInputStream();){
                    new ClassReader(in).accept((ClassVisitor)visitor, 0);
                }
            }
            return visitor.classes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class BundleClassVisitor
    extends ClassVisitor {
        private Set<Class<? extends NlsBundle>> classes = new HashSet<Class<? extends NlsBundle>>();

        private BundleClassVisitor() {
            super(393216);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 0x200) == 0) {
                return;
            }
            if (interfaces == null || interfaces.length == 0) {
                return;
            }
            String className = name.replace('/', '.');
            try {
                Class<?> clazz = Class.forName(className);
                if (NlsBundle.class.isAssignableFrom(clazz)) {
                    this.classes.add(clazz);
                }
            }
            catch (Exception e) {
                LOG.debug("Failed to load class {}", (Object)className, (Object)e);
            }
        }
    }
}

