/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Provider;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsBundleFactory;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.base.AbstractNlsBundleFactory;
import net.sf.mmm.util.nls.base.AbstractNlsMessage;
import net.sf.mmm.util.nls.base.NlsTemplateImplWithMessage;
import net.sf.mmm.util.nls.impl.AbstractResourceBundleNlsTemplateResolver;
import net.sf.mmm.util.nls.impl.NlsResourceBundleLocator;
import net.sf.mmm.util.nls.impl.NlsResourceBundleLocatorImpl;

public class DefaultNlsTemplateResolver
extends AbstractResourceBundleNlsTemplateResolver {
    private Map<String, NlsTemplate> i18nMsg2TemplateMap;
    private NlsResourceBundleLocator resourceBundleLocator;
    private NlsBundleFactory bundleFactory;

    protected void doInitialize() {
        super.doInitialize();
        if (this.resourceBundleLocator == null) {
            NlsResourceBundleLocatorImpl impl = new NlsResourceBundleLocatorImpl();
            impl.initialize();
            this.resourceBundleLocator = impl;
        }
        if (this.bundleFactory == null) {
            this.bundleFactory = NlsAccess.getBundleFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, NlsTemplate> getI18nMsg2TemplateMap() {
        if (this.i18nMsg2TemplateMap == null) {
            DefaultNlsTemplateResolver defaultNlsTemplateResolver = this;
            synchronized (defaultNlsTemplateResolver) {
                if (this.i18nMsg2TemplateMap == null) {
                    HashMap<String, NlsTemplate> map = new HashMap<String, NlsTemplate>();
                    this.initTemplates(map);
                    this.i18nMsg2TemplateMap = map;
                }
            }
        }
        return this.i18nMsg2TemplateMap;
    }

    protected void initTemplates(Map<String, NlsTemplate> map) {
        this.initTemplatesForNlsBundles(map);
        this.initTemplatesForResourceBundles(map);
    }

    protected void initTemplatesForResourceBundles(Map<String, NlsTemplate> map) {
        List<ResourceBundle> bundles = this.resourceBundleLocator.findBundles();
        for (ResourceBundle resourceBundle : bundles) {
            String name = resourceBundle.getBaseBundleName();
            if (name == null) {
                name = resourceBundle.getClass().getName();
            }
            Enumeration<String> keyEnum = resourceBundle.getKeys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                String message = resourceBundle.getString(key);
                NlsTemplateImplWithMessage template = new NlsTemplateImplWithMessage(name, key, message);
                map.put(message, template);
            }
        }
    }

    protected void initTemplatesForNlsBundles(Map<String, NlsTemplate> map) {
        if (this.bundleFactory instanceof AbstractNlsBundleFactory) {
            Collection<? extends AbstractNlsBundleFactory.NlsBundleDescriptor> bundleDescriptors = ((AbstractNlsBundleFactory)this.bundleFactory).getNlsBundleDescriptors();
            for (AbstractNlsBundleFactory.NlsBundleDescriptor nlsBundleDescriptor : bundleDescriptors) {
                for (Provider<NlsTemplate> provider : nlsBundleDescriptor.getTemplateContainers()) {
                    NlsTemplate template = (NlsTemplate)provider.get();
                    if (!(template instanceof NlsTemplateImplWithMessage)) continue;
                    String message = template.translate(AbstractNlsMessage.LOCALE_ROOT);
                    map.put(message, template);
                }
            }
        }
    }

    protected void doInitialized() {
        super.doInitialized();
        NlsAccess.setTemplateResolver(this);
    }

    public NlsResourceBundleLocator getResourceBundleFinder() {
        return this.resourceBundleLocator;
    }

    @Inject
    public void setResourceBundleLocator(NlsResourceBundleLocator resourceBundleLocator) {
        this.getInitializationState().requireNotInitilized();
        this.resourceBundleLocator = resourceBundleLocator;
    }

    @Inject
    public void setBundleFactory(NlsBundleFactory bundleFactory) {
        this.bundleFactory = bundleFactory;
    }

    @Override
    public NlsTemplate resolveTemplate(String internationalizedMessage) {
        return this.getI18nMsg2TemplateMap().get(internationalizedMessage);
    }
}

