/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.nls.base.AbstractNlsMessage;
import net.sf.mmm.util.nls.base.NlsBundleHelper;
import net.sf.mmm.util.nls.impl.NlsResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlsResourceBundleLocatorImpl
extends AbstractComponent
implements NlsResourceBundleLocator {
    private static final Logger LOG = LoggerFactory.getLogger(NlsResourceBundleLocatorImpl.class);
    private List<ResourceBundle> nlsBundles;

    protected List<ResourceBundle> getNlsBundles() {
        return this.nlsBundles;
    }

    public void setNlsBundles(List<ResourceBundle> nlsBundles) {
        this.getInitializationState().requireNotInitilized();
        this.nlsBundles = nlsBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceBundle> findBundles() {
        if (this.nlsBundles == null) {
            NlsResourceBundleLocatorImpl nlsResourceBundleLocatorImpl = this;
            synchronized (nlsResourceBundleLocatorImpl) {
                if (this.nlsBundles == null && this.nlsBundles == null) {
                    this.nlsBundles = Collections.unmodifiableList(this.loadNlsBundles());
                }
            }
        }
        return this.nlsBundles;
    }

    private List<ResourceBundle> loadNlsBundles() {
        Enumeration<URL> resourceUrlEnumeration;
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            resourceUrlEnumeration = ccl.getResources("META-INF/net.sf.mmm/nls-bundles");
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading from classpath.", e);
        }
        while (resourceUrlEnumeration.hasMoreElements()) {
            URL url = resourceUrlEnumeration.nextElement();
            LOG.trace("Loading {}", (Object)url);
            try {
                InputStream inStream = url.openStream();
                Throwable throwable = null;
                try {
                    InputStreamReader isr = new InputStreamReader(inStream);
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(isr);
                        Throwable throwable3 = null;
                        try {
                            boolean noEntryInBundleResource = true;
                            String line = reader.readLine();
                            while (line != null) {
                                ResourceBundle bundleInstance;
                                if ((line = line.trim()).length() > 0 && (bundleInstance = this.loadNlsBundle(LOG, url, line)) != null) {
                                    bundles.add(bundleInstance);
                                    noEntryInBundleResource = false;
                                }
                                line = reader.readLine();
                            }
                            if (!noEntryInBundleResource) continue;
                            LOG.error("Illegal bundle declaration {}: no entry!", (Object)url);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (isr == null) continue;
                        if (throwable2 != null) {
                            try {
                                isr.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        isr.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (inStream == null) continue;
                    if (throwable != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    inStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing to Appendable.", e);
            }
        }
        return bundles;
    }

    private ResourceBundle loadNlsBundle(Logger logger, URL url, String line) {
        if (logger.isTraceEnabled()) {
            logger.trace("Loading resource bundle " + line);
        }
        try {
            ResourceBundle bundleInstance = NlsBundleHelper.getInstance().getResourceBundle(line, AbstractNlsMessage.LOCALE_ROOT);
            return bundleInstance;
        }
        catch (Exception e) {
            logger.error("Illegal bundle declaration {}: Class '{}' is invalid!", new Object[]{url, line, e});
            return null;
        }
    }
}

