/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.mmm.util.lang.api.attribute.AttributeReadTitle;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsObject;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsFormatterPlugin;

@Named
@Singleton
public class NlsFormatterDefault
extends AbstractNlsFormatterPlugin<Object> {
    @Override
    public void format(Object object, Locale locale, Map<String, Object> arguments, NlsTemplateResolver resolver, Appendable buffer) throws IOException {
        String result = null;
        if (object != null) {
            if (object instanceof Number) {
                result = NumberFormat.getInstance(locale).format(object);
            } else if (object instanceof Date) {
                DateFormat format = DateFormat.getDateTimeInstance(3, 1, locale);
                result = format.format(object);
            } else if (object instanceof NlsObject) {
                NlsMessage message = ((NlsObject)object).toNlsMessage();
                if (message != null) {
                    message.getLocalizedMessage(locale, resolver, buffer);
                    return;
                }
            } else if (object instanceof Class) {
                result = ((Class)object).getName();
            } else {
                if (object instanceof Enum || object instanceof AttributeReadTitle) {
                    NlsMessage message = NlsAccess.getFactory().create(object.toString());
                    message.getLocalizedMessage(locale, resolver, buffer);
                    return;
                }
                result = object.toString();
            }
        }
        if (result == null) {
            result = "null";
        }
        buffer.append(result);
    }

    @Override
    public String getStyle() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }
}

