/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor {
    private boolean[] variableUsed = new boolean[64];

    public boolean isVariableUsed(int variableIndex) {
        return this.variableUsed[variableIndex];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int maxLocals = codeAttribute.u2maxLocals;
        if (this.variableUsed.length < maxLocals) {
            this.variableUsed = new boolean[maxLocals];
        } else {
            Arrays.fill(this.variableUsed, 0, maxLocals, false);
        }
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        this.variableUsed[variableInstruction.variableIndex] = true;
        if (variableInstruction.isCategory2()) {
            this.variableUsed[variableInstruction.variableIndex + 1] = true;
        }
    }
}

