/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationToAnnotatedClassVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationToAnnotatedMemberVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedClassVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class ClassSpecificationVisitorFactory {
    public ClassPoolVisitor createClassPoolVisitor(List classSpecifications, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        return this.createClassPoolVisitor(classSpecifications, classVisitor, memberVisitor, memberVisitor, null);
    }

    public ClassPoolVisitor createClassPoolVisitor(List classSpecifications, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor) {
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor();
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(index);
                multiClassPoolVisitor.addClassPoolVisitor(this.createClassPoolVisitor(classSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, null));
            }
        }
        return multiClassPoolVisitor;
    }

    protected ClassPoolVisitor createClassPoolVisitor(ClassSpecification classSpecification, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        String className = classSpecification.className;
        String annotationType = classSpecification.annotationType;
        String extendsAnnotationType = classSpecification.extendsAnnotationType;
        String extendsClassName = classSpecification.extendsClassName;
        if (className == null) {
            className = "**";
        }
        StringMatcher annotationTypeMatcher = annotationType == null ? null : new ListParser(new ClassNameParser(variableStringMatchers)).parse(annotationType);
        StringMatcher classNameMatcher = new ListParser(new ClassNameParser(variableStringMatchers)).parse(className);
        StringMatcher extendsAnnotationTypeMatcher = extendsAnnotationType == null ? null : new ListParser(new ClassNameParser(variableStringMatchers)).parse(extendsAnnotationType);
        StringMatcher extendsClassNameMatcher = extendsClassName == null ? null : new ListParser(new ClassNameParser(variableStringMatchers)).parse(extendsClassName);
        ClassVisitor combinedClassVisitor = this.createCombinedClassVisitor(classSpecification.attributeNames, classSpecification.fieldSpecifications, classSpecification.methodSpecifications, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers);
        if (extendsAnnotationType != null || extendsClassName != null || this.containsWildCards(className)) {
            combinedClassVisitor = new ClassNameFilter(classNameMatcher, combinedClassVisitor);
            className = null;
        }
        if (annotationType != null) {
            combinedClassVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(annotationTypeMatcher, (AnnotationVisitor)new AnnotationToAnnotatedClassVisitor(combinedClassVisitor))));
        }
        if (classSpecification.requiredSetAccessFlags != 0 || classSpecification.requiredUnsetAccessFlags != 0) {
            combinedClassVisitor = new ClassAccessFilter(classSpecification.requiredSetAccessFlags, classSpecification.requiredUnsetAccessFlags, combinedClassVisitor);
        }
        if (extendsAnnotationType != null || extendsClassName != null) {
            combinedClassVisitor = new ClassHierarchyTraveler(false, false, false, true, combinedClassVisitor);
            if (extendsAnnotationType != null) {
                combinedClassVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(extendsAnnotationTypeMatcher, (AnnotationVisitor)new AnnotationToAnnotatedClassVisitor(combinedClassVisitor))));
            }
            if (extendsClassName != null) {
                if (this.containsWildCards(extendsClassName)) {
                    combinedClassVisitor = new ClassNameFilter(extendsClassNameMatcher, combinedClassVisitor);
                } else {
                    className = extendsClassName;
                }
            }
        }
        return className != null ? new NamedClassVisitor(combinedClassVisitor, className) : new AllClassVisitor(combinedClassVisitor);
    }

    protected ClassVisitor createCombinedClassVisitor(List attributeNames, List fieldSpecifications, List methodSpecifications, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        if (fieldSpecifications == null) {
            fieldVisitor = null;
        }
        if (methodSpecifications == null) {
            methodVisitor = null;
        }
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor();
        if (classVisitor != null) {
            if (fieldVisitor == null && methodVisitor == null && attributeVisitor == null) {
                return classVisitor;
            }
            multiClassVisitor.addClassVisitor(classVisitor);
        }
        if (attributeVisitor != null) {
            if (attributeNames != null) {
                attributeVisitor = new AttributeNameFilter(attributeNames, attributeVisitor);
            }
            multiClassVisitor.addClassVisitor(new AllAttributeVisitor(attributeVisitor));
        }
        if (fieldVisitor != null || methodVisitor != null) {
            ClassVisitor memberClassVisitor = this.createClassVisitor(fieldSpecifications, methodSpecifications, fieldVisitor, methodVisitor, attributeVisitor, variableStringMatchers);
            if (classVisitor == null) {
                return memberClassVisitor;
            }
            multiClassVisitor.addClassVisitor(memberClassVisitor);
        }
        return multiClassVisitor;
    }

    private ClassVisitor createClassVisitor(List fieldSpecifications, List methodSpecifications, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor();
        this.addMemberVisitors(fieldSpecifications, true, multiClassVisitor, fieldVisitor, attributeVisitor, variableStringMatchers);
        this.addMemberVisitors(methodSpecifications, false, multiClassVisitor, methodVisitor, attributeVisitor, variableStringMatchers);
        return new ClassHierarchyTraveler(true, true, false, false, multiClassVisitor);
    }

    private void addMemberVisitors(List memberSpecifications, boolean isField, MultiClassVisitor multiClassVisitor, MemberVisitor memberVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                multiClassVisitor.addClassVisitor(this.createClassVisitor(memberSpecification, isField, memberVisitor, attributeVisitor, variableStringMatchers));
            }
        }
    }

    protected ClassPoolVisitor createClassTester(ClassSpecification classSpecification, ClassPoolVisitor classPoolVisitor, List variableStringMatchers) {
        ClassPoolClassVisitor classPoolClassVisitor = new ClassPoolClassVisitor(classPoolVisitor);
        ClassPoolVisitor conditionalClassTester = this.createClassTester(classSpecification, classPoolClassVisitor, variableStringMatchers);
        return new MultiClassPoolVisitor(new ClassPoolVisitor[]{classPoolClassVisitor, conditionalClassTester});
    }

    protected ClassPoolVisitor createClassTester(ClassSpecification classSpecification, ClassVisitor classVisitor, List variableStringMatchers) {
        MultiClassVisitor conditionalMemberTester = new MultiClassVisitor();
        ClassPoolVisitor conditionalClassTester = this.createClassPoolVisitor(classSpecification, conditionalMemberTester, null, null, null, variableStringMatchers);
        conditionalMemberTester.addClassVisitor(this.createClassMemberTester(classSpecification.fieldSpecifications, classSpecification.methodSpecifications, classVisitor, variableStringMatchers));
        return conditionalClassTester;
    }

    private ClassVisitor createClassMemberTester(List fieldSpecifications, List methodSpecifications, ClassVisitor classVisitor, List variableStringMatchers) {
        return this.createClassMemberTester(fieldSpecifications, true, this.createClassMemberTester(methodSpecifications, false, classVisitor, variableStringMatchers), variableStringMatchers);
    }

    private ClassVisitor createClassMemberTester(List memberSpecifications, boolean isField, ClassVisitor classVisitor, List variableStringMatchers) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                classVisitor = this.createClassVisitor(memberSpecification, isField, new MemberToClassVisitor(classVisitor), null, variableStringMatchers);
            }
        }
        return classVisitor;
    }

    private ClassVisitor createClassVisitor(MemberSpecification memberSpecification, boolean isField, MemberVisitor memberVisitor, AttributeVisitor attributeVisitor, List variableStringMatchers) {
        StringMatcher attributesMatcher;
        String annotationType = memberSpecification.annotationType;
        String name = memberSpecification.name;
        String descriptor = memberSpecification.descriptor;
        List attributeNames = memberSpecification.attributeNames;
        StringMatcher annotationTypeMatcher = annotationType == null ? null : new ListParser(new ClassNameParser(variableStringMatchers)).parse(annotationType);
        StringMatcher nameMatcher = name == null ? null : new ListParser(new NameParser(variableStringMatchers)).parse(name);
        StringMatcher descriptorMatcher = name == null ? null : new ListParser(new ClassNameParser(variableStringMatchers)).parse(descriptor);
        StringMatcher stringMatcher = attributesMatcher = attributeNames == null ? null : new ListParser(new NameParser(variableStringMatchers)).parse(attributeNames);
        if (attributeVisitor != null) {
            if (attributesMatcher != null) {
                attributeVisitor = new AttributeNameFilter(attributesMatcher, attributeVisitor);
            }
            memberVisitor = new MultiMemberVisitor(memberVisitor, new AllAttributeVisitor(attributeVisitor));
        }
        if (memberSpecification.annotationType != null) {
            memberVisitor = new AllAttributeVisitor(new AllAnnotationVisitor(new AnnotationTypeFilter(annotationTypeMatcher, (AnnotationVisitor)new AnnotationToAnnotatedMemberVisitor(memberVisitor))));
        }
        if (memberSpecification.requiredSetAccessFlags != 0 || memberSpecification.requiredUnsetAccessFlags != 0) {
            memberVisitor = new MemberAccessFilter(memberSpecification.requiredSetAccessFlags, memberSpecification.requiredUnsetAccessFlags, memberVisitor);
        }
        if (name != null && descriptor != null && !this.containsWildCards(name) && !this.containsWildCards(descriptor)) {
            return isField ? new NamedFieldVisitor(name, descriptor, memberVisitor) : new NamedMethodVisitor(name, descriptor, memberVisitor);
        }
        if (descriptorMatcher != null) {
            memberVisitor = new MemberDescriptorFilter(descriptorMatcher, memberVisitor);
        }
        if (name != null) {
            memberVisitor = new MemberNameFilter(nameMatcher, memberVisitor);
        }
        return isField ? new AllFieldVisitor(memberVisitor) : new AllMethodVisitor(memberVisitor);
    }

    private boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(37) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0 || this.containsWildCardReferences(string));
    }

    private boolean containsWildCardReferences(String string) {
        int openIndex = string.indexOf(60);
        if (openIndex < 0) {
            return false;
        }
        int closeIndex = string.indexOf(62, openIndex + 1);
        if (closeIndex < 0) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(openIndex + 1, closeIndex));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

