/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberClassAccessFilter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class MemberFinder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();
    private final boolean searchHierarchy;
    private Clazz clazz;
    private Member member;

    public MemberFinder() {
        this(true);
    }

    public MemberFinder(boolean searchHierarchy) {
        this.searchHierarchy = searchHierarchy;
    }

    public Field findField(Clazz clazz, String name, String descriptor) {
        return this.findField(null, clazz, name, descriptor);
    }

    public Field findField(Clazz referencingClass, Clazz clazz, String name, String descriptor) {
        return (Field)this.findMember(referencingClass, clazz, name, descriptor, true);
    }

    public Method findMethod(Clazz clazz, String name, String descriptor) {
        return this.findMethod(null, clazz, name, descriptor);
    }

    public Method findMethod(Clazz referencingClass, Clazz clazz, String name, String descriptor) {
        return (Method)this.findMember(referencingClass, clazz, name, descriptor, false);
    }

    public Member findMember(Clazz clazz, String name, String descriptor, boolean isField) {
        return this.findMember(null, clazz, name, descriptor, isField);
    }

    public Member findMember(Clazz referencingClass, Clazz clazz, String name, String descriptor, boolean isField) {
        try {
            MemberFinder memberVisitor;
            boolean containsWildcards = name != null && (name.indexOf(42) >= 0 || name.indexOf(63) >= 0) || descriptor != null && (descriptor.indexOf(42) >= 0 || descriptor.indexOf(63) >= 0);
            this.clazz = null;
            this.member = null;
            MemberVisitor memberVisitor2 = memberVisitor = referencingClass != null && referencingClass.getName() != null ? new MemberClassAccessFilter(referencingClass, this) : this;
            clazz.hierarchyAccept(true, this.searchHierarchy, this.searchHierarchy, false, containsWildcards ? (isField ? new AllFieldVisitor(new MemberNameFilter(name, (MemberVisitor)new MemberDescriptorFilter(descriptor, (MemberVisitor)memberVisitor))) : new AllMethodVisitor(new MemberNameFilter(name, (MemberVisitor)new MemberDescriptorFilter(descriptor, (MemberVisitor)memberVisitor)))) : (isField ? new NamedFieldVisitor(name, descriptor, memberVisitor) : new NamedMethodVisitor(name, descriptor, memberVisitor)));
        }
        catch (MemberFoundException memberFoundException) {
            // empty catch block
        }
        return this.member;
    }

    public Clazz correspondingClass() {
        return this.clazz;
    }

    public boolean isOverriden(Clazz clazz, Method method) {
        String name = method.getName(clazz);
        String descriptor = method.getDescriptor(clazz);
        try {
            this.clazz = null;
            this.member = null;
            clazz.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(name, descriptor, new MemberAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException ex) {
            return true;
        }
        return false;
    }

    public boolean isShadowed(Clazz clazz, Field field) {
        String name = field.getName(clazz);
        String descriptor = field.getDescriptor(clazz);
        try {
            this.clazz = null;
            this.member = null;
            clazz.hierarchyAccept(false, false, false, true, new NamedFieldVisitor(name, descriptor, new MemberAccessFilter(0, 2, this)));
        }
        catch (MemberFoundException ex) {
            return true;
        }
        return false;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        this.clazz = clazz;
        this.member = member;
        throw MEMBER_FOUND;
    }

    private static class MemberFoundException
    extends RuntimeException {
        private MemberFoundException() {
        }
    }
}

