/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.List;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class MemberNameFilter
implements MemberVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final MemberVisitor memberVisitor;

    public MemberNameFilter(String regularExpression, MemberVisitor memberVisitor) {
        this(regularExpression, null, memberVisitor);
    }

    public MemberNameFilter(String regularExpression, List variableStringMatchers, MemberVisitor memberVisitor) {
        this(new ListParser(new NameParser(variableStringMatchers)).parse(regularExpression), memberVisitor);
    }

    public MemberNameFilter(StringMatcher regularExpressionMatcher, MemberVisitor memberVisitor) {
        this.regularExpressionMatcher = regularExpressionMatcher;
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getName(programClass))) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getName(programClass))) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getName(libraryClass))) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getName(libraryClass))) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(String name) {
        return this.regularExpressionMatcher.matches(name);
    }
}

