/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BootstrapMethodRemapper
extends SimplifiedVisitor
implements ConstantVisitor {
    private int[] bootstrapMethodIndexMap;
    private final boolean ignoreDanglingConstants;

    public BootstrapMethodRemapper() {
        this(false);
    }

    public BootstrapMethodRemapper(boolean ignoreDanglingConstants) {
        this.ignoreDanglingConstants = ignoreDanglingConstants;
    }

    public void setBootstrapMethodIndexMap(int[] bootstrapMethodIndexMap) {
        this.bootstrapMethodIndexMap = bootstrapMethodIndexMap;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        dynamicConstant.u2bootstrapMethodAttributeIndex = this.remapConstantIndex(dynamicConstant.u2bootstrapMethodAttributeIndex);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.u2bootstrapMethodAttributeIndex = this.remapConstantIndex(invokeDynamicConstant.u2bootstrapMethodAttributeIndex);
    }

    private int remapConstantIndex(int constantIndex) {
        int remappedConstantIndex = this.bootstrapMethodIndexMap[constantIndex];
        if (remappedConstantIndex < 0) {
            if (this.ignoreDanglingConstants) {
                return constantIndex;
            }
            throw new IllegalArgumentException("Can't remap bootstrap method index [" + constantIndex + "]");
        }
        return remappedConstantIndex;
    }
}

