/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.SaxonXQConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.value.BooleanValue;

public class SaxonXQDataSource
implements XQDataSource,
Configuration.ApiProvider {
    private final Configuration config;
    private PrintWriter logger;
    private static final String[] supportedPropertyNames = new String[]{"allowExternalFunctions", "dtdValidation", "expandAttributeDefaults", "expandXInclude", "retainLineNumbers", "schemaValidationMode", "stripWhitespace", "useXsiSchemaLocation", "xmlVersion", "xsdVersion"};

    public SaxonXQDataSource() {
        this.config = Configuration.newConfiguration();
        this.config.setProcessor((Configuration.ApiProvider)this);
    }

    public SaxonXQDataSource(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public XQConnection getConnection() {
        return new SaxonXQConnection(this);
    }

    @Override
    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQException("Saxon cannot connect to a SQL data source");
    }

    @Override
    public XQConnection getConnection(String username, String password) {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logger;
    }

    @Override
    public String getProperty(String name) throws XQException {
        SaxonXQDataSource.checkNotNull(name, "name");
        switch (name) {
            case "allowExternalFunctions": {
                return this.getAllowExternalFunctions();
            }
            case "dtdValidation": {
                return this.getDtdValidation();
            }
            case "expandAttributeDefaults": {
                return this.getExpandAttributeDefaults();
            }
            case "expandXInclude": {
                return this.getExpandXInclude();
            }
            case "retainLineNumbers": {
                return this.getRetainLineNumbers();
            }
            case "schemaValidationMode": {
                return this.getSchemaValidationMode();
            }
            case "stripWhitespace": {
                return this.getStripWhitespace();
            }
            case "useXsiSchemaLocation": {
                return this.getUseXsiSchemaLocation();
            }
            case "xmlVersion": {
                return this.getXmlVersion();
            }
            case "xsdVersion": {
                return this.getXsdVersion();
            }
        }
        try {
            return this.config.getConfigurationProperty(name).toString();
        }
        catch (IllegalArgumentException e) {
            throw new XQException("Property " + name + " is not recognized");
        }
        catch (NullPointerException err) {
            throw new XQException("Null property name or value");
        }
    }

    @Override
    public String[] getSupportedPropertyNames() {
        return supportedPropertyNames;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logger = out;
    }

    @Override
    public void setProperties(Properties props) throws XQException {
        SaxonXQDataSource.checkNotNull(props, "props");
        Enumeration<Object> iter = props.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            String value = props.getProperty(name);
            this.setProperty(name, value);
        }
    }

    @Override
    public void setProperty(String name, String value) throws XQException {
        SaxonXQDataSource.checkNotNull(name, "name");
        SaxonXQDataSource.checkNotNull(value, "value");
        switch (name) {
            case "allowExternalFunctions": {
                this.setAllowExternalFunctions(value);
                break;
            }
            case "dtdValidation": {
                this.setDtdValidation(value);
                break;
            }
            case "expandAttributeDefaults": {
                this.setExpandAttributeDefaults(value);
                break;
            }
            case "expandXInclude": {
                this.setExpandXInclude(value);
                break;
            }
            case "retainLineNumbers": {
                this.setRetainLineNumbers(value);
                break;
            }
            case "schemaValidationMode": {
                this.setSchemaValidationMode(value);
                break;
            }
            case "stripWhitespace": {
                this.setStripWhitespace(value);
                break;
            }
            case "useXsiSchemaLocation": {
                this.setUseXsiSchemaLocation(value);
                break;
            }
            case "xmlVersion": {
                this.setXmlVersion(value);
                break;
            }
            case "xsdVersion": {
                this.setXsdVersion(value);
                break;
            }
            default: {
                try {
                    this.config.setConfigurationProperty(name, (Object)value);
                    break;
                }
                catch (IllegalArgumentException err) {
                    throw new XQException("Unrecognized property or invalid value for " + name + ": " + err.getMessage());
                }
                catch (NullPointerException err) {
                    throw new XQException("Null property name or value");
                }
            }
        }
    }

    static void checkNotNull(Object arg, String name) throws XQException {
        if (arg == null) {
            throw new XQException("Argument " + name + " is null");
        }
    }

    public void setAllowExternalFunctions(String value) {
        if ("true".equals(value)) {
            this.config.setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, true);
        } else if ("false".equals(value)) {
            this.config.setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, false);
        } else {
            throw new IllegalArgumentException("allowExternalFunctions");
        }
    }

    public String getAllowExternalFunctions() {
        return this.config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS) ? "true" : "false";
    }

    public void setDtdValidation(String value) {
        if ("true".equals(value)) {
            this.config.setValidation(true);
        } else if ("false".equals(value)) {
            this.config.setValidation(false);
        } else {
            throw new IllegalArgumentException("dtdValidation");
        }
    }

    public String getDtdValidation() {
        return this.config.isValidation() ? "true" : "false";
    }

    public void setExpandAttributeDefaults(String value) {
        if ("true".equals(value)) {
            this.config.setExpandAttributeDefaults(true);
        } else if ("false".equals(value)) {
            this.config.setExpandAttributeDefaults(false);
        } else {
            throw new IllegalArgumentException("expandAttributeDefaults");
        }
    }

    public String getExpandAttributeDefaults() {
        return this.config.isExpandAttributeDefaults() ? "true" : "false";
    }

    public void setExpandXInclude(String value) {
        if ("true".equals(value)) {
            this.config.setXIncludeAware(true);
        } else if ("false".equals(value)) {
            this.config.setXIncludeAware(false);
        } else {
            throw new IllegalArgumentException("expandXInclude");
        }
    }

    public String getExpandXInclude() {
        return this.config.isXIncludeAware() ? "true" : "false";
    }

    public void setRetainLineNumbers(String value) {
        if ("true".equals(value)) {
            this.config.setLineNumbering(true);
        } else if ("false".equals(value)) {
            this.config.setLineNumbering(false);
        } else {
            throw new IllegalArgumentException("retainLineNumbers");
        }
    }

    public String getRetainLineNumbers() {
        return this.config.isLineNumbering() ? "true" : "false";
    }

    public void setSchemaValidationMode(String value) {
        if ("strict".equals(value)) {
            this.config.setSchemaValidationMode(1);
        } else if ("lax".equals(value)) {
            this.config.setSchemaValidationMode(2);
        } else if ("skip".equals(value)) {
            this.config.setSchemaValidationMode(4);
        } else {
            throw new IllegalArgumentException("schemaValidationMode");
        }
    }

    public String getSchemaValidationMode() {
        return Validation.describe((int)this.config.getSchemaValidationMode());
    }

    public void setStripWhitespace(String value) {
        if ("all".equals(value)) {
            this.config.getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)AllElementsSpaceStrippingRule.getInstance());
        } else if ("ignorable".equals(value)) {
            this.config.getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)IgnorableSpaceStrippingRule.getInstance());
        } else if ("none".equals(value)) {
            this.config.getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)NoElementsSpaceStrippingRule.getInstance());
        } else {
            throw new IllegalArgumentException("stripWhitespace");
        }
    }

    public String getStripWhitespace() {
        SpaceStrippingRule rule = this.config.getParseOptions().getSpaceStrippingRule();
        if (rule == AllElementsSpaceStrippingRule.getInstance()) {
            return "all";
        }
        if (rule == IgnorableSpaceStrippingRule.getInstance()) {
            return "ignorable";
        }
        return "none";
    }

    public void setUseXsiSchemaLocation(String value) {
        if ("true".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", (Object)BooleanValue.TRUE);
        } else if ("false".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", (Object)BooleanValue.FALSE);
        } else {
            throw new IllegalArgumentException("useXsiSchemaLocation");
        }
    }

    public String getUseXsiSchemaLocation() {
        Boolean b = (Boolean)this.config.getConfigurationProperty(Feature.USE_XSI_SCHEMA_LOCATION);
        return b != false ? "true" : "false";
    }

    public void setXmlVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setXMLVersion(10);
        } else if ("1.1".equals(value)) {
            this.config.setXMLVersion(11);
        } else {
            throw new IllegalArgumentException("xmlVersion");
        }
    }

    public String getXmlVersion() {
        return this.config.getXMLVersion() == 10 ? "1.0" : "1.1";
    }

    public void setXsdVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)"1.0");
        } else if ("1.1".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", (Object)"1.1");
        } else {
            throw new IllegalArgumentException("xsdVersion");
        }
    }

    public String getXsdVersion() {
        return (String)this.config.getConfigurationProperty(Feature.XSD_VERSION);
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        try {
            this.config.registerExtensionFunction(function);
        }
        catch (Exception err) {
            throw new IllegalArgumentException(err);
        }
    }
}

