/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullEvent;
import net.sf.saxon.pull.UnfailingPullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class TreeWalker
implements UnfailingPullProvider,
Location {
    private final NodeInfo startNode;
    private NodeInfo currentNode;
    private PullEvent currentEvent = PullEvent.START_OF_INPUT;
    private final Stack<FocusIterator> iteratorStack = new Stack();
    private PipelineConfiguration pipe;
    private final NamespaceBinding[] nsBuffer = new NamespaceBinding[10];

    public static UnfailingPullProvider makeTreeWalker(NodeInfo startNode) {
        return new TreeWalker(startNode);
    }

    private TreeWalker(NodeInfo startNode) {
        this.startNode = startNode;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public PullEvent next() throws XPathException {
        switch (this.currentEvent) {
            case START_OF_INPUT: {
                this.currentNode = this.startNode;
                switch (this.currentNode.getNodeKind()) {
                    case 9: {
                        this.currentEvent = PullEvent.START_DOCUMENT;
                        return this.currentEvent;
                    }
                    case 1: {
                        this.currentEvent = PullEvent.START_ELEMENT;
                        return this.currentEvent;
                    }
                    case 3: {
                        this.currentEvent = PullEvent.TEXT;
                        return this.currentEvent;
                    }
                    case 8: {
                        this.currentEvent = PullEvent.COMMENT;
                        return this.currentEvent;
                    }
                    case 7: {
                        this.currentEvent = PullEvent.PROCESSING_INSTRUCTION;
                        return this.currentEvent;
                    }
                    case 2: {
                        this.currentEvent = PullEvent.ATTRIBUTE;
                        return this.currentEvent;
                    }
                    case 13: {
                        this.currentEvent = PullEvent.NAMESPACE;
                        return this.currentEvent;
                    }
                }
                throw new IllegalStateException();
            }
            case START_DOCUMENT: 
            case START_ELEMENT: {
                FocusTrackingIterator kids = new FocusTrackingIterator((SequenceIterator)this.currentNode.iterateAxis(3));
                this.iteratorStack.push((FocusIterator)kids);
                this.currentNode = (NodeInfo)kids.next();
                if (this.currentNode != null) {
                    this.currentEvent = this.mapChildNodeEvent();
                    return this.currentEvent;
                }
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentNode = this.startNode;
                }
                if (this.currentEvent == PullEvent.START_DOCUMENT) {
                    this.currentEvent = PullEvent.END_DOCUMENT;
                    return this.currentEvent;
                }
                this.currentEvent = PullEvent.END_ELEMENT;
                return this.currentEvent;
            }
            case TEXT: 
            case COMMENT: 
            case PROCESSING_INSTRUCTION: 
            case END_ELEMENT: {
                if (this.iteratorStack.isEmpty()) {
                    if (this.currentNode == this.startNode) {
                        this.currentNode = null;
                        this.currentEvent = PullEvent.END_OF_INPUT;
                        return this.currentEvent;
                    }
                    this.currentNode = this.startNode;
                    if (this.currentNode.getNodeKind() == 1) {
                        this.currentEvent = PullEvent.END_ELEMENT;
                        return this.currentEvent;
                    }
                    this.currentEvent = PullEvent.END_DOCUMENT;
                    return this.currentEvent;
                }
                FocusIterator siblings = this.iteratorStack.peek();
                this.currentNode = (NodeInfo)siblings.next();
                if (this.currentNode == null) {
                    this.iteratorStack.pop();
                    if (this.iteratorStack.isEmpty()) {
                        this.currentNode = this.startNode;
                        if (this.currentNode.getNodeKind() == 1) {
                            this.currentEvent = PullEvent.END_ELEMENT;
                            return this.currentEvent;
                        }
                        this.currentEvent = PullEvent.END_DOCUMENT;
                        return this.currentEvent;
                    }
                    FocusIterator uncles = this.iteratorStack.peek();
                    this.currentNode = (NodeInfo)uncles.current();
                    if (this.currentNode.getNodeKind() == 9) {
                        this.currentEvent = PullEvent.END_DOCUMENT;
                        return this.currentEvent;
                    }
                    this.currentEvent = PullEvent.END_ELEMENT;
                    return this.currentEvent;
                }
                this.currentEvent = this.mapChildNodeEvent();
                return this.currentEvent;
            }
            case ATTRIBUTE: 
            case NAMESPACE: 
            case END_DOCUMENT: {
                this.currentEvent = PullEvent.END_OF_INPUT;
                return this.currentEvent;
            }
            case END_OF_INPUT: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    private PullEvent mapChildNodeEvent() {
        switch (this.currentNode.getNodeKind()) {
            case 1: {
                return PullEvent.START_ELEMENT;
            }
            case 3: {
                return PullEvent.TEXT;
            }
            case 8: {
                return PullEvent.COMMENT;
            }
            case 7: {
                return PullEvent.PROCESSING_INSTRUCTION;
            }
        }
        throw new IllegalStateException();
    }

    public PullEvent current() {
        return this.currentEvent;
    }

    public AttributeMap getAttributes() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            return this.currentNode.attributes();
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceBinding[] getNamespaceDeclarations() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            if (this.iteratorStack.isEmpty()) {
                Iterator iter = this.currentNode.getAllNamespaces().iterator();
                ArrayList list = new ArrayList();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray(NamespaceBinding.EMPTY_ARRAY);
            }
            return this.currentNode.getDeclaredNamespaces(this.nsBuffer);
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not ELEMENT_START");
    }

    public PullEvent skipToMatchingEnd() {
        switch (this.currentEvent) {
            case START_DOCUMENT: {
                this.currentEvent = PullEvent.END_DOCUMENT;
                return this.currentEvent;
            }
            case START_ELEMENT: {
                this.currentEvent = PullEvent.END_ELEMENT;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public NodeName getNodeName() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        return NameOfNode.makeName((NodeInfo)this.currentNode);
    }

    public UnicodeString getStringValue() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        if (this.currentNode.getNodeKind() == 1) {
            this.skipToMatchingEnd();
        }
        return this.currentNode.getUnicodeStringValue();
    }

    public SchemaType getSchemaType() {
        if (this.currentNode == null) {
            throw new IllegalStateException("No current node");
        }
        return this.currentNode.getSchemaType();
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public Location getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.currentNode == null ? this.startNode.getSystemId() : this.currentNode.getSystemId();
    }

    public int getLineNumber() {
        return this.currentNode == null ? -1 : this.currentNode.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    public Location saveLocation() {
        return new Loc((SourceLocator)((Object)this));
    }

    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

