/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AnyURIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
extends SystemFunction
implements CallableExpression {
    public static String EMPTY_COLLECTION = "http://saxon.sf.net/collection/empty";
    private String expressionBaseURI = null;

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF | 0x80000;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    public SequenceIterator<Item> iterate(XPathContext context) throws XPathException {
        SequenceIterator iter;
        Item arg;
        String href = this.getNumberOfArguments() == 0 ? context.getController().getDefaultCollection() : ((arg = this.argument[0].evaluateItem(context)) == null ? context.getController().getDefaultCollection() : arg.getStringValue());
        if (EMPTY_COLLECTION.equals(href)) {
            return EmptyIterator.emptyIterator();
        }
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            if (e.getErrorCodeQName() == null) {
                e.setErrorCode("FODC0002");
            }
            throw e;
        }
        return Collection.getResolverResults(iter, this.expressionBaseURI, context, this);
    }

    public static SequenceIterator getResolverResults(SequenceIterator iter, final String baseURI, final XPathContext context, final SourceLocator locator) {
        if (iter == null) {
            return EmptyIterator.getInstance();
        }
        ItemMappingFunction imf = new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return item;
                }
                if (item instanceof AnyURIValue) {
                    return DocumentFn.makeDoc(item.getStringValue(), baseURI, context, locator);
                }
                if (item instanceof Source) {
                    return context.getConfiguration().buildDocument((Source)((Object)item));
                }
                throw new XPathException("Value returned by CollectionURIResolver must be a Source or an anyURI");
            }
        };
        return new ItemMappingIterator(iter, imf);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        SequenceIterator iter;
        Object arg;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : ((arg = arguments[0].next()) == null ? context.getConfiguration().getDefaultCollection() : arg.getStringValue());
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return Collection.getResolverResults(iter, this.expressionBaseURI, context, this);
    }
}

